#file: scripting.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

#This file controls the datafile scripting, both loading and executing.


import g
import main
import battle
import monster

#set to 1 whenever the player really shouldn't be moving.
global has_dialog
has_dialog = 0



#Activate one line of scripting. See scripting.txt for details.
#returns either 0<= (failure), >0 (success),
#or "end" (end script).
def activate_line(x, y, z, command, tile_type=""):

	global has_dialog
	return_num = 0
	switch = command.split(None, 1)[0].lower()
	global just_found

	if command.isdigit() == 1: #if command is a number
		return_num = int(command)
	elif command[:1] == "-" and command[1:].isdigit() == 1:
		return_num = int(command)

	elif switch == "addpix": #add a picture to the tile.
		g.maps[z].field[y][x].add_pix(g.tiles[command.split(None, 2)[1]])
		return_num = 1

	elif switch == "addskill": #add a skill
		temp = g.findskill(command.split(None, 1)[1])
		if temp == -1:
			print "Unknown skill: " + command.split(None, 2)[1]
			return_num = 0
		else:
			return_num = g.add_skill(temp)
	elif switch == "attack":  #cause creature to attack
		temp = -1
		if command.split(None, 2)[1].lower() == "random":
			#battle random monster
			i = g.mapname2zgrid(command.split(None, 2)[2])
			temp = monster.find_level_monster(i)
		else:
			#battle named monster
			for monster_num in range(len(monster.monsters)):
				if monster.monsters[monster_num].name.lower() == \
				command.split(None, 1)[1].lower():
					temp = monster_num
					break
			else:
				print "monster " + command.split()[1] + " not found"
		#if there exists a monster to battle:
		if temp != -1:
			return_num = main.start_battle(temp)

	elif switch == "delpix": #remove a picture from the tile.
		try:
			g.maps[z].field[y + g.ygrid][x + g.xgrid].del_pix(
				g.tiles[command.split(None, 2)[1]])
			return_num = 1
		except ValueError:
			return_num = 0

	elif switch == "die":  #process endgame.txt script
		g.hp = -1
		for line in g.endgame_act:
			activate_line(g.xgrid, g.ygrid, g.zgrid, line)
		return_num = "end"

	elif switch == "end":  #end the script
		return_num = "end"

	elif switch  == "find":
		find_info = command.split("\"", 2)
		founditem = find_info[1].strip()
		amount = find_info[2].strip()
		main.print_message("You found " + amount + " " + founditem + ".")
		has_dialog = 1
		if main.show_yesno("You found " + amount + " " + founditem +
				"! Would you like to pick it up ?"):
			if(founditem == "gold"):
				g.gold = int(g.gold) + int(amount)
				main.print_message("You picked up " + amount + " " +
						founditem + ".")
				has_dialog = 0
				return 1
			if( g.take_inv_item(g.finditem(founditem)) != -1):
				main.print_message("You picked up " + amount + " " +
						founditem + ".")
				has_dialog = 0
				return 1
			else:
				main.print_message("You have no room for the " +
						founditem + ".")
				has_dialog = 0
				return 0
		else:
			has_dialog = 0
			return 0

	elif switch == "give":  #Change stats. Note that negatve numbers also work
		switch2 = command.split(None, 2)[1].lower()
		#interpret the second part of the command
		set_to = command.split(None, 2)[2]
		set_to = activate_line(x, y, z, command.split(None, 2)[2])

		if switch2 == "hp":
			g.hp = g.hp + int(set_to)
			if g.hp >= g.maxhp: g.hp = g.maxhp
		elif switch2 == "ep":
			g.ep = g.ep + int(set_to)
			if g.ep >= g.maxep: g.ep = g.maxep
			if g.ep < 0: g.ep = 0
		elif switch2 == "maxhp":
			g.maxhp = g.maxhp + int(set_to)
			if 1 > g.maxhp: g.maxhp = 1
		elif switch2 == "maxep":
			g.maxep = g.maxep + int(set_to)
			if 1 > g.maxep: g.maxep = 1
		elif switch2 == "attack":
			g.attack = g.attack + int(set_to)
			if 1 > g.attack: g.attack = 1
		elif switch2 == "defense":
			g.defense = g.defense + int(set_to)
			if 1 > g.defense: g.defense = 1
		elif switch2 == "gold":
			g.gold = int(g.gold) + int(set_to)
			if 1 > g.gold: g.gold = 0
		elif switch2 == "exp":
			g.exp = g.exp + int(set_to)
			if 1 > g.exp: g.exp = 0
			if int(g.exp) >= int(10*(g.level + 1)*(g.level + 1)):
				g.level=g.level+1
				for i in g.levelup:
					activate_line(x, y, z, i)
		elif switch2 == "skillpoints":
			g.skillpoints = g.skillpoints + int(set_to)
			if 1 > g.skillpoints: g.skillpoints = 0
		else:
			print "Unknown stat: " + switch2
		if set_to == 0: return_num = 0
		else: return_num = 1

	elif switch == "hero":  #change hero pix
		g.cur_hero = "people/" + command.split(None, 2)[1] + ".png"
		main.refreshmap()

	elif switch == "hurt":  #hurt player (reduced by armor)
		#interpret the second part of the command
		set_to = command.split(None, 1)[1]
		set_to = activate_line(x, y, z, command.split(None, 1)[1])
		if set_to == "end": return "end"
		damage = g.die_roll(1, int(set_to) + 2)
		damage = damage - g.die_roll(1, g.adj_defense + 2)
		g.hp = g.hp - damage
		return_num = 1

	elif switch == "if":  #if statement.
		temp = command.split("|", 1)[0]
		temp = temp[2:].strip()
		compare = 0
		if (temp.find("<=") > 0): #note that <= and >= need to come before =
			line_return1 = \
				activate_line(x, y, z, temp.split("<=", 1)[0].strip())
			line_return2 = \
				activate_line(x, y, z, temp.split("<=", 1)[1].strip())
			if (line_return1 <= line_return2):
				compare = 1
		elif (temp.find(">=") > 0):
			line_return1 = \
				activate_line(x, y, z, temp.split(">=", 1)[0].strip())
			line_return2 = \
				activate_line(x, y, z, temp.split(">=", 1)[1].strip())
			if (line_return1 >= line_return2):
				compare = 1
		elif (temp.find("=") > 0): #this catches = and ==
			line_return1 =activate_line(x, y, z, temp.split("=", 1)[0].strip())
			line_return2 =activate_line(x, y, z, temp.split("=", 1)[1].strip())
			if (line_return1 == line_return2):
				compare = 1
		elif (temp.find("<") > 0):
			line_return1 =activate_line(x, y, z, temp.split("<", 1)[0].strip())
			line_return2 =activate_line(x, y, z, temp.split("<", 1)[1].strip())
			if (line_return1 < line_return2):
				compare = 1
		elif (temp.find(">") > 0):
			line_return1 =activate_line(x, y, z, temp.split(">", 1)[0].strip())
			line_return2 =activate_line(x, y, z, temp.split(">", 1)[1].strip())
			if (line_return1 > line_return2):
				compare = 1
		else: #of the form eg "if var something | ? | ?"
			line_return1 = activate_line(x, y, z, temp)
			line_return2 = 0
			if (line_return1 > 0):
				compare = 1

		if (line_return1 == "end"):  #something that should end the script
			return_num = "end"
		elif (line_return2 == "end"):
			return_num = "end"
		elif (compare == 1): #first
			if main.dead_yet() != 1:
				return_num = activate_line(x, y, z, command.split("|",
					2)[1].strip(), tile_type)
			else: return_num = "end"
		else:  #second
			if main.dead_yet() != 1:
				return_num = activate_line(x, y, z, command.split("|",
					2)[2].strip(), tile_type)
			else: return_num = "end"

	elif switch == "info":  #display messagebox
		has_dialog = 1
		main.print_message(command.split(None, 1)[1])
		has_dialog = 0
		return_num = 1

	elif switch == "is_equipped": #is the given item equipped?
		match = command.split(None, 1)[1].strip().lower()
		for item_title in g.equip:
			if g.item[item_title][0].strip().lower() == match:
				return 1
		return 0

	elif switch == "item":  #give item
		if g.take_inv_item(g.finditem(command.split(None, 1)[1])) == -1:
			return_num = 0
		else: return_num = 1

	elif switch == "lose":
		g.hp = -1
		main.close_window()
		return_num = "end"

	elif switch == "move":  #move the player
		curr_zgrid = g.zgrid
		temp_zgrid = g.mapname2zgrid(command.split()[1])
		if temp_zgrid != -1:
			g.zgrid = temp_zgrid
		g.xgrid = int(command.split()[2])
		g.ygrid = int(command.split()[3])
		if curr_zgrid != g.zgrid:
			main.process_onload()
		main.refreshmap()
		g.allow_move = 0
		return_num = 1

	elif switch == "pass":  #do nothing
		return_num = 1

	elif switch == "pix":  #change tile picture
		g.maps[z].field[y][x].pix = \
			g.tiles[command.split(None, 2)[1]]
		g.maps[z].field[y][x].addpix = []
		return_num = 1

	elif switch == "question":  #yes/no dialog box
		has_dialog = 1
		if main.show_yesno(command.split(None, 1)[1]):
			return_num = 1
		else:
			return_num = 0
		has_dialog = 0

	elif switch == "refresh": #refresh the screen manually.
		main.refreshmap()
		return_num = 1

	elif switch == "rng":  #Random Number Generator
		temp = g.die_roll(1, int(command.split(None, 2)[2]))
		if int(command.split(None, 2)[1]) >= temp:
			return_num = temp
		else: return_num = 0

	elif switch == "run":  #Run the actions of a different tile.
		temp_zgrid = g.mapname2zgrid(command.split()[1])
		if temp_zgrid == -1:
			temp_zgrid = g.zgrid
		x = int(command.split()[2])
		y = int(command.split()[3])
		return_num = 1
		#if there are no actions, leave immediately
		if len(g.maps[temp_zgrid].field[y][x].actions) == 0: return 1
		i = 0
		#go through all action lines.
		while i < len(g.maps[temp_zgrid].field[y][x].actions):
			temp = activate_line(x, y, temp_zgrid,
				g.maps[temp_zgrid].field[y][x].actions[i])
			if temp == "end": break
			if main.dead_yet() == 1:
				return_num = "end"
				break
			i += 1

	elif switch == "set":  #set variable (in g.var_list)
		command2 = command.split(None, 1)[1].strip()
		if -1 != command2.find("="):
			g.var_list[command2.split("=", 1)[0].lower().strip()] = \
				command2.split("=", 1)[1].strip()
			return_num = 1
		elif -1 != command2.find("+"):
			if 0 == \
				g.var_list.has_key(command2.split("+", 1)[0].lower().strip()):
				g.var_list[command2.split("+", 1)[0].lower().strip()] = 0
			g.var_list[command2.split("+", 1)[0].lower().strip()] = \
			int(g.var_list[command2.split("+", 1)[0].lower().strip()]) + \
			int(command2.split("+", 1)[1].strip())
			return_num = 1
		elif -1 != command2.find("-"):
			if 0 == \
				g.var_list.has_key(command2.split("-", 1)[0].lower().strip()):
				g.var_list[command2.split("-", 1)[0].lower().strip()] = 0
			g.var_list[command2.split("-", 1)[0].lower().strip()] = \
			int(g.var_list[command2.split("-", 1)[0].lower().strip()]) - \
			int(command2.split("-", 1)[1].strip())
			return_num = 1
		else: #no modifier; use =
			g.var_list[command.split(None, 2)[1].lower()] = \
				command.split(None, 2)[2]
			return_num = 1

	elif switch == "stat":  #return stat
		switch2 = command.split(None, 2)[1].lower()
		if switch2 == "hp":
			return_num = g.hp
		elif switch2 == "ep":
			return_num = g.ep
		elif switch2 == "maxhp":
			return_num = g.maxhp
		elif switch2 == "maxep":
			return_num = g.maxep
		elif switch2 == "attack":
			return_num = g.attack
		elif switch2 == "defense":
			return_num = g.defense
		elif switch2 == "gold":
			return_num = g.gold
		elif switch2 == "exp":
			return_num = g.exp
		elif switch2 == "level":
			return_num = g.level
		elif switch2 == "skillpoints":
			return_num = g.skillpoints
		else:
			print "Unknown stat: " + switch2
			return_num = 0

	elif switch == "store":  #enter store
		has_dialog = 1
		main.enter_store(command.split(None, 1)[1])
		has_dialog = 0
		return_num = 1

	elif switch == "take":  #Take/drop item, by name.
		temp = g.find_inv_item(g.finditem(command.split(None, 1)[1]))
		if temp == -1:
			return_num = 0
		else:
			g.drop_inv_item(temp)
			return_num = 1

	elif switch == "var":  #return variable (in g.var_list)
		command2 = command.split(None, 1)[1].lower().strip()
		if (g.var_list.has_key(command2)):
			if g.var_list[command2].isdigit():
				return_num = int(g.var_list[command2])
			else: return_num = g.var_list[command2]
		else: return_num = 0

	elif switch == "walk":  #change tile walkability
		g.maps[z].field[y][x].walk = \
				int(command.split(None, 1)[1])
		return_num = 1

	elif switch == "win":  #process wingame.txt script
		for line in g.wingame_act:
			activate_line(g.xgrid, g.ygrid, g.zgrid, line)
		return_num = 1

	else:
		print "Bad action of: " + switch + " given."
		return_num = 0
	return return_num
