#file: scripting.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

#This file controls the loading of datafiles.

#needed for map loading
from os import listdir

import g


#map data. Class tile contains data on each tile,
# and is a subclass of map.
#Class map contains data on each map, and the tiles contained within.
class tile:
	def __init__(self, symbol):
		self.pix = ""
		self.name = symbol
		self.walk = 0
		self.onload = []
		self.actions = []
		self.addpix = []
	def add_act(self, action):
		self.actions.append(action)
	def add_pix(self, picture):
		self.addpix.append(picture)
	def del_pix(self, picture):
		self.addpix.remove(picture)

class map:
	def __init__(self, mapname):
		self.name = mapname
		self.field = [] #multidimentional array of tile class members.
		self.monster = [] #monsters that can attack on this level.

		self.maptext = [] #unused after load
		self.tiles = {} #unused after load
		self.per_tile_info = [] #unused after load

		#grab the needed data from the file
		if mapname == "": return
		map_loc = g.mod_directory + "/data/maps/" + mapname
		try: map_file = open(map_loc, 'r')
		except IOError: return

		#go through all lines of the file up to ":def"
		map_line = map_file.readline()
		while map_line != '' and map_line[:1] != ":":
			#strip out leading and trailing whitespace
			map_line = map_line.strip()

			#ignore blank lines and comments
			if map_line[:1] == "#" or map_line[:1] == "" \
											or map_line[:1] == "\n":
				map_line = map_file.readline()
				continue

			#add the line
			line = map_line.split(" ")
			self.maptext.append(line)

			#ready another line
			map_line = map_file.readline()

		#input the map data
		map_line = map_file.readline()
		while map_line != '' and map_line[:1] != ":":
			#strip out spaces/tabs
			map_line = map_line.strip()

			#ignore blank lines and comments
			if map_line[:1] == "#" or map_line[:1] == "":
				map_line = map_file.readline()
				continue

			#allow the \ line-continuation character.
			if map_line[-1:] == "\\": #really a single backslash, BTW.
				map_line = map_line[:-1] + map_file.readline()

			map_command = map_line.split("=", 2)[0]
			map_command = map_command.strip()
			if map_command.lower() == "monster":
				self.monster.append(map_line.split("=", 1)[1])
			else:
				print "bad command of " + map_command + " received"

			#ready another line
			map_line = map_file.readline()

		#input tile data
		current_tile = ""
		mode=0
		while map_line != '':
			#strip out spaces/tabs
			map_line = map_line.strip()

			#ignore blank lines and comments
			if map_line[:1] == "#" or map_line[:1] == "":
				map_line = map_file.readline()
				continue

			#allow the \ line-continuation character.
			while map_line[-1:] == "\\":  #really a single backslash, BTW.
				map_line = map_line[:-1] + map_file.readline()[:-1] #for \n
			#is this line giving us a new tile?
			if map_line[:1] == ":":
				current_tile = map_line[1:]
#				self.add_tile(current_tile)
				map_line = map_file.readline()
				self.tiles[current_tile] = [[], []]
				mode=0
				continue

			#if per-tile information was given
			if map_line[:2].lower() == "xy":
				map_line = map_file.readline()
				map_line = map_line.strip()

				while map_line != '':
					#strip out spaces/tabs
					map_line = map_line.strip()

					#ignore blank lines and comments
					if map_line[:1] == "#" or map_line[:1] == "":
						map_line = map_file.readline()
						continue

					#allow the \ line-continuation character.
					while map_line[-1:] == "\\":  #really a single backslash.
						map_line = map_line[:-1] + map_file.readline()[:-1] #for \n


					if map_line.lower() == "tiles": #switch back
						map_line = map_file.readline()
						break

					#is this line giving us a new tile?
					if map_line[:1] == ":":
						curr_x = int(map_line[1:].split()[0].strip())
						curr_y = int(map_line[1:].split()[1].strip())
						self.per_tile_info.append([curr_x, curr_y, [], []])
						map_line = map_file.readline()
						tilemode=0
						continue

					map_command = map_line.strip()
					if map_command.lower() == "onload":
						tilemode=0
						map_line = map_file.readline()
						continue

					if map_command.lower() == "action":
						tilemode=1
						map_line = map_file.readline()
						continue

					elif tilemode == 0: #onload
						self.per_tile_info[len(self.per_tile_info)-1][2].append(map_command)
					else: #action
						self.per_tile_info[len(self.per_tile_info)-1][3].append(map_command)
					map_line = map_file.readline()
				continue

			map_command = map_line.strip()
			if map_command.lower() == "onload":
				mode=0
				map_line = map_file.readline()
				continue

			if map_command.lower() == "action":
				mode=1
				map_line = map_file.readline()
				continue




			elif mode == 0: #onload
				self.tiles[current_tile][0].append(map_command)
			else: #action
				self.tiles[current_tile][1].append(map_command)

			#ready another line
			map_line = map_file.readline()

		map_file.close()

		#place the formatted data into self.field
		cur_line=0
		for line in self.maptext:
			self.field.append([])
			cur_char = 0
			for character in line:
				self.field[cur_line].append(tile(character))
				for line in self.tiles[character][0]:
					self.field[cur_line][cur_char].onload.append(line)
				for line in self.tiles[character][1]:
					self.field[cur_line][cur_char].actions.append(line)
				cur_char += 1
			cur_line += 1

		#place the per-tile data into self.field
		for line in self.per_tile_info:
			for onload_line in line[2]:
				self.field[line[1]][line[0]].onload.append(onload_line)
			for action_line in line[3]:
				self.field[line[1]][line[0]].actions.append(action_line)

	def add_tile(self, tile_name):
		new_tile = tile(tile_name)
		self.tiles[tile_name] = new_tile

#this is the actual array for the maps. Call with g.maps[g.zgrid]
maps = []

#read the data/maps directory and place in maps[]. This called at startup.
def read_maps():

	#put the names of the available maps in array_maps.
	array_maps = listdir(g.mod_directory + "/data/maps")

	#remove all .* files.
	i = 0
	while i < len(array_maps):
		#print array_maps[i]
		extension_start = len(array_maps[i]) - 4
		if(extension_start <= 0):
			array_maps.pop(i)
		else:
			if array_maps[i][:1] == ".":
				array_maps.pop(i)
			elif array_maps[i][extension_start:extension_start+4] != ".txt":
				array_maps.pop(i)
			else:
				i += 1

	#go through all maps, adding them to our knowledge.
	for mapname in array_maps:
		maps.append(map(mapname))



#given a filename, return the script contained in the file.
#called from read_scripts()
def read_script_file(file_name):
	temp_array = []
	file = open(file_name, 'r')

	#go through all lines of the file
	file_line = file.readline()
	while file_line != '':
		#strip out spaces/tabs
		file_line = file_line.strip()

		#ignore blank lines and comments
		if file_line[:1] == "#" or file_line[:1] == "":
			file_line = file.readline()
			continue

		#allow the \ line-continuation character.
		while file_line[-1:] == "\\":  #really a single backslash, BTW.
			file_line = file_line[:-1] + file.readline()[:-1]

		temp_array.append(file_line)

		#ready another line
		file_line = file.readline()

	file.close()
	return temp_array


endgame_act = []
wingame_act = []
newgame_act = []
levelup_act = []
#read scripts from disk, and place in *_act[]
def read_scripts():
	#This is a bit weird, but Python does not allow the simple way.
	global endgame_act
	global wingame_act
	global newgame_act
	global levelup_act
	endgame = read_script_file(g.mod_directory + "/data/endgame.txt")
	wingame = read_script_file(g.mod_directory + "/data/wingame.txt")
	newgame = read_script_file(g.mod_directory + "/data/newgame.txt")
	levelup = read_script_file(g.mod_directory + "/data/levelup.txt")

	for line in endgame: endgame_act.append(line)
	for line in wingame: wingame_act.append(line)
	for line in newgame: newgame_act.append(line)
	for line in levelup: levelup_act.append(line)


#shop data.
class shop_item:
	def __init__(self, name):
		self.item_name = name
		itemnum = g.finditem(name)
		self.cost = 0
		self.buytype = "gold"
		self.power = 0
		self.description = ""
		self.actions = []
		#if adding an actual item, initialize to the item's qualities.
		if (itemnum != -1):
			self.cost = g.item[itemnum][3]
			self.buytype = "gold"
			self.power = g.item[itemnum][2]
			self.description = g.item[itemnum][4]

	def add_cost(self, itemcost):
		self.cost = itemcost
	def add_buytype(self, itembuytype):
		self.buytype = itembuytype
	def add_power(self, itempower):
		self.power = itempower
	def add_description(self, itemdescription):
		self.description = itemdescription
	def add_act(self, action):
		self.actions.append(action)

class shop:
	def __init__(self, shopname):
		self.name = shopname.strip()
		self.itemlist = []
		self.curitem = -1

	def additem(self, itemname):
		self.itemlist.append(shop_item(itemname))
		self.curitem += 1
	def item_add_cost(self, itemcost):
		self.itemlist[self.curitem].add_cost(itemcost)
	def item_add_buytype(self, itembuytype):
		self.itemlist[self.curitem].add_buytype(itembuytype)
	def item_add_power(self, itempower):
		self.itemlist[self.curitem].add_power(itempower)
	def item_add_description(self, itemdescription):
		self.itemlist[self.curitem].add_description(itemdescription)
	def item_add_act(self, action):
		self.itemlist[self.curitem].add_act(action)

shops = []

#read and interpret shops.txt. Must be called after read_items()
#Places data into shops[].
def read_shops():
	#grab the needed data from the file
	shop_loc = g.mod_directory + "/data/shops.txt"
	shop_file = open(shop_loc, 'r')

	cur_shop = -1

	#go through all lines of the file, splitting along :Store
	shop_line = shop_file.readline()
	while shop_line != '': #till EOF
		#strip out spaces/tabs
		shop_line = shop_line.strip()
		#ignore blank lines and comments
		if shop_line[:1] == "#" or shop_line[:1] == "":
			shop_line = shop_file.readline()
			continue

		if (shop_line[:5].lower() == ":shop"):
			shops.append(shop(shop_line[5:].strip()))
			cur_shop += 1
		elif (shop_line[:5].lower() == ":item"):
			shops[cur_shop].additem(shop_line[5:].strip())
		else:
			command = shop_line.split("=")
			command[0].strip().lower()
			if (command[0].strip().lower() == "description"):
				shops[cur_shop].item_add_description(command[1].strip())
			elif (command[0].strip().lower() == "cost"):
				shops[cur_shop].item_add_cost(command[1].strip().lower())
			elif (command[0].strip().lower() == "buytype"):
				shops[cur_shop].item_add_buytype(command[1].strip().lower())
			elif (command[0].strip().lower() == "power"):
				shops[cur_shop].item_add_power(command[1].strip().lower())
			else:
				shops[cur_shop].item_add_act(shop_line)

		#ready another line
		shop_line = shop_file.readline()
