#inv.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

#This file controls the inventory screen.
from Tkinter import *
#needed for the buttons.
import ImageTk
import Image

import tkMessageBox
import g
import main
import action
import re
import item

#width/height of inv canvas, in tiles.
# (g.tilesize + the 3 pixel border)
inv_width = 4
inv_height = 7

#Currently selected item number
curr_item = 0


global active_button
active_button = 0

return_from_yesno = StringVar()

#these variables hold the name of the wielded equipment
weapon_name = StringVar()
armor_name = StringVar()
shield_name = StringVar()
helmet_name = StringVar()
gloves_name = StringVar()
boots_name = StringVar()

help_text = StringVar()

#currently selected button. 0=Drop, 1=Wear/Use, 2=Save, 3=Remove, 4=Leave
cur_button = 0


#distance from the left of the button canvas each button should be placed.
#Values are added in init_window. drop is not needed; always zero.
use_height = 0
remove_height = 0
save_height = 0
leave_height = 0


#called when "Save" is pressed
def inv_savegame():
	if action.has_dialog == 1: return 0
	g.savegame(g.name)
	main.print_message("** Game Saved **")
	help_text.set("Game Saved")

#called when "Leave" is pressed
def leave_inv():
	if action.has_dialog == 1: return 0
	try:
		window_inv.destroy()
	except TclError:
		pass

#puts a worn item into the inventory. Called from the remove button.
def rm_equip():
	if action.has_dialog == 1: return 0
	if (len(listbox_equip.curselection()) > 0):
		try: item_num = map(int, listbox_equip.curselection())
		except ValueError: pass
		if item.equip[item_num[0]] != -1:
			if -1 != item.take_inv_item(item.equip[item_num[0]]):
				main.print_message("You take off your " +
					item.item[item.equip[item_num[0]]].name)
				item.equip[item_num[0]] = -1
	refresh_inv()

#takes an item from the inventory, and wears it.
def wear_item():
	if action.has_dialog == 1: return 0

	try:
		item_value = item.inv[curr_item]
	except IndexError:
		return 0

	#put the equip slot into item_loc
	item_loc = item.item[item_value].type

	#if item is equipment
	if item_loc < 6:
		#trade the item and whatever's in the equip slot
		temp = item.equip[item_loc]
		item.equip[item_loc] = item_value
		item.drop_inv_item(curr_item)
		item.take_inv_item(temp)
		main.print_message("You equip yourself with your " +
			item.item[item.equip[item_loc]].name + ".")
		refresh_inv()

#drops an item from the inventory. Uses curr_item
def drop_item():
	if action.has_dialog == 1: return 0
	if curr_item >= len(item.inv) or item.inv[curr_item] == -1:
		return 0
	try: item_to_delete = item.find_inv_item(item.inv[curr_item])
	except IndexError: return 0

	#the inv[] location of the item is now in item_to_delete.
	#Ask if the player really wants to drop it.

	if inv_show_yesno("Drop your " +
			item.item[item.inv[item_to_delete]].name + "?"):
		main.print_message("You drop your " +
			item.item[item.inv[curr_item]].name)

		# add dropped item to map
		g.maps[g.zgrid].additem(item.item[item.inv[item_to_delete]].name,
			g.xgrid, g.ygrid)


		#remove the item from inventory
		item.drop_inv_item(curr_item)

	refresh_inv()

#Like show_yesno in main, but only expects one or two lines,
#and creates the canvas used.
def inv_show_yesno(line=""):
	action.has_dialog = 1
	global active_button
	active_button = 0
	global return_from_yesno
	return_from_yesno.set("0")

	canvas_width = no_button.width()*4/3+yes_button.width()*4/3
	canvas_height = yes_button.height()+50
	global canvas_inv2
	canvas_inv2 = Canvas(window_inv, width=canvas_width,
		height=canvas_height, highlightthickness=0)
	canvas_inv2.grid(column=1, row=2, columnspan=2, rowspan=7, sticky="S")

	#background
	canvas_inv2.create_rectangle(0, 0, canvas_width, canvas_height,
		fill="#5050ff", outline="Black", tags="background_box")
	#text
	canvas_inv2.create_text(3, 3, text=line, anchor="nw",
		width=canvas_width-6, tags="dialogtxt")
	#buttons
	canvas_inv2.create_image(canvas_width/2,
		canvas_height, image=no_button_sel, anchor="se", tags="no")
	canvas_inv2.create_image(canvas_width/2,
		canvas_height, image=yes_button, anchor="sw", tags="yes")
	#bindings
	main.window_main.bind("<Up>", change_yesno_sel)
	main.window_main.bind("<Right>", change_yesno_sel)
	main.window_main.bind("<Left>", change_yesno_sel)
	main.window_main.bind("<Down>", change_yesno_sel)
	main.window_main.bind("<Return>", activate_yesno)
	canvas_inv2.tag_bind("no", "<Enter>", change_yesno_to_no)
	canvas_inv2.tag_bind("yes", "<Enter>", change_yesno_to_yes)
	canvas_inv2.tag_bind("no", "<Button-1>", activate_yesno)
	canvas_inv2.tag_bind("yes", "<Button-1>", activate_yesno)

	#wait. Continue after activate_yesno() is run.
	window_inv.wait_variable(return_from_yesno)
	#cleanup
	try: canvas_inv2.destroy()
	except TclError: return 1

	bind_keys()

	action.has_dialog = 0
	return active_button

#when a yesno dialog box is active, switch to yes.
def change_yesno_to_yes(event=None):
	global active_button
	active_button = 1
	canvas_inv2.itemconfigure("no", image=no_button)
	canvas_inv2.itemconfigure("yes", image=yes_button_sel)

#when a yesno dialog box is active, switch to no.
def change_yesno_to_no(event=None):
	global active_button
	active_button = 0
	canvas_inv2.itemconfigure("no", image=no_button_sel)
	canvas_inv2.itemconfigure("yes", image=yes_button)

#when a yesno dialog box is active, switch the yes and no buttons.
def change_yesno_sel(event=None):
	if active_button == 0: change_yesno_to_yes()
	else: change_yesno_to_no()

#called on Return when the yesno dialog box is active.
def activate_yesno(event=None):
	global return_from_yesno
	return_from_yesno.set("1")


#called when "Use" is pressed
def use_item():
	if action.has_dialog == 1: return 0
	if curr_item >= len(item.inv) or item.inv[curr_item] == -1:
		return 0

	#put the item[] index of the item into item_value
	try: item_value = item.inv[curr_item]
	except IndexError: return 0

	#put the equip slot into item_loc
	item_loc = item.item[item_value].type
	#if equipment
	if item_loc < 6:
		wear_item()
		return

	main.print_message("You use your " + item.item[item_value].name)
	#if item is healing
	if item_loc == 11:
		#heal the player, delete the item
		g.hp=g.hp + item.item[item_value].quality
		item.drop_inv_item(curr_item)
		if g.hp >= g.maxhp: g.hp = g.maxhp

	refresh_inv()


#refresh buttons.
def refresh_buttons(event=0):
	no_item = 0  #set to one if no item is selected
	if action.has_dialog == 1: return 0
	canvas_buttons.delete(ALL)
	if curr_item >= len(item.inv) or item.inv[curr_item] == -1:
		no_item = 1
	if (cur_button == 0):
		canvas_buttons.create_image(0, 0, anchor=NW, image=drop_button_sel)
		if no_item == 1: help_text.set("")
		else: help_text.set("Drop your " + item.item[item.inv[curr_item]].name)
	else: canvas_buttons.create_image(0, 0, anchor=NW, image=drop_button)
	if (cur_button == 1):
		#switch between equip and use, based on the current item.
		try:
			item_value = item.inv[curr_item]
			item_loc = item.item[item_value].type
		except IndexError: item_loc = 50

		if (item_loc <= 6):
			canvas_buttons.create_image(use_height, 0, anchor=NW,
					image=equip_button_sel)
			if no_item == 1: help_text.set("")
			else: help_text.set("Equip your " + item.item[item.inv[curr_item]].name)
		else:
			canvas_buttons.create_image(use_height, 0, anchor=NW,
					image=use_button_sel)
			if no_item == 1: help_text.set("")
			else: help_text.set("Use your " + item.item[item.inv[curr_item]].name)
	else:
		try:
			item_value = item.inv[curr_item]
			item_loc = item.item[item_value].type
		except IndexError: item_loc = 50

		if (item_loc <= 6): canvas_buttons.create_image(use_height, 0,
					anchor=NW, image=equip_button)
		else: canvas_buttons.create_image(use_height, 0, anchor=NW,
					image=use_button)
	if (cur_button == 2):
		canvas_buttons.create_image(save_height, 0,
					anchor=NW, image=save_button_sel)
		help_text.set("Save game")
	else: canvas_buttons.create_image(save_height, 0, anchor=NW,
							image=save_button)
	if (cur_button == 3):
		canvas_buttons.create_image(remove_height, 0,
					anchor=NW, image=remove_button_sel)
		help_text.set("Remove equipment")
	else: canvas_buttons.create_image(remove_height, 0, anchor=NW,
							image=remove_button)
	if (cur_button == 4):
		canvas_buttons.create_image(leave_height, 0,
					anchor=NW, image=leave_button_sel)
		help_text.set("Leave inventory")
	else: canvas_buttons.create_image(leave_height, 0, anchor=NW,
							image=leave_button)

#refresh this screen. Call after moving around items.
def refresh_inv():
	if action.has_dialog == 1: return 0
	#place current position into item_num[0], for restoring position.
	canvas_inv.delete("item")
	invpos = 0
	#if the inv is selected, draw a selection box around the current item.
	if (curr_item != -1):
		canvas_inv.create_rectangle(
			(curr_item%inv_width)*g.tilesize + 2 * ((curr_item%inv_width)+1),
			(curr_item/inv_width)*g.tilesize + 2 * ((curr_item/inv_width)+1),
			((curr_item%inv_width)+1)*(g.tilesize + 2),
			((curr_item/inv_width)+1)*(g.tilesize + 2), fill="#A0A0ff", tags="item")

	#draw the item pictures.
	for i in range(len(item.inv)):
		if item.inv[i] != -1:
			canvas_inv.create_image((i%inv_width)*g.tilesize + 2 * ((i%inv_width)+1),
				(i/inv_width)*g.tilesize + 2 * ((i/inv_width)+1),
				image=g.tiles[item.item[item.inv[i]].picturename],
				anchor="nw", tags="item")
			invpos += 1

	try: equip_num = map(int, listbox_equip.curselection())
	except ValueError: pass

	#rebuild the equipment display
	listbox_equip.delete(0, END)
	temp = item.item[item.equip[0]].name
	if item.equip[0] == -1: temp = ""
	listbox_equip.insert(END, "Weapon: " + temp)

	temp = item.item[item.equip[1]].name
	if item.equip[1] == -1: temp = ""
	listbox_equip.insert(END, "Armor: " + temp)

	temp = item.item[item.equip[2]].name
	if item.equip[2] == -1: temp = ""
	listbox_equip.insert(END, "Shield: " + temp)

	temp = item.item[item.equip[3]].name
	if item.equip[3] == -1: temp = ""
	listbox_equip.insert(END, "Helmet: " + temp)

	temp = item.item[item.equip[4]].name
	if item.equip[4] == -1: temp = ""
	listbox_equip.insert(END, "Gloves: " + temp)

	temp = item.item[item.equip[5]].name
	if item.equip[5] == -1: temp = ""
	listbox_equip.insert(END, "Boots: " + temp)

	#restore the position.
	if (cur_button == 3): #equipment
		try:
			if (equip_num[0] < listbox_equip.size()):
				listbox_equip.selection_set(equip_num[0])
			else:
				if (listbox_equip.size() > 0):
					listbox_equip.selection_set(equip_num[0] - 1)
		except IndexError:
			listbox_equip.selection_set(0)
	main.recalc_stats()


#All keypresses in window_inv pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(key_name):
	if action.has_dialog == 1: return 0
	global cur_button
	global curr_item
	if (key_name == "esc"):
		leave_inv()
		return 0
	elif (key_name == "pgup"):
		if (cur_button == 0): #switch from drop to quit
			cur_button = 4
			curr_item = -1
		elif (cur_button == 1): #switch from use to drop
			cur_button = 0
		elif (cur_button == 2): #switch from save to use
			cur_button = 1
			curr_item = 3
		elif (cur_button == 3): #switch from remove to save
			cur_button = 2
			listbox_equip.select_clear(0, END)
		elif (cur_button == 4): #switch from quit to remove
			cur_button = 3
			if (len(listbox_equip.curselection()) == 0):
				listbox_equip.selection_set(0)
	elif (key_name == "pgdn"):
		if (cur_button == 0): #switch from drop to use
			cur_button = 1
		elif (cur_button == 1): #switch from use to save
			cur_button = 2
			curr_item = -1
		elif (cur_button == 2): #switch from save to remove
			cur_button = 3
			if (len(listbox_equip.curselection()) == 0):
				listbox_equip.selection_set(0)
		elif (cur_button == 3): #switch from remove to quit
			cur_button = 4
			listbox_equip.select_clear(0, END)
		elif (cur_button == 4): #switch from quit to drop
			cur_button = 0
			curr_item = 0
	elif (key_name == "right"):
		if (cur_button == 0): #move right, or switch from drop to use
			if (curr_item % inv_width == inv_width-1):  #if on right side
				cur_button = 1
			else: curr_item += 1
		elif (cur_button == 1): #move right, or switch from use to save
			if (curr_item % inv_width == inv_width-1):  #if on right side
				cur_button = 2
				curr_item = -1
			else: curr_item += 1
		elif (cur_button == 2): #switch from save to remove
			cur_button = 3
			if (len(listbox_equip.curselection()) == 0):
				listbox_equip.selection_set(0)
		elif (cur_button == 3): #switch from remove to quit
			cur_button = 4
			listbox_equip.select_clear(0, END)
		elif (cur_button == 4): #switch from quit to drop
			cur_button = 0
			curr_item = 0
	elif (key_name == "left"):
		if (cur_button == 0): #move left, or switch from drop to quit
			if (curr_item % inv_width == 0):  #if on left side
				cur_button = 4
				curr_item = -1
			else: curr_item -= 1
		elif (cur_button == 1): #move left, or switch from use to drop
			if (curr_item % inv_width == 0):  #if on left side
				cur_button = 0
			else: curr_item -= 1
		elif (cur_button == 2): #switch from save to use
			cur_button = 1
			curr_item = 3
		elif (cur_button == 3): #switch from remove to save
			cur_button = 2
			listbox_equip.select_clear(0, END)
		elif (cur_button == 4): #switch from quit to remove
			cur_button = 3
			if (len(listbox_equip.curselection()) == 0):
				listbox_equip.selection_set(0)
	elif (key_name == "up"):
		if (cur_button == 0 or cur_button == 1): #if in inv
			curr_item = curr_item - inv_width
			if curr_item < 0:
				curr_item += inv_width * inv_height
		if (cur_button == 3): #if in equip
			try:
				try: item_num = map(int, listbox_equip.curselection())
				except ValueError: pass
				if (item_num[0] != 0):
					listbox_equip.select_clear(0, END)
					listbox_equip.selection_set(item_num[0] - 1)
				else:
					listbox_equip.select_clear(0, END)
					listbox_equip.selection_set(END)
			except IndexError: pass
	elif (key_name == "down"):
		if (cur_button == 0 or cur_button == 1): #if in inv
			curr_item = curr_item + inv_width
			if curr_item >= inv_width * inv_height:
				curr_item -= inv_width * inv_height
		if (cur_button == 3): #if in equip
			try: item_num = map(int, listbox_equip.curselection())
			except ValueError: pass
			try:
				if (item_num[0] != listbox_equip.size() - 1):
					listbox_equip.select_clear(0, END)
					listbox_equip.selection_set(item_num[0] + 1)
				else:
					listbox_equip.select_clear(0, END)
					listbox_equip.selection_set(0)
			except IndexError: pass
	elif (key_name == "return"):
		if (cur_button == 0): drop_item()
		elif (cur_button == 1):
			use_item()
		elif (cur_button == 2):
			inv_savegame()
			return 0
		elif (cur_button == 3): rm_equip()
		elif (cur_button == 4):
			leave_inv()
			return 0
	refresh_buttons()
	refresh_inv()

def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")
def key_handler_pgup(event=0): key_handler("pgup")
def key_handler_pgdn(event=0): key_handler("pgdn")

def mouse_handler_click(event=0):
	if action.has_dialog == 1: return 0
	key_handler("return")

#Used in mouse_sel_inv. Takes x y coordinates, and returns
#the selected box, or -1 for none.
def which_box(x, y):
	if x < 3: return -1
	tempx = x - 3
	likelyx = tempx / (g.tilesize + 2)
	tempx = tempx - (likelyx * (g.tilesize + 2))
	if tempx >= g.tilesize - 1: return -1

	if y < 3: return -1
	tempy = y - 3
	likelyy = tempy / (g.tilesize + 2)
	tempy = tempy - (likelyy * (g.tilesize + 2))
	if tempy >= g.tilesize - 1: return -1

	return likelyy * inv_width + likelyx

#called when the user releases the mouse in the inv canvas.
def mouse_sel_inv(event=0):
	#decide if the mouse is within one of the boxes.
	global curr_item
	#global curr_focus
	temp_num =  which_box(event.x, event.y)
	if temp_num == -1: return
	curr_item = temp_num
	#curr_focus = 0
	refresh_inv()
	#show_details()

def mouse_handler_move(event=0):
	if action.has_dialog == 1: return 0
	global cur_button
	if (event.x < use_height):
		cur_button = 0
		listbox_equip.select_clear(0, END)
	elif (event.x < save_height):
		cur_button = 1
		listbox_equip.select_clear(0, END)
	elif (event.x < remove_height): cur_button = 2
	elif (event.x < leave_height):
		cur_button = 3
		if (len(listbox_equip.curselection()) == 0):
			listbox_equip.selection_set(0)
	else: cur_button = 4
	refresh_buttons()

def init_window_inv():
	#create the window
	global window_inv
	global bgcolour
	bgcolour = "lightgrey"
	window_inv = Frame(main.top, bd=2, relief=SUNKEN, bg=bgcolour)
	window_inv.grid(row=1, column=5, columnspan=13, rowspan=13, sticky=E)
	global curr_item
	curr_item = 0

	#Inventory canvas
	temp_canvas_width=(g.tilesize*inv_width)+ ((inv_width+1)*2) + 1
	temp_canvas_height=(g.tilesize*inv_height)+ ((inv_height+1)*2) + 1
	global canvas_inv
	canvas_inv = Canvas(window_inv, width=temp_canvas_width,
		height=temp_canvas_height, highlightthickness=0, bg="#202090")
	canvas_inv.grid(column=1, row=2, rowspan=10)
	#outside border
	canvas_inv.create_rectangle(0,0, temp_canvas_width-1, temp_canvas_height-1)
	#per-item borders
	for y in range(inv_height):
		for x in range(inv_width):
			canvas_inv.create_rectangle(x*g.tilesize + 2 * (x+1),
										y*g.tilesize + 2 * (y+1),
										(x+1)*(g.tilesize + 2),
										(y+1)*(g.tilesize + 2), fill="#5050ff")

	global listbox_equip
	listbox_equip = Listbox(window_inv, height=10, takefocus=0, bg=bgcolour)
	listbox_equip.grid(row=2, column=2, rowspan=10, sticky=N+W+E)


	#Button pictures, both selected and normal.
	global drop_button; global drop_button_sel
	global wear_button; global wear_button_sel
	global use_button; global use_button_sel
	global equip_button; global equip_button_sel
	global save_button; global save_button_sel
	global remove_button; global remove_button_sel
	global leave_button; global leave_button_sel
	global yes_button; global yes_button_sel
	global no_button; global no_button_sel

	drop_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/drop.png")
	wear_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/equip.png")
	use_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/use.png")
	equip_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/equip.png")
	save_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/save.png")
	remove_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/remove.png")
	leave_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/leave.png")
	yes_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/yes.png")
	no_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/no.png")

	drop_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/drop_sel.png")
	wear_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/equip_sel.png")
	use_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/use_sel.png")
	equip_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/equip_sel.png")
	save_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/save_sel.png")
	remove_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/remove_sel.png")
	leave_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/leave_sel.png")
	yes_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/yes_sel.png")
	no_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/no_sel.png")

	#location of the various buttons.
	global use_height; use_height = drop_button.width()
	global save_height; save_height = use_height + use_button.width()
	global remove_height; remove_height = save_height + save_button.width()
	global leave_height; leave_height = remove_height + remove_button.width()

	#Button canvas.
	global canvas_buttons
	canvas_buttons = Canvas(window_inv, height=leave_button_sel.height(),
		width=leave_height+leave_button.width(), bg=bgcolour)
	canvas_buttons.grid(column=1, row=13, columnspan=2)


	#bindings
	bind_keys()

	label_help = Label(window_inv, bg=bgcolour,
		textvariable=help_text).grid(row=1, column=1, columnspan=2)

	refresh_inv()
	refresh_buttons()

	window_inv.master.wait_window(window_inv)


#bind the keys. Called upon window creation and return from a yes/no box
def bind_keys():
	canvas_inv.bind("<ButtonRelease-1>",  mouse_sel_inv)
	main.window_main.bind("<Escape>", key_handler_esc)
	main.window_main.bind("<Return>", key_handler_return)
	main.window_main.bind("<Up>", key_handler_up)
	main.window_main.bind("<Down>", key_handler_down)
	main.window_main.bind("<Left>", key_handler_left)
	main.window_main.bind("<Right>", key_handler_right)
	main.window_main.bind("<Prior>", key_handler_pgup)
	main.window_main.bind("<Next>", key_handler_pgdn)
	canvas_buttons.bind("<ButtonRelease-1>", mouse_handler_click)
	canvas_buttons.bind("<Motion>", mouse_handler_move)
