#g.py
#Copyright (C) 2005 Free Software Foundation
#see GPL.txt for license.

#This file contains everything that needs to be accessed by most or all files.


#Dragon Hunt 3.40. Released under the GPL. Copyright 2005
#(Note to self: when changing version, change variables.txt, README.txt,
# and setup.py.)

from Tkinter import *
import ImageTk
#needed for die_roll
from random import random
#needed for save/load game
import pickle
from os import path, mkdir, remove, walk

#needed for scripting
from scripting import *
import monster
import item
import main
import action

#This will be displayed on the Title screen and Main screen.
game_name = ""

#general character stats
name = ""
hp = 0
ep = 0
maxhp = 0
maxep = 0
attack = 0
defense = 0
gold = 0
exp = 0
level = 0
skillpoints = 1

#stores attack/defense/hp/ep, adjusted by equipment.
#kept correct by main.refreshmap(). Use these for calculations.
adj_attack = 0
adj_defense = 0
adj_maxhp = 0
adj_maxep = 0

#fill colour
fill_colour = "#b9e5ad"
fill_sel_colour = "#7aa96e"
outline_colour = "#70a662"
#fill_colour = "#5050ff"
#fill_sel_colour = "#A0A0ff"
#outline_colour = "#202090"

#default tile width. Set in variables.txt, or default to 32.
tilesize = 32

#location on map: x, y, z coordinate. Map names are given a zgrid on loading.
xgrid = 0
ygrid = 0
zgrid = 1

#controls timed effects such as healing. Loops around every 30 turns (0-29);
#controls perturn.txt.
timestep = 0

#dictionary of script variables.
var_list = {}

#current monster hp. Used to allow activation
#of bombs from inv. UNUSED
cur_mon_hp = 0

#Name of current hero picture.
cur_hero = "people/hero_w.png"

#Current window in use (main, battle, inventory)
cur_window = "main"

#Should the player be allowed to move? Used with the move scripting command,
#to prevent moving again after moving.
allow_move = 1

#width of the hp/ep bars
hpbar_width = 0

#current module directory
mod_directory = ""

#per turn scripting, for hp recovery and the like.
per_turn_script = []

#Has tk been inited yet? Used between rpg.py and new_game.py to decide where
#to init tk.
init_tk_already = 0

#Default key bindings for the game.
binding_up="<Up>"
binding_down="<Down>"
binding_left="<Left>"
binding_right="<Right>"
binding_action="<Return>"
binding_cancel="<Escape>"
binding_attack="a"
binding_save="s"
binding_quit="q"
binding_inv="i"
binding_inv_right="<Next>"
binding_inv_left="<Prior>"

#save the game in saves/input.
#uses pickle, first line is a version number.
def savegame(save_file):
	#If there is no save directory, make one.
	if path.isdir(g.mod_directory + "/saves") == 0:
		if path.exists(g.mod_directory + "/saves") == 1:
			remove(g.mod_directory + "/saves")
		mkdir(g.mod_directory + "/saves")
	save_loc = g.mod_directory + "/saves/" + save_file
	savefile=open(save_loc, 'w')
	#savefile version; update whenever the data saved changes.
	pickle.dump("dh3.3", savefile)
	pickle.dump(name, savefile)
	pickle.dump(hp, savefile)
	pickle.dump(ep, savefile)
	pickle.dump(maxhp, savefile)
	pickle.dump(maxep, savefile)
	pickle.dump(attack, savefile)
	pickle.dump(defense, savefile)
	pickle.dump(gold, savefile)
	pickle.dump(exp, savefile)
	pickle.dump(level, savefile)
	pickle.dump(skillpoints, savefile)

	#equipment is stored by name to increase savefile compatability.
	pickle.dump(len(item.equip), savefile)
	for i in range(len(item.equip)):
		if item.equip[i] != -1:
			pickle.dump(item.item[item.equip[i]].name, savefile)
		else: pickle.dump("Ignore", savefile)
	pickle.dump(len(item.inv), savefile)
	for i in range(len(item.inv)):
		if item.inv[i] != -1:
			pickle.dump(item.item[item.inv[i]].name, savefile)
		else: pickle.dump("Ignore", savefile)
	pickle.dump(xgrid, savefile)
	pickle.dump(ygrid, savefile)
	pickle.dump(zgrid, savefile)
	#skills are stored by name as well.
	num = 0
	for i in range(len(skill)):
		if skill[i][5] == 1:
			num += 1
	pickle.dump(num, savefile)
	for i in range(len(skill)):
		if skill[i][5] == 1:
			pickle.dump(skill[i][0], savefile)

	pickle.dump(item.dropped_items, savefile)
	pickle.dump(timestep, savefile)
	pickle.dump(var_list, savefile)
	savefile.close()

def loadgame(save_file):
	save_loc = g.mod_directory + "/saves/" + save_file
	savefile=open(save_loc, 'r')
	version = pickle.load(savefile)
	if version != "dh3.3":
		return loadgame_31(save_file)
	global name;		name = pickle.load(savefile)
	global hp;			hp = pickle.load(savefile)
	global ep;			ep = pickle.load(savefile)
	global maxhp;		maxhp = pickle.load(savefile)
	global maxep;		maxep = pickle.load(savefile)
	global attack;		attack = pickle.load(savefile)
	global defense;		defense = pickle.load(savefile)
	global gold;		gold = pickle.load(savefile)
	global exp;			exp = pickle.load(savefile)
	global level;		level = pickle.load(savefile)
	global skillpoints;	skillpoints = pickle.load(savefile)

	#equipment is stored by name to increase savefile compatability.
	global equip;		equip_len = pickle.load(savefile)
	for i in range(equip_len):
		item.equip[i] = item.finditem(pickle.load(savefile))
		if item.item[item.equip[i]].name == "Ignore":
			item.equip[i] = -1
	global inv;			inv_len = pickle.load(savefile)
	for i in range(inv_len):
		item.inv[i] = item.finditem(pickle.load(savefile))
		if item.item[item.inv[i]].name == "Ignore":
			item.inv[i] = -1
	global xgrid;		xgrid = pickle.load(savefile)
	global ygrid;		ygrid = pickle.load(savefile)
	global zgrid;		zgrid = pickle.load(savefile)
	global skill;		skill_len = pickle.load(savefile)
	for i in range(skill_len):
		skill[findskill(pickle.load(savefile))][5] = 1
	item.dropped_items = pickle.load(savefile)
	global timestep;	timestep = pickle.load(savefile)
	global var_list;	var_list = pickle.load(savefile)
	savefile.close()

def loadgame_31(save_file):
	save_loc = g.mod_directory + "/saves/" + save_file
	savefile=open(save_loc, 'r')
	version = pickle.load(savefile)
	if version != "dh3.2":
		print "old savefile version"
		return -1
	global name;		name = pickle.load(savefile)
	global hp;			hp = pickle.load(savefile)
	global ep;			ep = pickle.load(savefile)
	global maxhp;		maxhp = pickle.load(savefile)
	global maxep;		maxep = pickle.load(savefile)
	global attack;		attack = pickle.load(savefile)
	global defense;		defense = pickle.load(savefile)
	global gold;		gold = pickle.load(savefile)
	global exp;			exp = pickle.load(savefile)
	global level;		level = pickle.load(savefile)
	global skillpoints;	skillpoints = pickle.load(savefile)

	#equipment is stored by name to increase savefile compatability.
	global equip;		equip_len = pickle.load(savefile)
	for i in range(equip_len):
		item.equip[i] = item.finditem(pickle.load(savefile))
		if item.item[item.equip[i]].name == "Ignore":
			item.equip[i] = -1
	global inv;			inv_len = pickle.load(savefile)
	for i in range(inv_len):
		item.inv[i] = item.finditem(pickle.load(savefile))
		if item.item[item.inv[i]].name == "Ignore":
			item.inv[i] = -1
	global xgrid;		xgrid = pickle.load(savefile)
	global ygrid;		ygrid = pickle.load(savefile)
	global zgrid;		zgrid = pickle.load(savefile)
	global skill;		skill_len = pickle.load(savefile)
	for i in range(skill_len):
		skill[findskill(pickle.load(savefile))][5] = 1
	global timestep;	timestep = pickle.load(savefile)
	global cur_mon_hp;	cur_mon_hp = pickle.load(savefile)
	savefile.close()

#this calls scripting.py to read the datafiles.
def init_data():
	read_settings()
	read_maps()
	read_scripts()
	item.read_items()
	monster.read_monster()
	global game_name
	game_name = read_game_name()
	read_variables()
	read_shops()
	read_perturn()

#Get the name of the module from the variables.txt file. Note that this
#does not set the game name, only returns it. This lets it be used in rpg.py
def read_game_name():
	file = open(mod_directory + "/data/variables.txt", 'r')
	line = file.readline()
	while (line != ''):
		line = line.strip()
		if (line[:1] == "#" or line[:1] == ""):
			line = file.readline()
			continue
		if (line.split("=", 1)[0].strip() == "game_name"):
			return line.split("=", 1)[1].strip()
		line = file.readline()

#What dice to roll when starting a new game. 2d array.
new_game_dice = []


#get the key bindings from settings.txt
def read_settings():
	global binding_up
	global binding_down
	global binding_left
	global binding_right
	global binding_action
	global binding_cancel
	global binding_attack
	global binding_save
	global binding_quit
	global binding_inv
	global binding_inv_right
	global binding_inv_left

	#try to open settings.txt. If it doesn't exist,
	# just use the default settings.
	try: file = open("../settings.txt", 'r')
	except IOError: return 0
	line = file.readline()
	while (line != ''):
		line = line.strip()
		if (line[:1] == "#" or line[:1] == ""):
			line = file.readline()
			continue
		if (line.split("=", 1)[0].strip() == "up"):
			binding_up = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "down"):
			binding_down = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "left"):
			binding_left = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "right"):
			binding_right = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "action"):
			binding_action = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "cancel"):
			binding_cancel = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "attack"):
			binding_attack = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "save"):
			binding_save = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "quit"):
			binding_quit = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "inv"):
			binding_inv = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "inv_right"):
			binding_inv_right = line.split("=", 1)[1].strip()
		if (line.split("=", 1)[0].strip() == "inv_left"):
			binding_inv_left = line.split("=", 1)[1].strip()
		line = file.readline()


def read_variables():
	for i in range(5):
		new_game_dice.append([])
	file = open(mod_directory + "/data/variables.txt", 'r')
	line = file.readline()
	while (line != ''):
		line = line.strip()
		if (line[:1] == "#" or line[:1] == ""):
			line = file.readline()
			continue
		if (line.split("=", 1)[0].strip() == "hp"):
			read_dice(0, line.split("=", 1)[1].strip())
		elif (line.split("=", 1)[0].strip() == "ep"):
			read_dice(1, line.split("=", 1)[1].strip())
		elif (line.split("=", 1)[0].strip() == "attack"):
			read_dice(2, line.split("=", 1)[1].strip())
		elif (line.split("=", 1)[0].strip() == "defense"):
			read_dice(3, line.split("=", 1)[1].strip())
		elif (line.split("=", 1)[0].strip() == "gold"):
			read_dice(4, line.split("=", 1)[1].strip())
		elif (line.split("=", 1)[0].strip() == "tilesize"):
			global tilesize
			tilesize = int(line.split("=", 1)[1].strip())
		line = file.readline()

#given a dice set and string of the form 2d4+5, place in new_game_dice
def read_dice(variable, dice_string):
	first = dice_string.split("d", 1)[0].strip()
	temp = dice_string.split("d", 1)[1].strip()
	if temp.find("+") == -1:
		second = temp.strip()
		third = "0"
	else:
		second = temp.split("+", 1)[0].strip()
		third = temp.split("+", 1)[1].strip()
	new_game_dice[variable].append(int(first))
	new_game_dice[variable].append(int(second))
	new_game_dice[variable].append(int(third))

#reads the file data/perturn.txt. Expects mod_directory to be set.
def read_perturn():
	cur_turns = []
	temp_cur_turns = []
	global per_turn_script
	for i in range(30):
		per_turn_script.append([])
	file = open(mod_directory + "/data/perturn.txt", 'r')
	line = file.readline()
	while (line != ''):
		line = line.strip()
		if (line[:1] == "#" or line[:1] == ""):
			line = file.readline()
			continue
		#allow the \ line-continuation character.
		while line[-1:] == "\\":  #really a single backslash, BTW.
			line = line[:-1] + file.readline()[:-1]

		line = line.strip()
		if line[:1] == ":": #start defining more tiles.
			cur_turns = []
			temp_cur_turns = line[1:].split(",")
			for turn in temp_cur_turns:
				if turn.strip().isdigit():
					cur_turns.append(int(turn.strip()))

		#give scripting to the current tiles
		else:
			for turn_num in cur_turns:
				per_turn_script[turn_num].append(line)
		#ready another line
		line = file.readline()
	file.close()



#skills array. Each skill is a separate line in the array. Each line goes:
#name, effect, level, price, description, acquired
#effect is an integer that tells battle.py which case in a select to pick.
#level is the skillpoints required to get the skill,
#as well as the ep needed to use.
#acquired tells if the skill has already been learned by the player.
skill = []

#Add a skill to the skill[] array
def addskill(name, effect, level, price, description):
	skill.append([])
	i = len(skill)
	skill[i-1].append(name)
	skill[i-1].append(effect)
	skill[i-1].append(level)
	skill[i-1].append(price)
	skill[i-1].append(description)
	skill[i-1].append(0)


#takes a skill name, and returns its location in the
#skill[] array, with -1 == nonexisting.
def findskill(name):
	for i in range(len(skill)):
		if name.lower() == skill[i][0].lower():
			return i
	return -1

#gives the player a skill; takes the location in skill[] as input
def add_skill(skill_loc):
	if (skill[skill_loc][5] == 1):
		return 0
	else:
		skill[skill_loc][5] = 1
		return 1

#add skills. I really should change these to scripts sometime.
addskill("Rage",       0, 1, 10,
	"Gives you increased damage for the rest of a battle")
addskill("Sneak Away", 1, 1, 10,
	"Attempts to leave a battle.")
addskill("Dismember",  3, 2, 20,
	"Your next attack will do maximum damage, and ignore armor")
addskill("Frenzy",  2, 2, 30,
	"Your next attack will try to hit more than once")

#Gives the player the specified amount of experience; also handles level gains.
def add_exp(input_exp):
	global exp
	global level
	exp = int(exp) + int(input_exp)
	#Has the player gained a level?
	if int(exp) >= int(10*(level + 1)*(level + 1)):
		level=level+1
		main.print_message("You gain a level.")
		for i in levelup_act:
			action.activate_line(xgrid, ygrid, zgrid, i)



#Rolls dice in the form 2d6, where 2 is the number of dice, and 6 the number of
#sides on each die. modify is the bonus given to each die. Use die_roll(2, 6)

#Modify is the bonus given to each die. Use die_roll(2, 6) + 4 for bonuses on
#the entire roll, die_roll(2, 6, 1) for bonuses on each roll. Default = 0
def die_roll(dice, sides, modfy = 0):
	if sides < 1:
		sides = 1
	if dice < 1:
		dice = 1

	sum = 0
	for x in range(dice):
		die = int(((random() * sides) + 1 + modfy))
		sum = sum + die

	return sum


#Returns the symbol of the given tile. X and Y are absolute coords.
def checklocation(x, y):

	#Assume that all off-map areas are rock.
	if x < 0 or y < 0:
		return 'a'
	try:
		#this will fail when looking too far right or down
		return maps[zgrid].field[y][x].name
	except IndexError:
		#off the map, so rock.
		return 'a'

#like checklocation, but just returns 0 (rock) or 1 (grass)
def iswalkable(x, y):

	#Assume that all off-map areas are rock.
	if x < 0 or y < 0:
		return 0
	try:
		#this will fail when looking too far right or down
		if maps[zgrid].field[y][x].walk == 0:
			return 0
	except IndexError:
		return 0
	#By this point, it is known to be walkable.
	return 1

#takes the name of a map, and returns its zgrid.
def mapname2zgrid(name):
	for i in range(len(maps)):
		if maps[i].name == name:
			return i
	else:
		print "file " + name + " not found"
		return -1

tiles = {}

#this loads the various tiles.
def load_tiles():
	global tiles
	tiles = {"blank" : ImageTk.PhotoImage("RGB", (32, 32))}

	for root, dirs, files in walk(g.mod_directory + "/images/tiles/"):
		(head, tail) = path.split(root)
		if (tail != "CVS"):
			for tilename in files:
				#if image is in a sub-dir:
				if (root != g.mod_directory + "/images/tiles/"):
					i = len(g.mod_directory + "/images/tiles/")
					tiles[root[i:] + "/" + tilename] = \
						ImageTk.PhotoImage(file=root + "/" + tilename)
				else: #if image is in root dir
					tiles[tilename] = \
						ImageTk.PhotoImage(file=root + "/" + tilename)


backgrounds = {}

#This loads the battle backgrounds.
def load_backgrounds():
	global backgrounds
	backgrounds = {"blank" : ImageTk.PhotoImage("RGB", (200, 200))}

	for root, dirs, files in walk(g.mod_directory + "/images/backgrounds/"):
		(head, tail) = path.split(root)
		if (tail != "CVS"):
			for tilename in files:
				#if image is in a sub-dir:
				if (root != g.mod_directory + "/images/backgrounds/"):
					i = len(g.mod_directory + "/images/backgrounds/")
					backgrounds[root[i:] + "/" + tilename] = \
						ImageTk.PhotoImage(file=root + "/" + tilename)
				else: #if image is in root dir
					backgrounds[tilename] = \
						ImageTk.PhotoImage(file=root + "/" + tilename)
