#monster.py
#Copyright (C) 2005 Free Software Foundation
#see GPL.txt for license.

#This file contains everything about the monsters.

from random import random
from os import listdir

import g

class monster_group_class:
	def __init__(self, name):
		self.name = str(name)
		self.monster_list = []

class monster_class:
	def __init__(self, name, hp, attack, defense, exp, gold, descript):
		self.name = str(name)
		self.hp = int(hp)
		self.maxhp = int(hp)
		self.attack = int(attack)
		self.defense = int(defense)
		self.exp = int(exp)
		self.gold = int(gold)
		self.description = str(descript)
		#An array of lines, describing the scripting run when the monster dies.
		#If given, this replaces the exp/gold giving code.
		self.on_death = []
	def reset(self):  #resets the monster for a battle
		self.hp = self.maxhp

global monsters
monsters = []

global monster_groups
monster_groups = []

#Given the name of a monster, return the index in the monsters[] array.
def monster_name_to_index(name):
	for i in range(len(monsters)):
		if name.lower() == monsters[i].name.lower():
			return i
	print "monster " + mon_name + " not found in monsters directory."
	return -1


#find an appropriate monster group for the given (zgrid) dungeon level.
#-1 is returned if no monsters are available for this level;
#otherwise, the position in monster_groups[] is returned.
def find_level_monster(level):
	#Pick a random entry in the monster table of the map.
	if len(g.maps[level].monster) == 0: return -1
	mon_name = g.maps[level].monster[
		int(random() * len(g.maps[level].monster))]
	#Take the monster name, and find the monsters[] index.
	for i in range(len(monster_groups)):
		if mon_name.lower() == monster_groups[i].name.lower():
			return i
	print "monster " + mon_name + " not found in monsters directory."
	return -1

#read monsters directory, and place in monsters[]. This is called on startup.
def read_monster():
	#put the names of the available monsters in array_monsters.
	array_monsters = listdir(g.mod_directory + "/data/monsters")

	#remove all .* files.
	i = 0
	while i < len(array_monsters):
		extension_start = len(array_monsters[i]) - 4
		if(extension_start <= 0):
			array_monsters.pop(i)
		else:
			if array_monsters[i][:1] == ".":
				array_monsters.pop(i)
			elif array_monsters[i][extension_start:extension_start+4] != ".txt":
				array_monsters.pop(i)
			else:
				i += 1

	#go through all monsters, adding them to our knowledge.
	for monster_filename in array_monsters:
		addmonster(monster_filename)


	#Now read and interpret monsters.txt for grouping information.
	global monster_groups
	monster_groups = []
	cur_group = -1
	monster_loc = g.mod_directory + "/data/monsters.txt"
	monster_file = open(monster_loc, 'r')
	#go through all lines of the file
	monster_line = monster_file.readline()
	while monster_line != '':
		#strip out spaces/tabs
		monster_line = monster_line.strip()
		#ignore blank lines and comments
		if monster_line[:1] == "#" or monster_line[:1] == "":
			monster_line = monster_file.readline()
			continue
		#allow \ line-continuation
		while monster_line[-1:] == "\\": #really a single backslash, BTW.
				monster_line = monster_line[:-1] + monster_file.readline()[:-1]
		if monster_line[:1] == ":":
			monster_groups.append(monster_group_class(monster_line[1:]))
			cur_group += 1
		else:
			monster_groups[cur_group].monster_list.append(monster_line)
		#ready another line
		monster_line = monster_file.readline()

	monster_file.close()


#given a filename, (relative to g.mod_directory + "/data/monsters")
#open and interpret the monster.
def addmonster(filename):
	global monsters

	temp_name = ""
	temp_hp = 0
	temp_attack = 0
	temp_defense = 0
	temp_exp = 0
	temp_gold = 0
	temp_description = ""
	temp_on_death = []

	curr_mode = 0  #are we reading in a script (1) or variables (0)?

	monster_loc = g.mod_directory + "/data/monsters/" + filename
	monster_file = open(monster_loc, 'r')
	#go through all lines of the file
	monster_line = monster_file.readline()
	while monster_line != '':
		#strip out spaces/tabs
		monster_line = monster_line.strip()
		#ignore blank lines and comments
		if monster_line[:1] == "#" or monster_line[:1] == "":
			monster_line = monster_file.readline()
			continue
		#allow \ line-continuation
		while monster_line[-1:] == "\\": #really a single backslash, BTW.
				monster_line = monster_line[:-1] + monster_file.readline()[:-1]

		if curr_mode == 1:
			temp_on_death.append(monster_line)
			monster_line = monster_file.readline()
			continue

		monster_command = monster_line.split("=", 2)[0]
		monster_command = monster_command.strip()
		if (monster_command.lower() == "name"):
			temp_name = monster_line.split("=", 1)[1]
		elif (monster_command.lower() == "hp"):
			temp_hp = monster_line.split("=", 1)[1]
		elif (monster_command.lower() == "attack"):
			temp_attack = monster_line.split("=", 1)[1]
		elif (monster_command.lower() == "defense"):
			temp_defense = monster_line.split("=", 1)[1]
		elif (monster_command.lower() == "exp"):
			temp_exp = monster_line.split("=", 1)[1]
		elif (monster_command.lower() == "gold"):
			temp_gold = monster_line.split("=", 1)[1]
		elif (monster_command.lower() == "description"):
			temp_description = monster_line.split("=", 1)[1]
		elif (monster_command.lower() == ":on_death"):
			curr_mode = 1
		else:
			print "bad line of " + monster_line + " found in " + filename
		#ready another line
		monster_line = monster_file.readline()

	monster_file.close()

	#actually add the monster
	monsters.append(monster_class(temp_name, temp_hp, temp_attack,
		temp_defense, temp_exp, temp_gold, temp_description))

	for line in temp_on_death:
		monsters[len(monsters)-1].on_death.append(line)

