#loadgame.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file controls the load game screen. The actual load/save game
#functions are in g.loadgame/savegame

from Tkinter import *
import ImageTk
import g
from os import listdir, path, mkdir, remove

#was a game loaded? Used to determine whether to use newgame script.
did_load = 0
global cur_button
cur_button = 0

help_text = StringVar()

#called when "Load" is pressed
def load_selected():
	if (listbox_saves.size() == 0): return
	#find the name of the save to load
	try: item_num = map(int, listbox_saves.curselection())
	except ValueError: pass
	save_title = listbox_saves.get(item_num[0])
	g.loadgame(save_title)
	global did_load
	did_load = 1
	window_loadgame.destroy()


#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(switch):
	if (switch == "esc"): cancel_load()
	elif (switch == "left" or switch == "right"):
		global cur_button
		if cur_button == 0: cur_button = 1
		else: cur_button = 0
		refresh_buttons()
	elif (switch == "up"):
		if (listbox_saves.size() == 0): return
		try: item_num = map(int, listbox_saves.curselection())
		except ValueError: pass
		if (item_num[0] != 0):
			listbox_saves.select_clear(0, END)
			listbox_saves.selection_set(item_num[0] - 1)
		else:
			listbox_saves.select_clear(0, END)
			listbox_saves.selection_set(END)
	elif (switch == "down"):
		if (listbox_saves.size() == 0): return
		try: item_num = map(int, listbox_saves.curselection())
		except ValueError: pass
		if (item_num[0] != listbox_saves.size() - 1):
			listbox_saves.select_clear(0, END)
			listbox_saves.selection_set(item_num[0] + 1)
		else:
			listbox_saves.select_clear(0, END)
			listbox_saves.selection_set(0)
	elif (switch == "return"):
		if cur_button == 0: load_selected()
		else: cancel_load()


#called when "Cancel" is pressed
def cancel_load():
	global did_load
	did_load = 0
	window_loadgame.destroy()

def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")

def mouse_handler_move(event=0):
	global cur_button
	if (event.x < g.buttons["load_scr.png"].width()): cur_button = 0
	else: cur_button = 1
	refresh_buttons()

def refresh_buttons():
	canvas_buttons.delete(ALL)
	if (cur_button == 0):
		canvas_buttons.create_image(0, 0, anchor=NW,
			image=g.buttons["load_scr_sel.png"], tags="load")
		help_text.set("Load the game")
		canvas_buttons.create_image(g.buttons["load_scr.png"].width(), 0, anchor=NW,
			image=g.buttons["leave.png"], tags="leave")
	else:
		canvas_buttons.create_image(0, 0, anchor=NW,
			image=g.buttons["load_scr.png"], tags="load")
		canvas_buttons.create_image(g.buttons["load_scr.png"].width(), 0, anchor=NW,
			image=g.buttons["leave_sel.png"], tags="leave")
		help_text.set("Back to main menu")

def init_window_loadgame():
	#create the window
	global window_loadgame
	window_loadgame = Toplevel()
	window_loadgame.wm_geometry("+%d+%d" % (10, 10))
	window_loadgame.focus()
	window_loadgame.resizable(0, 0)
	window_loadgame.maxsize(10000, 10000)
	window_loadgame.title("Load Game")

	global did_load
	did_load = 0

	#add the saves listbox
	global listbox_saves
	listbox_saves = Listbox(window_loadgame, height=10)
	listbox_saves.grid(row=1, column=4, columnspan=2, rowspan=10, sticky=EW)
	global scroll_saves
	scroll_saves = Scrollbar(window_loadgame, command=listbox_saves.yview)
	scroll_saves.grid(row=1, column=5, rowspan=10, sticky="NSE")
	listbox_saves.config(yscrollcommand=scroll_saves.set)

	global label_help
	label_help = Label(window_loadgame, textvariable=help_text)
	label_help.grid(row=0, column=4, columnspan=2, sticky=EW)

	#add the canvas
	global canvas_buttons
	canvas_buttons = Canvas(window_loadgame, width=g.buttons["load_scr.png"].width() +
		g.buttons["leave.png"].width(), height=g.buttons["leave.png"].height(),
		highlightthickness=0)
	canvas_buttons.grid(column=4, row=12, columnspan=3, sticky=N+W)

	#add the buttons
#	button_load = Button(window_loadgame, text="Load",
#		command=load_selected).grid(row=12, column=4)
#	button_cancel = Button(window_loadgame, text="Cancel",
#		command=cancel_load).grid(row=12, column=5)

	#If there is no save directory, make one.
	if path.isdir(g.mod_directory + "/saves") == 0:
		if path.exists(g.mod_directory + "/saves") == 1:
			remove(g.mod_directory + "/saves")
		mkdir(g.mod_directory + "/saves")
	#show the files contained in the saves directory.
	array_save = listdir(g.mod_directory + "/saves")
	for i in array_save:
		if i[:1] != ".":
			listbox_saves.insert(END, i)

	listbox_saves.select_set(0)

	canvas_buttons.bind("<ButtonRelease-1>", key_handler_return)
	canvas_buttons.bind("<Motion>", mouse_handler_move)

	window_loadgame.bind("<Escape>", key_handler_esc)
	window_loadgame.bind("<Left>", key_handler_left)
	window_loadgame.bind("<Right>", key_handler_right)
	window_loadgame.bind("<Up>", key_handler_up)
	window_loadgame.bind("<Down>", key_handler_down)
	window_loadgame.bind("<Return>", key_handler_return)
	listbox_saves.bind("<Double-Button-1>", key_handler_return)
	refresh_buttons()

	window_loadgame.master.wait_window(window_loadgame)
	return did_load
