#file: player.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file controls the player info

import g

#player definition.
class player_class:
	def __init__(self):
		self.name = ""
		self.hp = 0
		self.ep = 0
		self.maxhp = 0
		self.maxep = 0
		self.attack = 0
		self.defense = 0
		self.gold = 0
		self.exp = 0
		self.level = 0
		self.skillpoints = 1

		#stores attack/defense/hp/ep, adjusted by equipment.
		#kept correct by main.refreshmap(). Use these for calculations.
		self.adj_attack = 0
		self.adj_defense = 0
		self.adj_maxhp = 0
		self.adj_maxep = 0

		#Name of current hero picture.
		self.cur_hero = "people/hero_w.png"

		#skills array. Each skill is a separate line in the array. Each line goes:
		#name, effect, level, price, description, acquired
		#effect is an integer that tells battle.py which case in a select to pick.
		#level is the skillpoints required to get the skill,
		#price is the ep needed to use.
		#acquired tells if the skill has already been learned by the player.
		self.skill = []

		#equipment:
		#equip[0]=weapon, [1]=armor, [2]=shield
		#[3]=helmet, [4]=gloves, [5]=boots

		#An array of numbers, which are either the index of the
		#item in the item[] array, or -1 for empty.
		self.equip = []
		for x in range(6):
			self.equip.append(-1)

	#Gives the player the specified amount of experience; also handles level gains.
	def add_exp(self, input_exp):
		self.exp = int(self.exp) + int(input_exp)
		#Has the player gained a level?
		if int(self.exp) >= int(10*(self.level + 1)*(self.level + 1)):
			self.level=self.level+1
			g.main.print_message("You gain a level.")
			g.action.activate_lines(g.xgrid, g.ygrid, g.zgrid, g.levelup_act)


player = player_class()
