#file: new_game.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file creates a new character.
#Either call directly (which will use the first module seen), or
#call from rpg.py after setting g.mod_directory.

from Tkinter import *
#needed for the buttons.
import ImageTk
import Image

import g

from player import *

import main
import loadgame

#main stats for character. Taken from g.hp etc.
name = StringVar()
hp = StringVar()
ep = StringVar()
attack = StringVar()
defense = StringVar()
gold = StringVar()

help_text = StringVar()

#distance from the top of the button canvas each button should be placed.
#Values are added in init_window. begin is not needed; always zero.
reroll_height = 0
load_height = 0
quit_height = 0

#currently selected button. 0=Begin, 1=Reroll, 2=Load, 3=Quit
cur_button = 0

already_started_game = 0

#give new stats for the character. Called when pressing the
#"Reroll stats" button. This is longer than expected, as the
#"Begin game" button must also work when loading a game, so all
#game-start stuff has been placed in here.
#It seems to run fast enough, though.
def reroll_stats():
	player.name = name.get()

	#actual re-rolling
	hp.set(g.die_roll(g.new_game_dice[0][0], g.new_game_dice[0][1]) +
		g.new_game_dice[0][2])
	ep.set(g.die_roll(g.new_game_dice[1][0], g.new_game_dice[1][1]) +
		g.new_game_dice[1][2])
	attack.set(g.die_roll(g.new_game_dice[2][0], g.new_game_dice[2][1]) +
		g.new_game_dice[2][2])
	defense.set(g.die_roll(g.new_game_dice[3][0], g.new_game_dice[3][1]) +
		g.new_game_dice[3][2])
	gold.set(g.die_roll(g.new_game_dice[4][0], g.new_game_dice[4][1]) +
		g.new_game_dice[4][2])

	reset_vars()


#call to reset the game
def reset_vars():
	#move variables to player.*
	player.maxhp = int(hp.get())
	player.maxep = int(ep.get())
	player.attack = int(attack.get())
	player.defense = int(defense.get())
	player.gold = int(gold.get())

	player.exp = 0
	player.level = 0
	player.skillpoints = 0
	player.hp = player.maxhp
	player.ep = player.maxep

	#place the player
	g.xgrid = 0
	g.ygrid= 0
	g.zgrid = 0

	timestep = 0
	cur_mon_hp = 0
	g.var_list = {}
	g.item.dropped_items = []

	#clear the inventory
	for i in range(len(g.item.inv)):
		g.item.inv[i]= -1
	for i in range(len(player.equip)):
		player.equip[i]= -1
	#clear skills
	for i in range(len(player.skill)):
		player.skill[i][5] = 0
	global new_game
	new_game = 1


#get stats from g.*
def get_stats():
	name.set(player.name)
	hp.set(player.hp)
	ep.set(player.ep)
	attack.set(player.attack)
	defense.set(player.defense)
	gold.set(player.gold)


#Use the stats given to create a new character.
def begin_game():
	global already_started_game
	if already_started_game == 1: return 0
	already_started_game = 1
	g.read_maps()
	g.item.load_dropped_items()

	#just in case someone changed the name
	#after rerolling or loading
	player.name = name.get()

	if player.name == "":
		player.name = "Nameless"
	#bring the main window up.
	window_new_game.withdraw()
	main.init_window_main(new_game)
	already_started_game = 0
	try:
		if window_new_game.winfo_exists():
			window_new_game.deiconify()
	except TclError:
		pass

	#after returning to this screen, reset everything.
	reroll_stats()

def load_game():
	#bring the loadgame window up.
	window_new_game.withdraw()
	global new_game
	load_game = 0
	load_game = loadgame.init_window_loadgame()
	if load_game == 1: new_game = 0
	try:
		if window_new_game.winfo_exists():
			window_new_game.deiconify()
	except TclError:
		pass
	get_stats()

def quit_game():
	window_new_game.destroy()

#refresh the buttons.
def refresh_buttons():
	canvas_buttons.delete(ALL)
	if (cur_button == 0):
		canvas_buttons.create_image(0, 0, anchor=NW,
							image=g.buttons["begin_sel.png"], tags="begin")
		help_text.set("Begin a new game")
	else: canvas_buttons.create_image(0, 0, anchor=NW,
							image=g.buttons["begin.png"], tags="begin")
	if (cur_button == 1):
		canvas_buttons.create_image(0, reroll_height, anchor=NW,
							image=g.buttons["reroll_sel.png"], tags="reroll")
		help_text.set("Reroll your statistics")
	else: canvas_buttons.create_image(0, reroll_height, anchor=NW,
							image=g.buttons["reroll.png"], tags="reroll")
	if (cur_button == 2):
		canvas_buttons.create_image(0, load_height, anchor=NW,
							image=g.buttons["load_sel.png"], tags="load")
		help_text.set("Load an old game")
	else: canvas_buttons.create_image(0, load_height, anchor=NW,
							image=g.buttons["load.png"], tags="load")
	if (cur_button == 3):
		canvas_buttons.create_image(0, quit_height, anchor=NW,
							image=g.buttons["quit_sel.png"], tags="quit")
		help_text.set("Quit this game")
	else: canvas_buttons.create_image(0, quit_height, anchor=NW,
							image=g.buttons["quit.png"], tags="quit")


#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(key_name):
	global cur_button
	entry_name.focus_set()
	if (key_name == "esc"):
		quit_game()
		return 0
	elif (key_name == "up"):
		cur_button -= 1
		if (cur_button == -1): cur_button = 3
	elif (key_name == "down"):
		cur_button += 1
		if (cur_button == 4): cur_button = 0
	elif (key_name == "left"):
		pass
	elif (key_name == "right"):
		pass
	elif (key_name == "return"):
		if   (cur_button == 0):
			begin_game()
		elif (cur_button == 1):
			reroll_stats()
		elif (cur_button == 2):
			load_game()
		elif (cur_button == 3):
			quit_game()
			return 0

	refresh_buttons()


def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")


def mouse_handler_click(event=0):
	key_handler("return")

def mouse_handler_move(event=0):
	global cur_button
	if (event.y < reroll_height): cur_button = 0
	elif (event.y < load_height): cur_button = 1
	elif (event.y < quit_height): cur_button = 2
	else: cur_button = 3
	refresh_buttons()

#called upon game start
def init_window():
	global window_new_game
	window_new_game = Toplevel()
	window_new_game.title(g.game_name)
	window_new_game.resizable(0, 0)
	window_new_game.maxsize(1000, 1000)
	window_new_game.wm_geometry("+%d+%d" % (20, 20))

	global bgcolour
	bgcolour="lightgrey"

	new_game = Frame(window_new_game, bg=bgcolour)
	new_game.grid(row=0, column=0);

	global label_help
	label_help = Label(new_game, textvariable=help_text, bg=bgcolour)
	label_help.grid(row=1, column=3, sticky=W) #, columnspan=3)

	#formatting for the labels.
	label_formatting = Label(new_game,
		text="Name:", bg=bgcolour).grid(row=2, column=2, sticky=E+S)
	label_formatting = Label(new_game,
		text="Hit points:", bg=bgcolour).grid(row=3, column=2, sticky=E)
	label_formatting = Label(new_game,
		text="Energy points:", bg=bgcolour).grid(row=4, column=2, sticky=E)
	label_formatting = Label(new_game,
		text="Attack:", bg=bgcolour).grid(row=5, column=2, sticky=E)
	label_formatting = Label(new_game,
		text="Defense:", bg=bgcolour).grid(row=6, column=2, sticky=E)
	label_formatting = Label(new_game,
		text="Gold:", bg=bgcolour).grid(row=7, column=2, sticky=E+N)

	#display of stats
	name.set(g.default_player_name)
	global entry_name
	entry_name = Entry(new_game, bg= 'white',
		textvariable=name)
	entry_name.grid(row=2, column=3, sticky=W+S)
	label_hp = Label(new_game,
		textvariable=hp, bg=bgcolour).grid(row=3, column=3, sticky=W)
	label_ep = Label(new_game,
		textvariable=ep, bg=bgcolour).grid(row=4, column=3, sticky=W)
	label_attack = Label(new_game,
		textvariable=attack, bg=bgcolour).grid(row=5, column=3, sticky=W)
	label_defense = Label(new_game,
		textvariable=defense, bg=bgcolour).grid(row=6, column=3, sticky=W)
	label_gold = Label(new_game,
		textvariable=gold, bg=bgcolour).grid(row=7, column=3, sticky=W+N)



	#add height values
	global reroll_height
	global load_height
	global quit_height
	reroll_height = g.buttons["begin.png"].height()
	load_height = reroll_height + g.buttons["reroll.png"].height()
	quit_height = load_height + g.buttons["load.png"].height()

	#Canvas for buttons
	global canvas_buttons
	canvas_buttons = Canvas(new_game, width=g.buttons["begin.png"].width(),
		bg="#d3d3d3", height=quit_height +
		g.buttons["quit.png"].height(), highlightthickness=0)
	canvas_buttons.grid(column=1, row=1, rowspan=20, sticky=N+W+E)

	entry_name.focus_set()
	refresh_buttons()

	#give basic values.
	reroll_stats()


	#bindings
	window_new_game.bind(g.binding_cancel, key_handler_esc)
	window_new_game.bind(g.binding_action, key_handler_return)
	window_new_game.bind(g.binding_up, key_handler_up)
	window_new_game.bind(g.binding_down, key_handler_down)
	window_new_game.bind(g.binding_left, key_handler_left)
	window_new_game.bind(g.binding_right, key_handler_right)
	canvas_buttons.bind("<ButtonRelease-1>", mouse_handler_click)
	canvas_buttons.bind("<Motion>", mouse_handler_move)

	window_new_game.master.wait_window(window_new_game)
