#file: shop.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file controls the town shops.


from Tkinter import *
#needed for the buttons.
import ImageTk
import Image

import main
import g
import item
from player import *



#location of the store in the g.shops[] array
global store_num
store_num = 0

#width/height of inv and shop windows, in tiles.
# (g.tilesize + the 3 pixel border)
shop_width = 4
shop_height = 7

#Currently selected item number
curr_item = 0
#If inv (0) or shop (1) has focus.
curr_focus = 1

#currently selected button: 0=sell 1=leave 2=buy
cur_button=2

leave_height=0
buy_height=0
sell_height=0

#array containing the item[] index of all inventory items.
#Used to determine which item to sell/drop
#global listbox_inv_array
#listbox_inv_array = []

#variables for the middle info display
item_name  = StringVar()
item_cost  = StringVar()
#item_value = StringVar()
item_power = StringVar()
item_desc  = StringVar()
curr_gold  = StringVar()
curr_skill = StringVar()

global store_name
store_name = StringVar()

temp_canvas_width=0
temp_canvas_height=0
canvas_x_start = 0
canvas_y_start = 0


temp_button_x = 0
temp_button_width = 0
temp_button_y = 0


back_to_main = StringVar()

#refresh the button canvas
def refresh_buttons(event=0):

	main.canvas_map.delete("shop_buttons")
	main.canvas_map.create_rectangle(temp_button_x, temp_button_y,
				temp_button_x+temp_button_width,
				temp_button_y+g.buttons["sell.png"].height(), fill=bgcolour,
				tags=("shop_buttons", "shop"))
	if (cur_button == 0): main.canvas_map.create_image(
						temp_button_x, temp_button_y, anchor=NW,
						image=g.buttons["sell_sel.png"],
						tags=("shop_buttons", "shop"))
	else: main.canvas_map.create_image(temp_button_x, temp_button_y, anchor=NW,
						image=g.buttons["sell.png"],
						tags=("shop_buttons", "shop"))

	if (cur_button == 1): main.canvas_map.create_image(
						temp_button_x+leave_height, temp_button_y,
						anchor=NW, image=g.buttons["leave_shop_sel.png"],
						tags=("shop_buttons", "shop"))
	else: main.canvas_map.create_image(temp_button_x+leave_height,
						temp_button_y, anchor=NW,
						image=g.buttons["leave_shop.png"],
						tags=("shop_buttons", "shop"))

	if (cur_button == 2): main.canvas_map.create_image(
						temp_button_x+buy_height, temp_button_y, anchor=NW,
						image=g.buttons["buy_sel.png"],
						tags=("shop_buttons", "shop"))
	else: main.canvas_map.create_image(temp_button_x+buy_height,
						temp_button_y, anchor=NW,
						image=g.buttons["buy.png"],
						tags=("shop_buttons", "shop"))


#refresh the inventory canvas
# def refresh_inv():
# 	canvas_inv.delete("inv")

#Actually sets the info in the middle of the shop screen.
def set_details(name, cost, value, costtype, power, description, inv_or_shop):
	main.canvas_map.delete("shop_details")

	main.canvas_map.create_text(canvas_x_start+temp_canvas_width+5,
		canvas_y_start+25, anchor=W, text=name, tags=("shop_details", "shop"))

	if inv_or_shop == "shop":
		if cost != "":
				main.canvas_map.create_text(canvas_x_start+temp_canvas_width+5,
				canvas_y_start+40, anchor=W, text="Cost: "+str(cost),
				tags=("shop_details", "shop"))
	elif inv_or_shop == "inv":
		if value != "":
			main.canvas_map.create_text(canvas_x_start+temp_canvas_width+5,
			canvas_y_start+40, anchor=W, text="Value: "+str(value),
			tags=("shop_details", "shop"))
	if power == "" or power == "-1": pass
	else: main.canvas_map.create_text(canvas_x_start+temp_canvas_width+5,
		canvas_y_start+55, anchor=W, text="Power: "+str(power),
		tags=("shop_details", "shop"))

	main.canvas_map.create_text(canvas_x_start+temp_canvas_width+5,
		canvas_y_start+70, anchor=NW, width=130, text=description,
		tags=("shop_details", "shop"))

#show info for a selected item in the middle of the window.
def show_details(event=0, sel_item=-1):
	#The use of sel_item gives the ability to look at an item without selecting
	#it, while working normally the rest of the time.
	if sel_item == -1: sel_item = curr_item
	if curr_focus == 0:  #inv
		if sel_item < len(item.inv):
			if item.inv[sel_item] != -1:
				tempitem = item.item[item.inv[sel_item]]
				if (tempitem.type == 14 and
					g.shops[store_num].name == "a Gem Shop"):
					set_details(tempitem.name, tempitem.price, tempitem.price, "gold",
									tempitem.quality, tempitem.description, "inv")
				else:
					set_details(tempitem.name, tempitem.price, tempitem.value, "gold",
									tempitem.quality, tempitem.description, "inv")
		#if there is no item selected, blank details.
			else: set_details("", "", "", "", "", "", "inv")
		else: set_details("", "", "", "", "", "", "inv")

	else:  #shop
		if sel_item < len(g.shops[store_num].itemlist):
			tempitem = g.shops[store_num].itemlist[sel_item]
			set_details(tempitem.item_name, tempitem.cost, tempitem.value, tempitem.buytype,
										tempitem.power, tempitem.description, "shop")
		else: set_details("", "", "", "", "", "", "shop")

#place appropriate items into the store.
def refresh_shop():
	main.canvas_map.delete("item")
	invpos = 0
	#if the shop is selected, draw a selection box around the current item.
	if curr_focus == 1:
		main.canvas_map.create_rectangle(
			canvas_x_start+temp_canvas_width*2+(curr_item%shop_width)*g.tilesize + 2 *
												((curr_item%shop_width)+1),
			canvas_y_start+(curr_item/shop_width)*g.tilesize + 2 *
												((curr_item/shop_width)+1),
			canvas_x_start+temp_canvas_width*2+((curr_item%shop_width)+1)*(g.tilesize + 2),
			canvas_y_start+((curr_item/shop_width)+1)*(g.tilesize + 2),
											fill=g.fill_sel_colour, tags=("item", "shop"))

	#draw the item pictures.
	for i in range(len(g.shops[store_num].itemlist)):
		if i != -1:
			main.canvas_map.create_image(
				canvas_x_start+temp_canvas_width*2+(invpos%shop_width)*g.tilesize + 2 *
													((invpos%shop_width)+1),
				canvas_y_start+(invpos/shop_width)*g.tilesize + 2 * ((invpos/shop_width)+1),
				image=g.tiles[g.shops[store_num].itemlist[i].picture],
				anchor="nw", tags=("item", "shop"))
			invpos += 1
	invpos = 0
	#if the inv is selected, draw a selection box around the current item.
	if curr_focus == 0:
		main.canvas_map.create_rectangle(
				canvas_x_start+(curr_item%shop_width)*g.tilesize +
							2 * ((curr_item%shop_width)+1),
				canvas_y_start+(curr_item/shop_width)*g.tilesize +
							2 * ((curr_item/shop_width)+1),
				canvas_x_start+((curr_item%shop_width)+1)*(g.tilesize + 2),
				canvas_y_start+((curr_item/shop_width)+1)*(g.tilesize + 2),
							fill=g.fill_sel_colour, tags=("item", "shop"))

	#draw the item pictures.
	for i in range(len(item.inv)):
		if item.inv[i] != -1:
			main.canvas_map.create_image(canvas_x_start+(i%shop_width)*g.tilesize + 2 *
												((i%shop_width)+1),
				canvas_y_start+(i/shop_width)*g.tilesize + 2 * ((i/shop_width)+1),
				image=g.tiles[item.item[item.inv[i]].picturename],
				anchor="nw", tags=("item", "shop"))
			invpos += 1

	#set gold and skillpoints
	main.canvas_map.create_text(canvas_x_start+temp_canvas_width+5,
		canvas_y_start+temp_canvas_height-20, anchor=SW,
		text=g.gold_name+": "+str(player.gold), tags=("item", "shop"))
	main.canvas_map.create_text(canvas_x_start+temp_canvas_width+5,
		canvas_y_start+temp_canvas_height-2, anchor=SW,
		text=g.skill_name+": "+str(player.skillpoints), tags=("item", "shop"))
#	curr_gold.set("Gold: " + str(player.gold))
#	curr_skill.set("Skillpoints: " + str(player.skillpoints))
	main.recalc_stats()

#called upon pressing "Sell". Uses the selected item.
def sell_item():
	if curr_focus != 0: return 0
	if curr_item > len(item.inv): return 0
	if item.inv[curr_item] == -1: return 0

	if item.item[item.inv[curr_item]].price == 0:
		main.print_message("You feel attached to your " +
			item.item[item.inv[curr_item]].name)
		return 0
	#give the player money
	#note that all stores have a 5 year, money-back guarantee,
	#and accept returns from other stores as well.
	#This means there is no need to doublecheck intent. ;)
	#FIXME: this is no longer true since gems aren't paid for
	#full value anywhere but the gem shop
	#print g.shops[store_num].name
	if (item.item[item.inv[curr_item]].type == 14 and
				g.shops[store_num].name == "a Gem Shop"):
		main.print_message("The Gem Shop owner is happy to pay the true value of your gems.")
		player.give_stat("gold", item.item[item.inv[curr_item]].price)
	else:
		player.give_stat("gold", item.item[item.inv[curr_item]].value)

	main.print_message("You sell your " + item.item[item.inv[curr_item]].name
		+ ".")

	#remove the item
	item.drop_inv_item(curr_item)
	#refresh_inv()
	refresh_shop()
	show_details()


#Call on pressing "Buy". Uses the selected item.
def buy_item():
	if curr_focus != 1: return 0
	if curr_item >= len(g.shops[store_num].itemlist): return 0

	if (g.shops[store_num].itemlist[curr_item].buytype == "gold"):
		#if enough gold
		if int(g.shops[store_num].itemlist[curr_item].cost) <= int(player.gold):
			#if no actions were given
			if (len(g.shops[store_num].itemlist[curr_item].actions) == 0):
				#if given successfully.
				if (main.action.run_command(0, 0, 0, "item(\"" +
						g.shops[store_num].itemlist[curr_item].item_name+"\")")
						== 1):
					main.print_message("You buy a " +
					g.shops[store_num].itemlist[curr_item].item_name + ".")
					player.give_stat("gold", -1*
						int(g.shops[store_num].itemlist[curr_item].cost))
				else: #not enough room
					main.print_message("Your inventory is full.")
			else:
				temp = main.action.activate_lines(0, 0, 0,
						g.shops[store_num].itemlist[curr_item].actions)
				if temp == 1:
					player.give_stat("gold", -1*
							int(g.shops[store_num].itemlist[curr_item].cost))
	else: #skillpoints
		#if enough skillpoints
		if int(g.shops[store_num].itemlist[curr_item].cost) <= \
													int(player.skillpoints):
			#if no actions were given
			if (len(g.shops[store_num].itemlist[curr_item].actions) == 0):
				#if given successfully.
				if (main.action.run_command(0, 0, 0, "item(\"" +
						g.shops[store_num].itemlist[curr_item].item_name+"\")")
						== 1):
					main.print_message("You buy a " +
					g.shops[store_num].itemlist[curr_item].item_name + ".")
					player.give_stat("skillpoints", -1*
					int(g.shops[store_num].itemlist[curr_item].cost))
			else:
				temp = main.action.activate_lines(0, 0, 0,
							g.shops[store_num].itemlist[curr_item].actions)
				if temp == 1:
					player.give_stat("skillpoints", -1*
							int(g.shops[store_num].itemlist[curr_item].cost))

	#refresh_inv()
	refresh_shop()
	show_details()

#Used in mouse_sel_inv and mouse_sel_shop. Takes x y coordinates, and returns
#the selected box, or -1 for none.
def which_box(x, y):
	if x < 3: return -1
	tempx = x - 3
	likelyx = tempx / (g.tilesize + 2)
	tempx = tempx - (likelyx * (g.tilesize + 2))
	if tempx >= g.tilesize - 1: return -1

	if y < 3: return -1
	tempy = y - 3
	likelyy = tempy / (g.tilesize + 2)
	tempy = tempy - (likelyy * (g.tilesize + 2))
	if tempy >= g.tilesize - 1: return -1

	if likelyx >= shop_width: return -1
	if likelyy * shop_width + likelyx >= shop_width * shop_height: return -1

	return likelyy * shop_width + likelyx

#called when the user releases the mouse in the inv canvas.
def mouse_sel_inv(event=0):
	#decide if the mouse is within one of the boxes.
	global curr_item
	global curr_focus
	temp_num =  which_box(event.x, event.y)
	if temp_num == -1: return
	curr_item = temp_num
	curr_focus = 0
	#refresh_inv()
	refresh_shop()
	show_details()

#called when the user releases the mouse in the shop canvas.
def mouse_sel_shop(event=0):
	global curr_item
	global curr_focus
	global cur_button
	#Is the mouse at least in the general area?.
	if event.x < canvas_x_start or event.y < canvas_y_start:
		return 0

	temp_num = which_box(event.x-canvas_x_start, event.y-canvas_y_start)
	if temp_num != -1:
		curr_item = temp_num
		curr_focus = 0
		cur_button = 0
		refresh_shop()
		show_details()
		return 0

	temp_num = which_box(event.x-canvas_x_start-temp_canvas_width*2,
											event.y-canvas_y_start)
	if temp_num != -1:
		curr_item = temp_num
		curr_focus = 1
		cur_button = 2
		refresh_shop()
		show_details()
		return 0

	if (event.x > temp_button_x and event.x < temp_button_x + temp_button_width
			and event.y > temp_button_y and
			event.y < temp_button_y + g.buttons["buy.png"].height()):
		if (event.x < temp_button_x + leave_height):
			sell_item()
		elif (event.x < temp_button_x + buy_height):
			leave_shop()
			return 0
		else: buy_item()
		refresh_buttons()

def leave_shop(event=0):
	try:
		back_to_main.set(1)
	except TclError:
		pass

def mouse_handler_dbl(event=0):
	global curr_item
	global curr_focus
	global cur_button
	#Is the mouse at least in the general area?.
	if event.x < canvas_x_start or event.y < canvas_y_start:
		return 0

	temp_num = which_box(event.x-canvas_x_start, event.y-canvas_y_start)
	if temp_num != -1:
		curr_item = temp_num
		curr_focus = 0
		cur_button = 0
		sell_item()
		refresh_shop()
		show_details()
		return 0

	temp_num = which_box(event.x-canvas_x_start-temp_canvas_width*2,
											event.y-canvas_y_start)
	if temp_num != -1:
		curr_item = temp_num
		curr_focus = 1
		cur_button = 2
		buy_item()
		refresh_shop()
		show_details()
		return 0


def mouse_handler_move(event=0):
	global cur_button
	if (event.x > temp_button_x and event.x < temp_button_x + temp_button_width
			and event.y > temp_button_y and
			event.y < temp_button_y + g.buttons["buy.png"].height()):
		if (event.x < temp_button_x + leave_height):
			cur_button = 0
		elif (event.x < temp_button_x + buy_height):
			cur_button = 1
		else: cur_button = 2
		refresh_buttons()

#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(switch):
	global curr_item
	global cur_button
	global curr_focus
	#switch based on keycode
	if (switch == "esc"):
		leave_shop()
		return
	elif (switch == "return"):
		if(curr_focus == 1 and cur_button == 2): buy_item()
		elif(curr_focus !=1 and cur_button == 0): sell_item()
		elif(cur_button == 1):
			leave_shop()
			return
	elif (switch == "left"):
		if (curr_item % shop_width == 0):  #move between lists
			if curr_focus == 0:
				curr_focus = 1
				cur_button = 2
			else:
				curr_focus = 0
				cur_button = 0
			curr_item += shop_width
		curr_item -= 1
	elif (switch == "right"):
		if (curr_item % shop_width == shop_width - 1):  #move between lists
			if curr_focus == 0:
				curr_focus = 1
				cur_button = 2
			else:
				curr_focus = 0
				cur_button = 0
			curr_item -= shop_width
		curr_item += 1
	elif (switch == "up"):
		curr_item = curr_item - shop_width
		if curr_item < 0:
			curr_item += shop_width * shop_height
	elif (switch == "down"):
		curr_item = curr_item + shop_width
		if curr_item >= shop_width * shop_height:
			curr_item -= shop_width * shop_height

	#refresh_inv()
	refresh_shop()
	refresh_buttons()
	show_details()

#Python does not appear to allow arguments in callbacks. Grumble.
# Yes, I think it does.  take a look at the use of lambda in the
# map editor.
def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")

#create window_shop
def init_window_shop(store_type_input):
	g.cur_window = "shop"
	global temp_canvas_width; global temp_canvas_height
	global canvas_x_start; global canvas_y_start
	global temp_button_x; global temp_button_width; global temp_button_y
	temp_canvas_width=(g.tilesize*shop_width)+ ((shop_width+1)*2) + 1
	temp_canvas_height=(g.tilesize*shop_height)+ ((shop_height+1)*2) + 1
	canvas_x_start = ((g.tilesize*main.mapsizex)-temp_canvas_width * 3)/2
	canvas_y_start = ((g.tilesize*main.mapsizey)-temp_canvas_height)/2
	temp_button_x = canvas_x_start + (temp_canvas_width*3)/2- \
			g.buttons["sell.png"].width()-g.buttons["leave_shop.png"].width()/2
	temp_button_width = g.buttons["sell.png"].width()+ \
			g.buttons["leave_shop.png"].width() + g.buttons["buy.png"].width()
	temp_button_y = canvas_y_start + temp_canvas_height+1

	main.canvas_map.delete("shop")
#	global window_shop
	global bgcolour
	bgcolour = "lightgrey"
#	window_shop = Frame(main.top, bd=4, relief=GROOVE, bg=bgcolour)
#	window_shop.grid(row=1, column=5, columnspan=13, sticky=E)
	main.canvas_map.create_rectangle(canvas_x_start-2,canvas_y_start-19,
		temp_canvas_width*2+canvas_x_start+temp_canvas_width+1,
		canvas_y_start+temp_canvas_height+1, fill=bgcolour, tags="shop")

	global curr_item
	curr_item = 0
	global curr_focus
	curr_focus = 1
	global cur_button
	cur_button = 2

	store_type_input=store_type_input.lower()
	global store_num
	for i in range(len(g.shops)):
		if (g.shops[i].name.lower() == store_type_input):
			store_num = i
			break

	#Inventory canvas
	global canvas_inv
	#canvas_inv = Canvas(window_shop, width=temp_canvas_width,
	#	height=temp_canvas_height, highlightthickness=0, bg=g.outline_colour)
	#canvas_inv.grid(column=1, row=2, columnspan=2, rowspan=16)
	#outside border
	main.canvas_map.create_rectangle(canvas_x_start,canvas_y_start,
		canvas_x_start+temp_canvas_width-1,
		canvas_y_start+temp_canvas_height-1, tags="shop")
	#per-item borders
	for y in range(shop_height):
		for x in range(shop_width):
			main.canvas_map.create_rectangle(canvas_x_start+x*g.tilesize + 2 * (x+1),
										canvas_y_start+y*g.tilesize + 2 * (y+1),
										canvas_x_start+(x+1)*(g.tilesize + 2),
										canvas_y_start+(y+1)*(g.tilesize + 2),
										fill=g.fill_colour, tags="shop")

	#Shop canvas
	#global canvas_shop
	#canvas_shop = Canvas(window_shop, width=temp_canvas_width,
	#	height=temp_canvas_height, highlightthickness=0, bg=g.outline_colour)
	#canvas_shop.grid(column=6, row=2, columnspan=2, rowspan=16)
	#outside border
	main.canvas_map.create_rectangle(temp_canvas_width*2+canvas_x_start,canvas_y_start,
		temp_canvas_width*2+canvas_x_start+temp_canvas_width-1,
		canvas_y_start+temp_canvas_height-1, tags="shop")
	#per-item borders
	for y in range(shop_height):
		for x in range(shop_width):
			main.canvas_map.create_rectangle(
				temp_canvas_width*2+canvas_x_start+x*g.tilesize + 2 * (x+1),
				canvas_y_start+y*g.tilesize + 2 * (y+1),
				temp_canvas_width*2+canvas_x_start+(x+1)*(g.tilesize + 2),
				canvas_y_start+(y+1)*(g.tilesize + 2), fill=g.fill_colour, tags="shop")

	#Info labels
# 	global store_name
# 	store_name.set(g.shops[store_num].name)
# 	label_inv = Label(window_shop, text="Inventory",
# 		bg=bgcolour).grid(row=1, column=2, sticky=W)
	main.canvas_map.create_text(canvas_x_start+(temp_canvas_width*1)/2,
		 canvas_y_start-1, anchor=S, text="Inventory", tags="shop")
	main.canvas_map.create_text(canvas_x_start+(temp_canvas_width*5)/2,
		 canvas_y_start-1, anchor=S, text=g.shops[store_num].name, tags="shop")
# 	label_shop = Label(window_shop, textvar=store_name,
# 		bg=bgcolour).grid(row=1, column=6, sticky=E)
# 	label_name = Label(window_shop, textvar=item_name,
# 		wraplength=143, bg=bgcolour).grid(row=8, column=3, sticky=NW)
# 	global label_cost
# 	label_cost = Label(window_shop,
# 		textvar=item_cost, bg=bgcolour)
# 	label_cost.grid(row=9, column=3, sticky=W)
# 	label_value = Label(window_shop,
# 		textvar=item_value, bg=bgcolour).grid(row=9, column=3, sticky=W)
# 	label_power = Label(window_shop,
# 		textvar=item_power, bg=bgcolour).grid(row=11, column=3, sticky=W)

# 	global canvas_desc
# 	canvas_desc = Canvas(window_shop, width=143, highlightthickness=0,
# 			bg=bgcolour)
# 	canvas_desc.grid(row=12, column=3, rowspan=8, sticky=NSEW)

# 	label_skill = Label(window_shop, textvar=curr_skill, anchor=SW,
# 		bg=bgcolour).grid(row=18, column=3, sticky=SW)
# 	label_gold = Label(window_shop, textvar=curr_gold, anchor=NW,
# 		bg=bgcolour).grid(row=19, column=3, sticky=W)


	global leave_height; leave_height = g.buttons["sell.png"].width()
	global buy_height; buy_height = leave_height + g.buttons["leave.png"].width()

# 	global canvas_buttons
# 	canvas_buttons = Canvas(window_shop, height=g.buttons["buy.png"].height(),
# 		width=buy_height+g.buttons["buy.png"].width(), bg=bgcolour)
# 	canvas_buttons.grid(column=1, row=29, columnspan=8)


#	global button_sell
#	button_sell = Button(window_shop, text="Sell", command=sell_item,
#		bg=bgcolour)
#	button_sell.grid(row=28, column=1)
#	global button_buy
#	button_buy  = Button(window_shop, text="Buy",  command=buy_item,
#		bg=bgcolour)
#	button_buy.grid(row=28, column=6)
#	button_leave= Button(window_shop, text="Leave",
#		command=leave_shop, bg=bgcolour).grid(row=28, column=3)

	#get data in listboxes
#	refresh_inv()
	refresh_shop()
	refresh_buttons()

#	main.canvas_map.unbind("<Motion>")
	#main.canvas_map.unbind("<Button-1>")
	shop_bind_keys()
	show_details()
	g.window_main.wait_variable(back_to_main)
	main.canvas_map.delete("shop")

def shop_bind_keys():
	#bindings
	g.window_main.bind("<ButtonRelease-1>", mouse_sel_shop)
	g.window_main.bind("<Double-Button-1>",  mouse_handler_dbl)
	g.window_main.bind("<Motion>", mouse_handler_move)
	g.window_main.bind(g.binding_cancel, key_handler_esc)
	g.window_main.bind(g.binding_left, key_handler_left)
	g.window_main.bind(g.binding_right, key_handler_right)
	g.window_main.bind(g.binding_up, key_handler_up)
	g.window_main.bind(g.binding_down, key_handler_down)
	g.window_main.bind(g.binding_action, key_handler_return)
	g.window_main.bind(g.binding_inv, key_handler)
	g.window_main.bind(g.binding_save, key_handler)
	g.window_main.bind(g.binding_quit, key_handler)
