#loadgame.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file controls the load game screen. The actual load/save game
#functions are in g.loadgame/savegame

from Tkinter import *
import ImageTk
import g
from os import listdir, path, mkdir, remove

#was a game loaded? Used to determine whether to use newgame script.
did_load = 0
global cur_button
cur_button = 0

global saves_array
saves_array = []

global saves_pos
saves_pos = 0

global prevent_dbl_load
prevent_dbl_load = 0

help_text = StringVar()
name_text = ""
hp_text = ""
ep_text = ""
attack_text = ""
defense_text = ""
gold_text = ""
exp_text = ""
level_text = ""

return_from_loadgame = StringVar()

#called when "Load" is pressed
def load_selected():
	global return_from_loadgame
	global did_load
	global prevent_dbl_load

	if len(saves_array) == 0: return

	if prevent_dbl_load == 1: return
	prevent_dbl_load = 1
	#if (listbox_saves.size() == 0): return
	#find the name of the save to load
	#try: item_num = map(int, listbox_saves.curselection())
	#except ValueError: pass
	#save_title = listbox_saves.get(item_num[0])
	canvas_map.create_rectangle(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3, g.tilesize*g.main.mapsizex*3/4,
		g.tilesize*g.main.mapsizey/3+140+g.buttons["load_scr.png"].height(),
		fill="#e3e3e3", tags="loadgame")
	canvas_map.create_text(g.tilesize*g.main.mapsizex/2,
		g.tilesize*g.main.mapsizey/3+70+g.buttons["load_scr.png"].height()/2,
		text="Loading game. Please wait", tags="loadgame")

	g.window_main.update_idletasks()

	g.loadgame(saves_array[saves_pos])
	did_load = 1
	canvas_map.delete("loadgame")
	return_from_loadgame.set(1)
	#window_loadgame.destroy()

#Uses saves_pos to display infomation about that save.
def refresh_save_info(event=0):
	#This is the bad way to do this, as it needs updating whenever the
	#save format changes significantly.

	if len(saves_array) == 0:
		canvas_map.itemconfigure("loadgame_name",
				text="")
		canvas_map.itemconfigure("loadgame_hp",
				text="")
		canvas_map.itemconfigure("loadgame_ep",
				text="")
		canvas_map.itemconfigure("loadgame_attack",
				text="")
		canvas_map.itemconfigure("loadgame_defense",
				text="")
		canvas_map.itemconfigure("loadgame_gold",
				text="")
		canvas_map.itemconfigure("loadgame_exp",
				text="")
		canvas_map.itemconfigure("loadgame_level",
				text="")
		for i in range(5):
			canvas_map.itemconfigure("load_savegame_rect"+str(i), fill="#e3e3e3")
			canvas_map.itemconfigure("load_savegame"+str(i), text="")
		return

	save_loc = g.mod_directory + "/saves/" + saves_array[saves_pos]
	savefile=open(save_loc, 'r')
	version_unused = g.pickle.load(savefile)
	name_text = str(g.pickle.load(savefile))
	hp_text = str(g.pickle.load(savefile))
	ep_text = str(g.pickle.load(savefile))
	unused_maxhp = g.pickle.load(savefile)
	unused_maxep = g.pickle.load(savefile)
	attack_text = str(g.pickle.load(savefile))
	defense_text = str(g.pickle.load(savefile))
	gold_text = str(g.pickle.load(savefile))
	exp_text = str(g.pickle.load(savefile))
	level_text = str(g.pickle.load(savefile))

	#canvas_map.delete("loadgame_info")
	canvas_map.itemconfigure("loadgame_name",
			text=g.name_name+": " + name_text)
	canvas_map.itemconfigure("loadgame_hp",
			text=g.hp_name+": " + hp_text)
	canvas_map.itemconfigure("loadgame_ep",
			text=g.ep_name+": " + ep_text)
	canvas_map.itemconfigure("loadgame_attack",
			text=g.attack_name+": " + attack_text)
	canvas_map.itemconfigure("loadgame_defense",
			text=g.defense_name+": " + defense_text)
	canvas_map.itemconfigure("loadgame_gold",
			text=g.gold_name+": " + gold_text)
	canvas_map.itemconfigure("loadgame_exp",
			text=g.exp_name+": " + exp_text)
	canvas_map.itemconfigure("loadgame_level",
			text=g.level_name+": " + level_text)

	savefile.close()

	tmp = saves_pos - (saves_pos % 5)
	for i in range(5):
		if i == saves_pos % 5:
			canvas_map.itemconfigure("load_savegame_rect"+str(i), fill="#b9e5ad")
		else:
			canvas_map.itemconfigure("load_savegame_rect"+str(i), fill="#e3e3e3")
		if len(saves_array) <= tmp+i: savetext = ""
		else: savetext = saves_array[tmp+i]
		canvas_map.itemconfigure("load_savegame"+str(i), text=savetext)


#All keypresses pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(switch):
	global saves_pos
	if (switch == "esc"): cancel_load()
	elif (switch == "left" or switch == "right"):
		global cur_button
		if cur_button == 0: cur_button = 1
		else: cur_button = 0
		refresh_buttons()
	elif (switch == "up"):
		saves_pos -= 1
		if saves_pos <= -1: saves_pos = len(saves_array) - 1
#		if (listbox_saves.size() == 0): return
#		try: item_num = map(int, listbox_saves.curselection())
#		except ValueError: pass
#		if (item_num[0] != 0):
# 			listbox_saves.select_clear(0, END)
# 			listbox_saves.selection_set(item_num[0] - 1)
# 		else:
# 			listbox_saves.select_clear(0, END)
# 			listbox_saves.selection_set(END)
		refresh_save_info()
	elif (switch == "down"):
		saves_pos += 1
		if saves_pos >= len(saves_array): saves_pos = 0
# 		if (listbox_saves.size() == 0): return
# 		try: item_num = map(int, listbox_saves.curselection())
# 		except ValueError: pass
# 		if (item_num[0] != listbox_saves.size() - 1):
# 			listbox_saves.select_clear(0, END)
# 			listbox_saves.selection_set(item_num[0] + 1)
# 		else:
# 			listbox_saves.select_clear(0, END)
# 			listbox_saves.selection_set(0)
		refresh_save_info()
	elif (switch == "return"):
		if cur_button == 0: load_selected()
		else: cancel_load()


#called when "Cancel" is pressed
def cancel_load():
	global did_load
	global return_from_loadgame
	did_load = 0
	canvas_map.delete("loadgame")
	return_from_loadgame.set(1)
	#window_loadgame.destroy()



def mouse_handler_move(event=0):
	global cur_button
	#up arrow:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3,
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width(),
		g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height()):
		canvas_map.itemconfigure("loadgame_up",
				image=g.buttons["loadgame_up_sel.png"])
	else:
		canvas_map.itemconfigure("loadgame_up",
				image=g.buttons["loadgame_up.png"])

	#down arrow:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140-g.buttons["loadgame_down.png"].height(),
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_down.png"].width(),
		g.tilesize*g.main.mapsizey/3+140):
		canvas_map.itemconfigure("loadgame_down",
				image=g.buttons["loadgame_down_sel.png"])
	else:
		canvas_map.itemconfigure("loadgame_down",
				image=g.buttons["loadgame_down.png"])

	#load button:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140,
		g.tilesize*g.main.mapsizex/4+g.buttons["load_scr.png"].width(),
		g.tilesize*g.main.mapsizey/3+140+g.buttons["load_scr.png"].height()):
		cur_button = 0

	#leave button:
	if mouse_over(event,
		g.tilesize*g.main.mapsizex/4+g.buttons["load_scr.png"].width(),
		g.tilesize*g.main.mapsizey/3+140,
		g.tilesize*g.main.mapsizex/4+g.buttons["load_scr.png"].width()+
		g.buttons["leave.png"].width(),
		g.tilesize*g.main.mapsizey/3+140+g.buttons["leave.png"].height()):
		cur_button = 1

	refresh_buttons()

def mouse_handler_down(event=0):
	global cur_button
	global saves_pos
	#up arrow:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3,
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width(),
		g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height()):

		tmp = saves_pos - (saves_pos % 5) - 5
		if tmp < 0:
			saves_pos = len(saves_array) - (len(saves_array)%5) + (saves_pos%5)
			if saves_pos >= len(saves_array):
				saves_pos = len(saves_array) - 1
		else:
			saves_pos -= 5
		refresh_save_info()

	#down arrow:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140-g.buttons["loadgame_down.png"].height(),
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_down.png"].width(),
		g.tilesize*g.main.mapsizey/3+140):

		tmp = saves_pos - (saves_pos % 5) + 5
		if tmp >= len(saves_array):
			saves_pos = (saves_pos % 5)
		else:
			saves_pos += 5
			if saves_pos >= len(saves_array):
				saves_pos = len(saves_array) - 1
		refresh_save_info()

	#load button:
	if mouse_over(event, g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140,
		g.tilesize*g.main.mapsizex/4+g.buttons["load_scr.png"].width(),
		g.tilesize*g.main.mapsizey/3+140+g.buttons["load_scr.png"].height()):
		cur_button = 0
		key_handler("return")

	#leave button:
	if mouse_over(event,
		g.tilesize*g.main.mapsizex/4+g.buttons["load_scr.png"].width(),
		g.tilesize*g.main.mapsizey/3+140,
		g.tilesize*g.main.mapsizex/4+g.buttons["load_scr.png"].width()+
		g.buttons["leave.png"].width(),
		g.tilesize*g.main.mapsizey/3+140+g.buttons["leave.png"].height()):
		cur_button = 1
		key_handler("return")

	#save "listbox"
	if mouse_over(event,
		g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height(),
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width(),
		g.tilesize*g.main.mapsizey/3+140-g.buttons["loadgame_down.png"].height()):

		base_y = (event.y -
			g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height())
		base_y -= 40
		if base_y % 20 < 2 or base_y % 20 > 18: return
		tmp = saves_pos - (saves_pos % 5) + (base_y / 20)
		if tmp >= len(saves_array): return
		else: saves_pos = tmp
		refresh_save_info()

def mouse_handler_double(event=0):
	global saves_pos
	#save "listbox"
	if mouse_over(event,
		g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+g.buttons["loadgame_up.png"].height(),
		g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width(),
		g.tilesize*g.main.mapsizey/3+140-g.buttons["loadgame_down.png"].height()):

		load_selected()

def mouse_over(event, x1, y1, x2, y2):
	if event.x >= x1 and event.x <= x2 and event.y >= y1 and event.y <= y2:
		return 1
	return 0


def refresh_buttons():
	#canvas_map.delete("loadgame_buttons")
	if (cur_button == 0):
		canvas_map.itemconfigure("load_load", image=g.buttons["load_scr_sel.png"])
		canvas_map.itemconfigure("load_leave", image=g.buttons["leave.png"])
# 		canvas_map.create_image(0, 0, anchor=NW,
# 			image=g.buttons["load_scr_sel.png"], tags=("load", "loadgame_buttons", "loadgame"))
# 		help_text.set("Load the game")
# 		canvas_map.create_image(g.buttons["load_scr.png"].width(), 0, anchor=NW,
# 			image=g.buttons["leave.png"], tags=("leave", "loadgame_buttons", "loadgame"))
	else:
		canvas_map.itemconfigure("load_load", image=g.buttons["load_scr.png"])
		canvas_map.itemconfigure("load_leave", image=g.buttons["leave_sel.png"])
# 		canvas_map.create_image(0, 0, anchor=NW,
# 			image=g.buttons["load_scr.png"], tags=("load", "loadgame_buttons", "loadgame"))
# 		canvas_map.create_image(g.buttons["load_scr.png"].width(), 0, anchor=NW,
# 			image=g.buttons["leave_sel.png"], tags=("leave", "loadgame_buttons", "loadgame"))
# 		help_text.set("Back to main menu")

def init_window_loadgame(input_canvas):
	#create the window
# 	global window_loadgame
# 	window_loadgame = Frame(g.window_main)
# 	window_loadgame.grid(row=0, column=0)
	global prevent_dbl_load
	prevent_dbl_load = 0
	global canvas_map
	canvas_map = input_canvas
	canvas_map.create_rectangle(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3, g.tilesize*g.main.mapsizex*3/4,
		g.tilesize*g.main.mapsizey/3+140+g.buttons["load_scr.png"].height(),
		fill="#e3e3e3", tags="loadgame")

	global did_load
	did_load = 0

	#add the saves images
	canvas_map.create_image(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3, anchor=NW,
		image=g.buttons["loadgame_up.png"], tags=("loadgame_up", "loadgame"))
	canvas_map.create_image(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140, anchor=SW,
		image=g.buttons["loadgame_down.png"], tags=("loadgame_down", "loadgame"))

	#add the button images
	canvas_map.create_image(g.tilesize*g.main.mapsizex/4,
		g.tilesize*g.main.mapsizey/3+140, anchor=NW,
		image=g.buttons["load_scr.png"],
		tags=("load_load", "loadgame_buttons", "loadgame"))
	canvas_map.create_image(g.tilesize*g.main.mapsizex/4+
		g.buttons["load_scr.png"].width(), g.tilesize*g.main.mapsizey/3+140,
		anchor=NW, image=g.buttons["leave.png"],
		tags=("load_leave", "loadgame_buttons", "loadgame"))

	#list of the actual savegames
	for i in range(5):
		canvas_map.create_rectangle(g.tilesize*g.main.mapsizex/4+2,
			g.tilesize*g.main.mapsizey/3+
			g.buttons["loadgame_down.png"].height()+1+i*20,
			g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_down.png"].width()-1,
			g.tilesize*g.main.mapsizey/3+
			g.buttons["loadgame_down.png"].height()+18+i*20,
			fill="#e3e3e3", tags=("load_savegame_rect"+str(i), "loadgame"))
		canvas_map.create_text(g.tilesize*g.main.mapsizex/4+5,
			g.tilesize*g.main.mapsizey/3+
			g.buttons["loadgame_down.png"].height()+11+i*20,
			text=str(i), anchor=W, tags=("load_savegame"+str(i), "loadgame"))

# 	global listbox_saves
# 	listbox_saves = Listbox(window_loadgame, height=10)
# 	listbox_saves.grid(row=1, column=4, columnspan=2, rowspan=10, sticky=EW)
# 	global scroll_saves
# 	scroll_saves = Scrollbar(window_loadgame, command=listbox_saves.yview)
# 	scroll_saves.grid(row=1, column=5, rowspan=10, sticky="NSE")
# 	listbox_saves.config(yscrollcommand=scroll_saves.set)

# 	g.window_main.update_idletasks()

# 	global canvas_info
# 	canvas_info = Canvas(window_loadgame, width=listbox_saves.winfo_width(),
# 		height=listbox_saves.winfo_height(),
# 		highlightthickness=0)
# 	canvas_info.grid(column=7, row=1, rowspan=8, sticky=N+W)


# 	global label_help
# 	label_help = Label(window_loadgame, textvariable=help_text)
# 	label_help.grid(row=0, column=4, columnspan=2, sticky=EW)

	#add the canvas
# 	global canvas_buttons
# 	canvas_buttons = Canvas(window_loadgame, width=g.buttons["load_scr.png"].width() +
# 		g.buttons["leave.png"].width(), height=g.buttons["leave.png"].height(),
# 		highlightthickness=0)
# 	canvas_buttons.grid(column=4, row=12, columnspan=3, sticky=N+W)

	#add the buttons
#	button_load = Button(window_loadgame, text="Load",
#		command=load_selected).grid(row=12, column=4)
#	button_cancel = Button(window_loadgame, text="Cancel",
#		command=cancel_load).grid(row=12, column=5)
	pixels_per_line = 20

	info_x=g.tilesize*g.main.mapsizex/4+g.buttons["loadgame_up.png"].width()+5
	info_y = g.tilesize*g.main.mapsizey/3+10
	canvas_map.create_text(info_x, info_y+pixels_per_line*0,
			text=g.name_name+": " + name_text, anchor=W,
			tags=("loadgame_name", "loadgame"))
	canvas_map.create_text(info_x, info_y+pixels_per_line*1,
			text=g.hp_name+": " + hp_text, anchor=W,
			tags=("loadgame_hp", "loadgame"))
	canvas_map.create_text(info_x, info_y+pixels_per_line*2,
			text=g.ep_name+": " + ep_text, anchor=W,
			tags=("loadgame_ep", "loadgame"))
	canvas_map.create_text(info_x, info_y+pixels_per_line*3,
			text=g.attack_name+": " + attack_text, anchor=W,
			tags=("loadgame_attack", "loadgame"))
	canvas_map.create_text(info_x, info_y+pixels_per_line*4,
			text=g.defense_name+": " + defense_text, anchor=W,
			tags=("loadgame_defense", "loadgame"))
	canvas_map.create_text(info_x, info_y+pixels_per_line*5,
			text=g.gold_name+": " + gold_text, anchor=W,
			tags=("loadgame_gold", "loadgame"))
	canvas_map.create_text(info_x, info_y+pixels_per_line*6,
			text=g.exp_name+": " + exp_text, anchor=W,
			tags=("loadgame_exp", "loadgame"))
	canvas_map.create_text(info_x, info_y+pixels_per_line*7,
			text=g.level_name+": " + level_text, anchor=W,
			tags=("loadgame_level", "loadgame"))

	#If there is no save directory, make one.
	if path.isdir(g.mod_directory + "/saves") == 0:
		if path.exists(g.mod_directory + "/saves") == 1:
			remove(g.mod_directory + "/saves")
		mkdir(g.mod_directory + "/saves")
	#show the files contained in the saves directory.
	global saves_array
	saves_array = []
	tmp_saves_array = listdir(g.mod_directory + "/saves")
	for save_name in tmp_saves_array:
		if save_name [:1] != "." and save_name  != "CVS":
			saves_array.append(save_name)
	global saves_pos
	saves_pos = 0
# 	for i in array_save:
# 		if i[:1] != "." and i != "CVS":
# 			listbox_saves.insert(END, i)

# 	listbox_saves.select_set(0)

	g.window_main.bind("<Double-Button-1>", mouse_handler_double)
	g.window_main.bind("<ButtonRelease-1>", mouse_handler_down)
	g.window_main.bind("<Motion>", mouse_handler_move)

	g.window_main.bind("<Escape>", lambda e:key_handler("esc"))
	g.window_main.bind("<Left>", lambda e:key_handler("left"))
	g.window_main.bind("<Right>", lambda e:key_handler("right"))
	g.window_main.bind("<Up>", lambda e:key_handler("up"))
	g.window_main.bind("<Down>", lambda e:key_handler("down"))
	g.window_main.bind("<Return>", lambda e:key_handler("return"))
# 	listbox_saves.bind("<Double-Button-1>", key_handler_return)
# 	listbox_saves.bind("<ButtonRelease-1>", refresh_save_info)
	refresh_buttons()
	refresh_save_info()

	global return_from_loadgame
	return_from_loadgame.set(0)
	g.window_main.wait_variable(return_from_loadgame)
	return did_load
