/*
 * forkit - a piped console feedback forker
 * Copyright (C) 2007  Jeffrey Grembecki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __FORKIT_H
#define __FORKIT_H

#ifdef __cplusplus
extern "C" {
#endif

typedef int(*forkit_cb)(const char*,void*);
typedef void(*forkitprint_cb)(const char*);

int forkitf(forkit_cb callback, forkitprint_cb output, void *p_options, const char *p_path,
	const char *p_format, ...);

int pipeit(int fd, forkit_cb callback, forkitprint_cb print, void *p_options, const char *p_path,
	const char *p_format, ...);

int pipefile(const char *p_filename, forkit_cb callback, forkitprint_cb print, void *p_options,
	const char *p_path, const char *p_format, ...);

int omfgwriteapipelib(const char *p_source, const char *p_dest, forkit_cb callback,
	forkitprint_cb print, void *p_options, const char *p_path, const char *p_format, ...);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __FORKIT_H */
