/*
 vars.c : variables functions.

 (c) 2007-2009 Fernando Iazeolla

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<string.h>
#include<errno.h>
#include"stdint.h"
#include"main.h"
#include"macho.h"
#include"elf.h"
#include"vars.h"
#include"utils.h"


void add_var(char *name,int type,void *val)
{
	struct _gv *newvar;
	int *x;
	x=val;
	newvar=(struct _gv*)malloc(sizeof(struct _gv));
	if(newvar==NULL) die("error allocating space for a new variable");
	newvar->prev=NULL;
	newvar->next=NULL;
	newvar->v.type=type;
	newvar->v.name=strdup(name);
	if(newvar->v.name==NULL) die("error allocating space for a new variable name");
	if(newvar->v.type==TYPE_VAL)
	{
		newvar->v.val=*x;
	}
	if(newvar->v.type==TYPE_STRING)
	{
		newvar->v.s=strdup((char*)val);
		if(newvar->v.s==NULL) {die("error allocating space for var val");}
	}
	if(gv_first==NULL)
	{
		gv_first=newvar;
	}
	else
	{
		newvar->prev=gv_last;
		gv_last->next=newvar;
	}
	gv_last=newvar;
	//add_completion(name,NULL,comp_var);
}
void remove_item(struct _gv *from,struct _gv *p)
{
	if(p->prev)
	{
		p->prev->next=p->next;
	}
	else
	{

	}
	if(p->next)
	{
		p->next->prev=p->prev;
	}
	if(p->prev==NULL)
	{
		if(from==NULL)
		{
			gv_first=p->next;
		}
		else
		{
			from->v.p.first=p->next;
		}
	}
	if(p->next==NULL)
	{
		if(from==NULL)
		{
			gv_last=p->prev;
		}
		else
		{
			from->v.p.last=p->prev;
		}
	}
	if(p)
	{
		if(p->v.name) free(p->v.name);
		if(p->v.type==TYPE_STRING)
		{
			if(p->v.s) free(p->v.s);
		}
		free(p);
	}
}
void set_normal_var(char *name,int type,void *val)
{
	int *x;
	x=val;
	for(gv_ptr=gv_first;gv_ptr;gv_ptr=gv_ptr->next)
	{
		if((strcmp(name,gv_ptr->v.name))==0)
		{
			
			if(type==TYPE_VAL)
			{
				gv_ptr->v.val=*x;
			}
			if(type==TYPE_STRING)
			{
				if(gv_ptr->v.type==TYPE_STRING) if(gv_ptr->v.s) free (gv_ptr->v.s);
				gv_ptr->v.s=strdup((char*)val);
				if(gv_ptr->v.s==NULL){die("error allocating space for setting var str");}
			}
			gv_ptr->v.type=type;
			return;
		}
	}
	add_var(name,type,val);
}
struct _var* get_normal_var(char *name)
{
	for(gv_ptr=gv_first;gv_ptr;gv_ptr=gv_ptr->next)
	{
		if((strcmp(name,gv_ptr->v.name))==0)
		{
			return &gv_ptr->v;
		}
	}
	return NULL;
}
char* get_token(struct token *tok,char *s)
{
	char temp[255];
	char *c,*tp;
	c=&(tok->name[0]);
	tok->num=-1;
	tp=&temp[0];
	while(isalnum(*s))
	{
		*c=*s;
		c++;s++;
	}
	*c='\0';
	c++;
	*c='\0';
	if(*s=='[')
	{
		s++;
		while(isdigit(*s))
		{
			*tp=*s;
			tp++;s++;
		}
		*tp='\0';
		s++;
		tok->num=atoi(temp);
	}
	if(*s=='-') s+=2;
	return s;
}
struct _p* get_struct_pointer(struct _p *fromtable,char *name,int num)
{
	struct _p *p;
	struct _gv *ptr,*in_ptr,*initialpointer;
	int count;
	//p=(struct _p*)malloc(sizeof(struct _p));
	//if(p==NULL) die("error allocating _p struct");
	if(fromtable==NULL) initialpointer=gv_first; else initialpointer=fromtable->first;
	if(name==NULL)
	{
		//p->first=gv_first;
		//p->last=gv_last;
		return NULL;
	}
	else
	{
		for(ptr=initialpointer;ptr;ptr=ptr->next)
		{
			if(ptr->v.type>=TYPE_STRUCT)
			{
				if((strcmp(name,ptr->v.name))==0)
				{
					if(ptr->v.type==TYPE_NODE_STRUCT)
					{
						count=0;
						for(in_ptr=ptr->v.p.first;in_ptr;in_ptr=in_ptr->next)
						{
							if(count==num)
							{
								//p->first=in_ptr->v.p.first;
								//p->last=in_ptr->v.p.last;
								//*(pp->f)=in_ptr->v.p.first;
								//*(pp->l)=in_ptr->v.p.last;
								p=(struct _p*)&(in_ptr->v.p);
								return p;
							}
							count++;
						}
						if(p) free(p);p=NULL;
					}
					else
					{
						//p->first=ptr->v.p.first;
						//p->last=ptr->v.p.last;
						//*(pp->f)=ptr->v.p.first;
						//*(pp->l)=ptr->v.p.last;
						p=(struct _p*)&(ptr->v.p);
						return p;
					}
				}
			}
		}
	}
	return NULL;
}
struct _p* quickparse(char *str)
{
	struct token tok;
	struct _p *p;
	if(str==NULL) return NULL;
	str=get_token(&tok,str);
	p=NULL;
	p=get_struct_pointer(p,tok.name,tok.num);
	while((strlen(str))!=0)
	{
		str=get_token(&tok,str);
		p=get_struct_pointer(p,tok.name,tok.num);
	}
	return p;
}
void add_s_var(char *path,char *name,int type,void *val)
{
	struct _gv *newvar;
	struct _p *pst;
	int *x;
	x=val;
	newvar=(struct _gv*)malloc(sizeof(struct _gv));
	if(newvar==NULL) die("error allocating space for inVar");
	newvar->v.name=strdup(name);
	if(newvar->v.name==NULL) die("error allocating space for inVar name");
	newvar->prev=NULL;
	newvar->next=NULL;
	newvar->v.type=type;
	switch(type)
	{
		case TYPE_VAL:
			newvar->v.val=*x;
			break;
		case TYPE_STRING:
			newvar->v.s=strdup((char*)val);
			if(newvar->v.s==NULL) {die("error allocating space for var val");}
			break;
		default:
			break;
	}
	pst=quickparse(path);
	if(pst)
	{
		if(pst->first==NULL)
		{
			pst->first=newvar;
		}
		else
		{
			newvar->prev=pst->last;
			pst->last->next=newvar;
		}
		pst->last=newvar;
		add_completion(path,name,comp_discardable);
	}
}
void set_s_var(struct _var *var,int type,void *val)
{
	int *x;
	x=val;
	if(var)
	{
		if(var->type!=type) {printf("*** type not matching! ignoring.\n");return;}
		switch(type){
			case TYPE_STRING:
				free(var->s);
				var->s=strdup((char*)val);
				if(var->s==NULL) {die("error allocating space for var val");}
				break;
			case TYPE_VAL:
				var->val=*x;
				break;
			case TYPE_STRUCT:
				break;
			default:
				break;
			}
	}
}
struct _var* get_s_var(char *name)
{
	struct _gv *ptr;
	struct _p tp;
	struct _p *p;
	p=get_bookmark();
	if(!p)
	{
		tp.first=gv_first;
		tp.last=gv_last;
	}
	else
	{
		tp.first=p->first;
		tp.last=p->last;
	}
	for(ptr=tp.first;ptr;ptr=ptr->next)
	{
		if(strcmp(ptr->v.name,name)==0)
		{
			return &ptr->v;
		}
	}
	return NULL;
}
struct _var* get_s_num_var(char *name,int num)
{
	struct _var *var;
	struct _gv *ptr;
	int n=0;
	var=get_s_var(name);
	if(var)
	{
		ptr=var->p.first;
		while(n++<num)
		{
			if(ptr->next) ptr=ptr->next; else return NULL;
		}
		return &ptr->v;
	}
	return NULL;
}
void set_var(char *name,int type,void *val)
{
	if(name[0]=='$') set_normal_var(name,type,val);
}
struct _var* get_var(char *name)
{
	if(name[0]=='$') return (get_normal_var(name));
}
void del_table(struct _gv *p)
{
	struct _gv *ptr;
	for(ptr=p->v.p.first;ptr;ptr=ptr->next)
	{
		if(ptr->v.type>=TYPE_STRUCT)
		{
			del_table(ptr);
		}
			remove_item(p,ptr);
	}
}
void delete_tables()
{
	struct _gv *ptr;
	for(ptr=gv_first;ptr;ptr=ptr->next)
	{
		if(ptr->v.type>=TYPE_STRUCT)
		{
			del_table(ptr);
			remove_item(NULL,ptr);
		}
	}
}
void add_table(struct _p *p,struct _gv *st)
{
	struct _gv **f,**l;
	if(p==NULL)
	{
		f=&gv_first;
		l=&gv_last;
	}
	else
	{
		f=&p->first;
		l=&p->last;
	}
	if(*f==NULL)
	{
		*f=st;
	}
	else
	{
		st->prev=*l;
		(*l)->next=st;
	}
	*l=st;
}
void make_table(char *path,char *nome,int num)
{
	struct _gv *p,*x;
	struct _p *pointerpath;
	int n;
	char tempstr[255];
	p=(struct _gv*)malloc(sizeof(struct _gv));
	if(p==NULL) die("error allocating table memory");
	p->v.name=strdup(nome);
	if(p->v.name==NULL) die("error allocating table memory");
	p->prev=NULL;
	p->next=NULL;
	p->v.p.first=NULL;
	p->v.p.last=NULL;
	if(num<0) p->v.type=TYPE_STRUCT;
	else p->v.type=TYPE_NODE_STRUCT;
	pointerpath=quickparse(path);
	add_table(pointerpath,p);
	add_completion(path,nome,comp_discardable);
	if(num>=0)
	{
		for(n=0;n<num;n++)
		{
			x=(struct _gv*)malloc(sizeof(struct _gv));
			if(x==NULL) die("error allocating child table memory");
			x->v.name=strdup(nome);
			if(x->v.name==NULL) die("error allocating child table memory");
			x->v.type=TYPE_STRUCT;
			x->prev=NULL;
			x->next=NULL;
			x->v.p.first=NULL;
			x->v.p.last=NULL;
			add_table((struct _p*)&(p->v.p),x);
			x=NULL;
			sprintf(tempstr,"%s[%d]",nome,n);
			add_completion(path,tempstr,comp_discardable);
		}
	}
}
void print_s(struct _var *p)
{
	struct _gv *var,*ptr=NULL;
	int count=0,x,segval;
	char str[MAX_STR],*s1,*s2;
	for(var=p->p.first;var;var=var->next)
	{
		segval=0;
		if(var->v.type==TYPE_VAL)
		{
			if((strcmp("sh_name",var->v.name))==0)
			{
				printf("%s : 0x%x (%d) [%s]\n",var->v.name,var->v.val,var->v.val,print_sh_shstrtab(var->v.val));
			}
			else
			{
				printf("%s : 0x%x (%d)\n",var->v.name,var->v.val,var->v.val);
			}
		}
		if(var->v.type==TYPE_STRING)
		{
			printf("%s : %s\n",var->v.name,var->v.s);
		}
		if(var->v.type>=TYPE_STRUCT)
		{
			if(p->type==TYPE_NODE_STRUCT)
			{
			 	printf("*%s[%d] : ",var->v.name,count++); 
			 	if((strcmp("sh",var->v.name))==0)
			 	{
			 		x=var->v.p.first->v.val;
			 		printf(" [%s]",print_sh_shstrtab(x));
			 	}
			 	if((strcmp("lc",var->v.name))==0)
			 	{
			 		sprintf(str,"lc[%d]",count-1);
			 		if(file_type==FT_MACHO) {ptr=get_s_var_byname(str,"cmd");segval=ptr->v.val;}
			 		if(file_type==FT_FAT_MACHO) segval=var->v.p.first->v.val;
			 		if(segval)
			 		{
			 			switch(segval){
			 			case 1:
			 				if(file_type==FT_MACHO) {ptr=get_s_var_byname(str,"segname");s1=ptr->v.s;}
			 				else
			 				{s1=var->v.p.first->next->next->v.s;}
			 				printf(" LC_SEGMENT [%s]",s1);
			 				break;
			 			case 2:
			 				printf(" LC_SYMTAB");
			 				break;
			 			case 3:
			 				printf(" LC_SYMSEG");
			 				break;
			 			case 4:
			 				printf(" LC_THREAD");
			 				break;
			 			case 5:
			 				printf(" LC_UNIXTHREAD");
			 				break;
			 			case 6:
			 				printf(" LC_LOADFVMLIB");
			 				break;
			 			case 7:
			 				printf(" LC_IDFVMLIB");
			 				break;
			 			case 8:
			 				printf(" LC_IDENT");
			 				break;
			 			case 9:
			 				printf(" LC_FVMFILE");
			 				break;
			 			case 10:
			 				printf(" LC_PREPAGE");
			 				break;
			 			case 11:
			 				printf(" LC_DYSYMTAB");
			 				break;
			 			case 12:
			 				printf(" LC_LOAD_DYLIB");
			 				break;
			 			case 13:
			 				printf(" LC_ID_DYLIB");
			 				break;
			 			case 14:
			 				printf(" LC_LOAD_DYLINKER");
			 				break;
			 			case 15:
			 				printf(" LC_ID_DYLINKER");
			 				break;
			 			case 16:
			 				printf(" LC_PREBOUND_DYLIB");
			 				break;
			 			default:
			 				printf(" structure");
			 				break;
			 			}
			 		}
			 		else printf(" structure");
			 	}
			 	if((strcmp("sect",var->v.name))==0)
			 	{
			 		s1=var->v.p.first->v.s;
			 		s2=var->v.p.first->next->v.s;
			 		if((s1)&&(s2))
			 		printf(" [%s] [(%s)]",s1,s2);
			 		else printf(" structure");
			 	}
			 	if((strcmp("s",var->v.name))==0)
			 	{
			 		sprintf(str,"s[%d]",count-1);
			 		ptr=get_s_var_byname(str,"Name");
			 		if(ptr) printf(" [%s]",ptr->v.s);
			 		else printf(" structure");
			 	}
			 	if((strcmp("ph",var->v.name))==0)
			 	{
			 		sprintf(str,"ph[%d]",count-1);
			 		ptr=get_s_var_byname(str,"p_type");
			 		if(ptr)
			 		{
			 			switch(ptr->v.val){
			 			case 0:
			 				printf(" PT_NULL");
			 				break;
			 			case 1:
			 				printf(" PT_LOAD");
			 				break;
			 			case 2:
			 				printf(" PT_DYNAMIC");
			 				break;
			 			case 3:
			 				printf(" PT_INTERP");
			 				break;
			 			case 4:
			 				printf(" PT_NOTE");
			 				break;
			 			case 5:
			 				printf(" PT_SHLIB");
			 				break;
			 			case 6:
			 				printf(" PT_PHDR");
			 				break;
			 			case 7:
			 				printf(" PT_TLS");
			 				break;
			 			case 8:
			 				printf(" PT_NUM");
			 				break;
			 			default:
			 				printf(" structure");
			 				break;
			 			}
			 		}
			 		else printf(" structure");
			 	}
			 	printf(".\n");
			}
			else
			{
				printf("*%s : structure.\n",var->v.name);
			}
		}
	}
}
void free_bookmark()
{
	bookmark=NULL;
}
void set_bookmark(struct _p *p)
{
	bookmark=p;
}
struct _p* get_bookmark()
{
	return bookmark;
}
struct _var* get_s_var_byname(char *path,char *varname)
{
	struct _p *p;
	p=quickparse(path);
	return get_s_var_bypointer(p,varname);
}
struct _var* get_s_var_bypointer(struct _p *p,char *varname)
{
	struct _gv *ptr;
	for(ptr=p->first;ptr;ptr=ptr->next)
	{
		if(strcmp(ptr->v.name,varname)==0)
		{
			return &ptr->v;
		}
	}
	return NULL;
}
