# !Makedonski,Macedonian! -*-coding: iso-8859-5;-*-
#
#   This file is automaticaly generated. 
#   It is a part of the Debian language-env package.
#   Language Support File for Macedonian
#
# Copyright (C) 1998-2000 Tomohiro KUBOTA
# Copyright (C) 2000,2001,2004,2005 Anton Zinoviev
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# On Debian GNU/Linux systems, the complete text of the GNU General
# Public License can be found in `/usr/share/common-licenses/GPL'.


# ---------------------------------------------------
# isNC()
# ---------------------------------------------------
sub isNC($$$) {
    my ($TTY, $TERM, $DISPLAY, $HOME, $THIS, $OPT, $OPT_N, $FONT);
    $TTY = `/usr/bin/tty`;
    $TERM = $ENV{TERM};
    $DISPLAY = $ENV{DISPLAY};
    $HOME = $ENV{HOME};
    $THIS = $_[0];
    $OPT = $_[1];
    $OPT_N = $_[2];
    
    if ($ENV{HAVE_CYR} ne '') {
	return 1;
    }
    if ($DISPLAY ne '' && !$OPT_N && ($FONT = &havecyrfont)) {
	my ($TITLE, $BGC, $FGC);
	$TITLE = &terminal_name();
	$BGC = "lightgrey";
	$FGC = "grey30";
	if (&executable("wterm")) {
	    exec("HAVE_CYR=1; export HAVE_CYR; ".
		 "wterm -fn '$FONT' -bg ${BGC} -fg ${FGC} -title '${TITLE}' ".
		 "-e $THIS -N -C $OPT");
	}
	if (&executable("rxvt")) {
	    exec("HAVE_CYR=1; export HAVE_CYR; ".
		 "rxvt -fn '$FONT' -bg ${BGC} -fg ${FGC} -title '${TITLE}' ".
		 "-e $THIS -N -C $OPT");
	}
	if (&executable("xvt")) {
	    exec("HAVE_CYR=1; export HAVE_CYR; ".
		 "xvt -fn '$FONT' -bg ${BGC} -fg ${FGC} -title '${TITLE}' ".
		 "-e $THIS -N -C $OPT");
	}
	if (&executable("xterm")) {
	    exec("HAVE_CYR=1; export HAVE_CYR; ".
		 "xterm -fn '$FONT' -bg ${BGC} -fg ${FGC} -title '${TITLE}' ".
		 "-e $THIS -N -C $OPT");
	}
	if (&executable("Eterm")) {
	    exec("HAVE_CYR=1; export HAVE_CYR; ".
		 "Eterm --title '${TITLE}' -F '$FONT' -e $THIS -N -C $OPT");
	}
    }
    elsif (($TTY =~ m!/dev/tty[0-9]+! || $TTY =~ m!/dev/vc/[0-9]+!) 
	   && !$OPT_N) {
	if (&executable("consolechars")) {
            print STDERR "\x{1b}(K";
	    system("unicode_stop");
	    system("consolechars -f iso05.f16 -m iso05.acm");
	}
	elsif (&executable("setfont")) {
            print STDERR "\x{1b}(K";
	    system("unicode_stop");
	    system("setfont -f iso05.16 -m trivial 1>/dev/null 2>/dev/null");
	    system("setfont -f iso05.f16 -m trivial 1>/dev/null 2>/dev/null");
	}
	else {
	    return 0;
	}
	exec("HAVE_CYR=1; export HAVE_CYR; ".
	       "$THIS -N -C $OPT");
	# We should never be here:
  	if ( &executable("cyr") && -f "${HOME}/.cyr_defaults") {
  	    exec('cyr');
  	} else {
	    exit;
	}
    }
    return 0;
}

sub havecyrfont() {
    my $i;
    open XSET, "xlsfonts|";
    while (defined($i=<XSET>)){
	if($i =~ /-iso8859-5$/ 
	   && $i =~ /^-[^-]*-fixed-medium-r-[^-]*-[^-]*-14-/) {
	    chomp($i);
	    close XSET;
	    return $i;
	}
    }
    close XSET;
    return 0;
}

sub executable($) {
    my($WHICH);
    $WHICH = '/usr/bin/which';
    if (system("$WHICH $_[0] 1>/dev/null 2>/dev/null")==0) {
	return 1;
    }
    return 0;
}

# ---------------------------------------------------
# initialize()
# ---------------------------------------------------
sub initialize() {

    my ($ss, $CYR_ENC, $XKBD, $CYR_KBD, $ENC, $CYR_OPTION, $HOME);

    $HOME = $ENV{HOME};

    $MAINDIR=$0;
    $MAINDIR =~ s+/[^/]*$++g;
    $MAINDIR .= "/..";
    if (substr($MAINDIR, 0, 1) ne '/') {
        $pwd = `pwd`;
	chomp $pwd;
        $MAINDIR = $pwd . "/" . $MAINDIR;
    }
    $Sub::MAINDIR = $MAINDIR;

    $CYR_ENC = &choose_encoding();
 
    if ($CYR_ENC eq "UTF-8") {
	$ENC = "iso-10646-1";
	$CYR_ENC_GLIBC = "UTF-8";
	$FONTSET = "iso10646-1";
    }
    if ($CYR_ENC eq "CP1251") {
	$ENC = "cp1251";
	$CYR_ENC_GLIBC = $CYR_ENC;
	$FONTSET = "microsoft-cp1251";
    }
    if ($CYR_ENC eq "ISO8859-5") {
	$ENC = "iso-8859-5";
	$CYR_ENC_GLIBC = "ISO-8859-5";
	$FONTSET = "iso8859-5";
    }
    if ($CYR_ENC eq "KOI8-R") {
	$ENC = "koi8-r";
	$CYR_ENC_GLIBC = $CYR_ENC;
	$FONTSET = "koi8-r";
    }
    if ($CYR_ENC eq "KOI8-U") {
	$ENC = "koi8-u";
	$CYR_ENC_GLIBC = $CYR_ENC;
	$FONTSET = "koi8-u";
    }
    if ($CYR_ENC eq "ISO8859-2") {
	$ENC = "iso-8859-2";
	$CYR_ENC_GLIBC = "ISO-8859-2";
	$FONTSET = "iso8859-2";
    }

    $Sub::CYR_ENC = $CYR_ENC;

    $Sub::DOS_ENC = &dos_enc($CYR_ENC);

    $Sub::LOCALE = &locale($CYR_ENC);

    $Sub::LANGUAGE_PO = &language_po($CYR_ENC);

    $Sub::MUTT_ENCODING = &mutt_encoding();

    $Sub::MAIL_ENCODING = &mail_encoding($CYR_ENC);

    $Sub::FONTSET = $FONTSET;

    &now_we_will_configure_kbd($CYR_ENC);

    ($XKBD, $CYR_KBD) = &choose_keyboard($CYR_ENC);
    $Sub::CYR_KBD = $CYR_KBD;
    $Sub::XKBD = $XKBD;

    $ss = &grp_toggle($CYR_ENC);
    if ($ss == 1) {
	$CYR_OPTION = "toggle";
    }
    if ($ss == 2) {
	$CYR_OPTION = "shift_toggle";
    }
    if ($ss == 3) {
	$CYR_OPTION = "ctrl_shift_toggle";
    }
    if ($ss == 4) {
	$CYR_OPTION = "ctrl_alt_toggle";
    }
    if ($ss == 5) {
	$CYR_OPTION = "alt_shift_toggle";
    }
    if ($ss == 6) {
	$CYR_OPTION = "caps_toggle";
    }
    if ($ss == 7) {
	$CYR_OPTION = "menu_toggle";
    }
    if ($ss == 8) {
	$CYR_OPTION = "lwin_toggle";
    }
    if ($ss == 9) {
	$CYR_OPTION = "rwin_toggle";
    }
    if ($ss == 10) {
	$CYR_OPTION = "";
    }
    if ($CYR_OPTION ne "") {
	$XKBD = "${XKBD}+group($CYR_OPTION)";
    }

    $ss = &grp_switch($CYR_ENC);
    if ($CYR_OPTION eq "toggle") {
	$ss = 6;
    }
    if ($ss == 1) {
	$CYR_OPTION = "${CYR_OPTION} switch";
	$XKBD = $XKBD . '+group(switch)';
    }
#    if ($ss == 2) {
#	$CYR_OPTION = "${CYR_OPTION} menu";
#	$XKBD = $XKBD . '+group(menu_switch)';
#    }
    if ($ss == 2) {
	$CYR_OPTION = "${CYR_OPTION} win_switch";
	$XKBD = $XKBD . '+group(win_switch)';
    }
    if ($ss == 3) {
	$CYR_OPTION = "${CYR_OPTION} lwin_switch";
	$XKBD = $XKBD . '+group(lwin_switch)';
    }
    if ($ss == 4) {
	$CYR_OPTION = "${CYR_OPTION} rwin_switch";
	$XKBD = $XKBD . '+group(rwin_switch)';
    }

      $ss=&lv3_switch($CYR_ENC);
      if ($ss == 1) {
  	$XKBD = "${XKBD}+level3(switch)";
      }
      if ($ss == 2) {
  	$XKBD = "${XKBD}+level3(menu_switch)";
      }
      if ($ss == 3) {
  	$XKBD = "${XKBD}+level3(win_switch)";
      }
      if ($ss == 4) {
  	$XKBD = "${XKBD}+level3(lwin_switch)";
      }
      if ($ss == 5) {
  	$XKBD = "${XKBD}+level3(rwin_switch)";
      }

    $Sub::CYR_OPTION = $CYR_OPTION;
    $Sub::XKBD = $XKBD;


    # ---------- record the preferences in ~/.xcyrillic ----------
    open XCYRILLIC, ">$ENV{HOME}/.xcyrillic";
    print XCYRILLIC "#!/bin/bash\n";
    print XCYRILLIC "\n";
    print XCYRILLIC "# A script to setup your language in X Window\n";
    print XCYRILLIC "\n";
#    print XCYRILLIC "PATH=${MAINDIR}/bin:" . '${PATH}' . "\n";
#    print XCYRILLIC "export PATH\n";
    print XCYRILLIC "# Setup the locale\n";
    print XCYRILLIC "unset LC_ALL\n";
    print XCYRILLIC "LANG=" . &locale($CYR_ENC) . "\n";
    print XCYRILLIC "LANGUAGE=" . &language_po($CYR_ENC) . "\n";
    print XCYRILLIC "export LANG LANGUAGE\n";
    print XCYRILLIC "\n";
    print XCYRILLIC "# Setup the keyboard\n";
    print XCYRILLIC "setxkbmap -types complete -compat 'complete+leds(scroll)' -geometry 'pc(pc102)' -symbols '${XKBD}'\n";
    print XCYRILLIC <<'EOF';

# NLS for old motif applications
if test -d /usr/X11R6/lib/X11/nls; then
    XNLSPATH=/usr/X11R6/lib/X11/nls
    export XNLSPATH
fi

# Add custom user fonts path
if [ -f ${HOME}/.fonts/fonts.dir ]; then
    xset fp+ ${HOME}/.fonts
fi

# Add system-wide fonts path for cyrfonts (this is not for Debian)
if [ -f /opt/cyrfonts/fonts.dir ]; then
    xset fp+ /opt/cyrfonts
fi

# Read the user resources database
if test -f ~/.Xresources; then
    xrdb -merge ~/.Xresources
fi

EOF
    close XCYRILLIC;
    chmod 0755,  "$ENV{HOME}/.xcyrillic";

    # ---------- record the preferences in ~/.fonts.conf ----------
my $fontdirs="<dir>${HOME}/.fonts</dir>
<dir>/opt/cyrfonts</dir>";
    open FONTSCONF, ">>$ENV{HOME}/.fonts.conf";
    close FONTSCONF;
    
    open FONTSCONF, "<$ENV{HOME}/.fonts.conf";
    open NEWFONTSCONF, ">$ENV{HOME}/.fonts.conf.set-bulgarian-env";
    print NEWFONTSCONF "<fontconfig>\n";
    print NEWFONTSCONF $fontdirs ."\n";
  LINE:
    while (<FONTSCONF>) {
	$_ =~ s!<fontconfig>!!g;
	$_ =~ s!</fontconfig>!!g;
	foreach my $adir (split /^/, $fontdirs) {
	    next LINE if ((index $_, $adir)>=0);
	}
	print NEWFONTSCONF $_;
    }
    print NEWFONTSCONF "</fontconfig>\n";
    close FONTSCONF;
    close NEWFONTSCONF;
    rename "$ENV{HOME}/.fonts.conf.set-bulgarian-env", "$ENV{HOME}/.fonts.conf";
#      # ---------- record the preferences in ~/.Eterm/user.cfg ----------
#      if ( ! (-f "$ENV{HOME}/.Eterm/user.cfg" ||
#  	    -f "$ENV{HOME}/.Eterm/themes/Eterm/user.cfg")) {
#  	if (! -e "$ENV{HOME}/.Eterm") {
#  	    mkdir "$ENV{HOME}/.Eterm", 0700;
#  	}
#  	open USERCFG, ">$ENV{HOME}/.Eterm/user.cfg";
#  	print USERCFG "<Eterm-0.9>\n";
#  	print USERCFG "begin main\n";
#  	print USERCFG "    begin attributes\n";
#  	print USERCFG "        font 0 ${SHORTFONTSET}-5x7\n";
#  	print USERCFG "        font 1 ${SHORTFONTSET}-6x10\n";
#  	print USERCFG "        font 2 ${SHORTFONTSET}-fixed\n";
#  	print USERCFG "        font 3 ${SHORTFONTSET}-8x13\n";
#  	print USERCFG "        font 4 ${SHORTFONTSET}-9x15\n";
#  	print USERCFG "        font 5 ${SHORTFONTSET}-10x20\n";
#  	print USERCFG "        font 6 ${SHORTFONTSET}-12x24\n";
#  	print USERCFG "#        font bold ${SHORTFONTSET}-7x14\n";
#  	print USERCFG "    end attributes\n";
#  	print USERCFG "end main\n";
#  	close USERCFG;
#      }


    # ---------- add required packages ----------
    if ($CYR_ENC eq "UTF-8") {
	&Sub::addlist("console-cyrillic");
	&Sub::addlist("fonty");
    }
    if ($CYR_ENC eq "CP1251") {
	&Sub::addlist("console-cyrillic");
    }
    if ($CYR_ENC eq "ISO8859-5") {
	&Sub::addlist("console-cyrillic");
    }
    if ($CYR_ENC eq "KOI8-R") {
	&Sub::addlist("console-cyrillic");
    }
    if ($CYR_ENC eq "KOI8-U") {
	&Sub::addlist("console-cyrillic");
    }
    if ($CYR_ENC eq "ISO8859-2") {
	&Sub::addlist("fonty");
    }
    if(&Sub::isinstalled("kdm") || &Sub::isinstalled("wdm")) {
	&Sub::addlist("gdm");
    }
    if (&Sub::isinstalled("xserver-.*")
	|| &Sub::isinstalled("xbase-clients")) {
	if ($CYR_ENC eq "UTF-8") {
	    &Sub::addlist("xfonts-base");
	    &Sub::addlist("xfonts-75dpi");
	    &Sub::addlist("xfonts-100dpi");
	    &Sub::addlist("xfonts-cronyx-100dpi");
	    &Sub::addlist("xfonts-bolkhov-misc");
	    &Sub::addlist("xfonts-bolkhov-75dpi");
	    &Sub::addlist("t1-cyrillic");
	    &Sub::addlist("t1-teams");
	}
	if ($CYR_ENC eq "CP1251") {
	    &Sub::addlist("xfonts-cronyx-cp1251-100dpi");
	    &Sub::addlist("xfonts-bolkhov-cp1251-misc");
	    &Sub::addlist("xfonts-bolkhov-cp1251-75dpi");
	    &Sub::addlist("t1-cyrillic");
	    &Sub::addlist("t1-teams");
	    &Sub::addlist("ttf-arhangai");
	    &Sub::addlist("ttf-thryomanes");
	    &Sub::addlist("ttf-freefont");
	}
  	if ($CYR_ENC eq "ISO8859-5") {
	    &Sub::addlist("xfonts-cronyx-isocyr-misc");
	    &Sub::addlist("xfonts-cronyx-isocyr-100dpi");
	    &Sub::addlist("xfonts-cronyx-isocyr-75dpi");
	    &Sub::addlist("xfonts-bolkhov-isocyr-misc");
	    &Sub::addlist("xfonts-bolkhov-isocyr-75dpi");
	    &Sub::addlist("t1-cyrillic");
	    &Sub::addlist("ttf-arhangai");
	    &Sub::addlist("ttf-thryomanes");
	    &Sub::addlist("ttf-freefont");
  	}
	if ($CYR_ENC eq "KOI8-R") {
	    &Sub::addlist("xfonts-cronyx-koi8r-100dpi");
	    &Sub::addlist("xfonts-bolkhov-koi8r-misc");
	    &Sub::addlist("xfonts-bolkhov-koi8r-75dpi");
	    &Sub::addlist("t1-cyrillic");
	    &Sub::addlist("t1-teams");
	    &Sub::addlist("ttf-arhangai");
	    &Sub::addlist("ttf-thryomanes");
	    &Sub::addlist("ttf-freefont");
	}
	if ($CYR_ENC eq "KOI8-U") {
	    &Sub::addlist("xfonts-cronyx-koi8u-100dpi");
	    &Sub::addlist("xfonts-bolkhov-koi8u-misc");
	    &Sub::addlist("xfonts-bolkhov-koi8u-75dpi");
	    &Sub::addlist("t1-cyrillic");
	    &Sub::addlist("ttf-arhangai");
	    &Sub::addlist("ttf-thryomanes");
	    &Sub::addlist("ttf-freefont");
	}
	if ($CYR_ENC eq "ISO8859-2") {
	    &Sub::addlist("xfonts-biznet-iso-8859-2-base");
	    &Sub::addlist("xfonts-biznet-iso-8859-2-75dpi");
	    &Sub::addlist("xfonts-biznet-iso-8859-2-100dpi");
	    &Sub::addlist("xfonts-jmk");
	    &Sub::addlist("ttf-thryomanes");
	    &Sub::addlist("ttf-freefont");
	}
    }
    return 0;
}

# ---------------------------------------------------
# sourceset2displayset()
# ---------------------------------------------------
sub sourceset2displayset ($)
{
	return $_[0];
}

# ---------------------------------------------------
# analcode()
# ---------------------------------------------------
sub analcode($)
{
	return 0;
}

# ---------------------------------------------------
# convcode()
# ---------------------------------------------------
sub convcode($$)
{
    return $_[0];
}

# ---------------------------------------------------
# Language specific subroutines
# ---------------------------------------------------
    
sub terminal_name() {
    return "Macedonian Setup";
}

sub choose_encoding() {
    my $ss;
    $ss=&Sub::select("
Please choose your working encoding:
    1 = UTF-8
    2 = ISO-8859-5 (international Cyrillic encoding)
    3 = CP1251 (used by MS Windows)
", "
     :
    1 = UTF-8
    2 = ISO-8859-5 (  )
    3 = CP1251 (  MS Windows)
", 3, 1);
    if ($ss == 1) { return "UTF-8"; }
    if ($ss == 2) { return "ISO8859-5"; }
    if ($ss == 3) { return "CP1251"; }
}

sub dos_enc(&) { 
    return "ibm-cp855";
}

sub locale(&) { 
    my $locale = "mk_MK";
    my $encoding = "ISO8859-5";
    my $variant = "";
    if ( $encoding eq $_[0] ) {
	return $locale . $variant;
    } else {
	return $locale . "." . $_[0] . $variant;
    }
}

sub language_po(&) { 
    return "mk:en_UK";
}

sub mutt_encoding() { 
    return "us-ascii:iso-8859-5:iso-8859-1:utf-8";
}

sub mail_encoding(&) { 
    return "ISO-8859-5";
}

sub now_we_will_configure_kbd(&) { 
    &Sub::disp("
For adjusting Cyrillic on console please use the command cyr.
Now we will try to configure the keyboard.
", "
         cyr.
       .
");
}

sub choose_keyboard(&) {
    my $ss;         
    return ("pc/pc(pc105)+pc/us(basic):1+pc/mk(basic):2", "mk");             
}

sub grp_toggle(&) {    
    return &Sub::select("
How you will toggle between Cyrillic and Latin letters:
    1  = Right Alt
    2  = Left Shift + Right Shift (Right Shift on console)
    3  = Control + Shift
    4  = Control + Alt
    5  = Alt + Shift
    6  = Caps Lock (use Shift+CapsLock for CapsLock toggle)
    7  = Menu key
    8  = Left Windows logo key
    9  = Right Windows logo key
   10  = No toggling between Cyrillic and Latin
", "
      :
    1  =  Alt
    2  =  Shift +  Shift ( Shift  )
    3  = Control + Shift
    4  = Control + Alt
    5  = Alt + Shift
    6  = Caps Lock (Shift+CapsLock      CapsLock)
    7  = Menu 
    8  =  Windows  
    9  =  Windows  
   10  =      
", 10, 1);
}

sub grp_switch(&) {    
#    2 = Menu 
    return &Sub::select("
How you will switch temporary between Cyrillic and Latin letters:
    1 = Right Alt
    2 = Left and Right Windows logo keys
    3 = Left Windows logo key
    4 = Right Windows logo key
    5 = No temporary switching between Cyrillic and Latin
", "
       :
    1 =  Alt
    2 =    Windows  
    3 =  Windows  
    4 =  Windows  
    5 =       
", 5, 5);
}

sub lv3_switch(&) {    
    return 6;
}

# ---------------------------------------------------
# %messages
# ---------------------------------------------------


%messages = (

# msgid
  "\nPush [Enter] key to End.\n" =>
# msgstr1 (in native language but in ASCII)
  "\nPush [Enter] key to End.\n\000".
# msgstr2 (in native language and in native character set: for
# example ISO-8859-1)
  "\n [Enter]   .\n" ,

# msgid
  "Now obtaining package list...\n" =>
# msgstr1 (in ASCII)
  "Now obtaining package list...\n\000".
# msgstr2 (in Native Character Set)
  "    ...\n" ,

# msgid
  "Do setting? " =>
# msgstr1 (in ASCII)
  "Do setting? \000".
# msgstr2 (in Native Character Set)
  "? " ,

# msgid
  "Setting is not done.\n" =>
# msgstr1 (ASCII)
  "Setting is not done.\n\000".
# msgstr2 (in Native Character Set)
  "   .\n" ,

# msgid
  "Do setting...\n" =>
# msgstr1 (ASCII)
  "Do setting...\n\000".
# msgstr2 (in Native Character Set)
  "...\n" ,

# msgid
  "Cannot read \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot read \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\"     .\n" ,

# msgid
  "Making a new file \"%s\"...\n" =>
# msgstr1 (ASCII)
  "Making a new file \"%s\"...\n\000".
# msgstr2 (in Native Character Set)
  "   \"%s\"...\n" ,

# msgid
  "Cannot open \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot open \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\"     .\n" ,

# msgid
  "Cannot write to \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot write to \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "      \"%s\".\n" ,

# msgid
  "Cannot lock \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot lock \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\"     .\n" ,

# msgid
  "Cannot close \"%s\".\n" =>
# msgstr1 (ASCII)
  "Cannot close \"%s\".\n\000".
# msgstr2 (in Native Character Set)
  "\"%s\"     .\n" ,

# msgid
  "Install the following packages.\n" =>
# msgstr1 (ASCII)
  "Install the following packages.\n\000".
# msgstr2 (in Native Character Set)
  "   .\n" ,

# msgid
  "   Setting is now done.  To activate these settings,\n".
  "logout and login.\n".
  "   Read each dotfile and confirm the modification.\n".
  "If you don't like the setting, modify directly or\n".
  "add overriding setting after 'language-env end' line.\n".
  "   Read /usr/share/doc/language-env/README.* for detail.\n" =>
# msgstr1 (ASCII)
  "   Setting is now done.  To activate these settings,\n".
  "logout and login.\n".
  "   Read each dotfile and confirm the modification.\n".
  "If you don't like the setting, modify directly or\n".
  "add overriding setting after 'language-env end' line.\n".
  "   Read /usr/share/doc/language-env/README.* for detail.\n\000".
# msgstr2 (in Native Character Set)
  "      .       ,\n".
  "     .\n".
  "      -    .\n".
  "     ,    \n".
  "  'language-env end'      .\n".
  "     ,   /usr/share/doc/language-env/README.*.\n",

# msgid
  "Usage: set-language-env [options]\n".
  "  -l language : Specify language (otherwise choose from menu)\n".
  "  -h          : This help message\n".
  "  -v          : 'verbose mode'\n".
  "  -s          : Display list of supported languages and exit\n".
  "  -r          : Remove all settings\n".
  "  -N          : Never fork another set-language-env (for internal use)\n".
  "  -c          : Don't use native character set (for internal use)\n".
  "  -C          : Use native character set (for internal use)\n".
  "  -E          : Setting for /etc/skel directory (root user only)\n" =>
# msgstr1 (ASCII)
  "Usage: set-language-env [options]\n".
  "  -l language : Specify language (otherwise choose from menu)\n".
  "  -h          : This help message\n".
  "  -v          : 'verbose mode'\n".
  "  -s          : Display list of supported languages and exit\n".
  "  -r          : Remove all settings\n".
  "  -N          : Never fork another set-language-env (for internal use)\n".
  "  -c          : Don't use native character set (for internal use)\n".
  "  -C          : Use native character set (for internal use)\n".
  "  -E          : Setting for /etc/skel directory (root user only)\n\000".
# msgstr2 (in Native Character Set)
  ": set-language-env [options]\n".
  "  -l language :   ( ,    )\n".
  "  -h          :   \n".
  "  -v          : ' '\n".
  "  -s          :        \n".
  "  -r          :    \n".
  "  -N          :     set-language-env (  )\n".
  "  -c          :       (  )\n".
  "  -C          :      (  )\n".
  "  -E          :    /etc/skel (  root)\n",

# msgid
  "Install the following locales.\n" =>
# msgstr1 (ASCII)
  "Install the following locales.\n\000".
# msgstr2 (in Native Character Set)
  "   .\n" ,

# msgid
  "(Edit /etc/locale.gen and invoke locale-gen)\n" =>
# msgstr1 (ASCII)
  "(Edit /etc/locale.gen and invoke locale-gen)\n\000".
# msgstr2 (in Native Character Set)
  "(  /etc/locale.gen    locale-gen)\n" ,

# msgid
  "" =>
# msgstr1 (ASCII)
  "\000".
# msgstr2 (in Native Character Set)
  ""

);

$yes_upper = "Y";
$yes_lower = "y";
$no_upper = "N";
$no_lower = "n";
       

$need_locale = 'mk_MK.UTF-8 mk_MK mk_MK.CP1251';
 