#! /bin/bash

# should be run from within tests dir
# set if you move this:
mm_src_dir=../src
mm_bin=$mm_src_dir/masqmail

#
hfrom="\"Fritz Meier\" <`logname`@mykerinos>"
hto=$hfrom
to=`logname`@mykerinos
hsubject="MasqMail stdin Test"

#
# Testing with rcpt on cmd line
# (dot does end)
#
# the command to be run:
cmd="$mm_bin -C ./test.conf $to"

$cmd <<EOF
From: $hfrom
To: $hto
Subject: $hsubject

Hallo Fritz!

..
there is a dot above (Yes, one and not two).

command was: $cmd

Fritz
.

EOF

#
# Testing with rcpt on cmd line with -oi option
# (dot does not end)
#
# the command to be run:
cmd="$mm_bin -C ./test.conf -oi $to"

$cmd <<EOF
From: $hfrom
To: $hto
Subject: $hsubject

Hallo Fritz!
.
there is a dot above.

command was: $cmd

Fritz

EOF

#
# Testing with rcpt read from headers (-t option)
# (dot does end)
#
# the command to be run:
cmd="$mm_bin -C ./test.conf -t"

$cmd <<EOF
From: $hfrom
To: $hto
Subject: $hsubject

Hallo Fritz!
..
there is a dot above.

command was: $cmd

Fritz
.

EOF
