#!/bin/sh
### BEGIN INIT INFO
# Provides:          console-screen
# Required-Start:    $local_fs $remote_fs
# Required-Stop:     $local_fs $remote_fs
# Default-Start:     S 2 3 4 5
# Default-Stop:      0 1 6
### END INIT INFO

# This is the boot script for the `kbd' package.
# It loads parameters from /etc/kbd/config, maybe loads
# default font and map, and maybe start "vcstime"
# (c) 1997 Yann Dirson

PKG=kbd
if [ -r /etc/$PKG/config ]; then
    . /etc/$PKG/config
fi

if [ -d /etc/$PKG/config.d ]; then
    for i in `run-parts --list /etc/$PKG/config.d `; do
       . $i
    done
fi

. /lib/lsb/init-functions

PATH=/sbin:/bin:/usr/sbin:/usr/bin
SETFONT="/usr/bin/setfont"
SETFONT_OPT="-v"
VCSTIME="/usr/sbin/vcstime"

# Different device name for 2.6 kernels and devfs
if [ `uname -r | cut -f 2 -d .` = 6 ] && [ -e /dev/.devfsd ]; then
    VCSTIME_OPT="-2 /dev/vcsa0"
else
    VCSTIME_OPT=""
fi



# set DEVICE_PREFIX depending on devfs/udev
if [ -d /dev/vc ]; then
    DEVICE_PREFIX="/dev/vc/"
else
    DEVICE_PREFIX="/dev/tty"
fi

reset_vga_palette ()
{
    if [ -f /proc/fb ]; then
        # They have a framebuffer device.
        # That means we have work to do...
        echo -n "]R"
    fi
}

setup ()
{
    # be sure the main program is installed
    [ -x "${SETFONT}" ] || return

    VT="no"
    # If we can't access the console, quit
    CONSOLE_TYPE=`fgconsole 2>/dev/null` || return

    if [ ! $CONSOLE_TYPE = "serial" ]; then
        readlink /proc/self/fd/0 | grep -q -e /dev/vc -e '/dev/tty[^p]' -e /dev/console
        if [ $? -eq 0 ]; then
            VT="yes"
            reset_vga_palette
        fi
    fi

    [ $VT = "no" ] && return

    # start vcstime
    if [ "${DO_VCSTIME}" = "yes" ] && [ -x ${VCSTIME} ]; then
        [ "$VERBOSE" != "no" ] && log_action_begin_msg "Starting clock on text console"
        ${VCSTIME} ${VCSTIME_OPT} &
        [ "$VERBOSE" != "no" ] && log_action_end_msg 0
    fi

    if [ "$RUNLEVEL" = S ]; then
        LIST_CONSOLES=0
    elif [ -z "$LIST_CONSOLES" ]; then
        #  Wait for getty to provide TTYs
        sleep 3
        LIST_CONSOLES=`sed -e '/^ *#/d' /etc/inittab | grep 'tty[0-9]*$' | awk -F: '{printf "%s ", $1}'`
    fi

    # Global default font+map
    if [ "${CONSOLE_FONT}" ]; then
        [ "$VERBOSE" != "no" ] && log_action_begin_msg "Setting up general console font"
        [ "${CONSOLE_MAP}" ] && SETFONT_OPT="$SETFONT_OPT -m ${CONSOLE_MAP}"

        # Set for the first 6 VCs (as they are allocated in /etc/inittab)
        for vc in $LIST_CONSOLES
        do
            if ! ${SETFONT} -C ${DEVICE_PREFIX}$vc ${SETFONT_OPT} ${CONSOLE_FONT}; then
                [ "$VERBOSE" != "no" ] && log_action_end_msg 1
                break
            fi
        done
        [ "$VERBOSE" != "no" ] && log_action_end_msg 0
    fi


    # Per-VC font+sfm
    PERVC_FONTS="`set | grep "^CONSOLE_FONT_vc[0-9]*="  | tr -d \' `"
    if [ "${PERVC_FONTS}"  ]; then
        [ "$VERBOSE" != "no" ] && log_action_begin_msg "Setting up per-VC fonts"
        for font in ${PERVC_FONTS}
        do
            # extract VC and FONTNAME info from variable setting
            vc=`echo $font | cut -b15- | cut -d= -f1`
            eval font=\$CONSOLE_FONT_vc$vc
            # eventually find an associated SFM
            eval sfm=\${CONSOLE_MAP_vc${vc}}
            [ "$sfm" ] && sfm="-u $sfm"
            if ! ${SETFONT} -C ${DEVICE_PREFIX}$vc ${SETFONT_OPT} $sfm $font; then
                [ "$VERBOSE" != "no" ] && log_action_end_msg 1
                break
            fi
        done
        [ "$VERBOSE" != "no" ] && log_action_end_msg 0
    fi


#    # Global ACM
#    [ "${APP_CHARSET_MAP}" ] && ${CHARSET} G0 ${APP_CHARSET_MAP}
#
#
#    # Per-VC ACMs
#    PERVC_ACMS="`set | grep "^APP_CHARSET_MAP_vc[0-9]*="  | tr -d \' `"
#    if [ "${PERVC_ACMS}" ]; then
#        [ "$VERBOSE" != "no" ] && log_action_begin_msg "Setting up per-VC ACM's"
#        for acm in ${PERVC_ACMS}
#        do
#            # extract VC and FONTNAME info from variable setting
#            vc=`echo $acm | cut -b19- | cut -d= -f1`
#            eval acm=\$APP_CHARSET_MAP_vc$vc
#            if ! ${CHARSET} --tty="${DEVICE_PREFIX}$vc" G0 "$acm"; then
#                [ "$VERBOSE" != "no" ] && log_action_end_msg 1
#                break
#            fi
#        done
#        [ "$VERBOSE" != "no" ] && log_action_end_msg 0
#    fi


    # Go to UTF-8 mode as necessary
    # 
    if [ -f /etc/environment ] || [ -f /etc/default/locale ]
    then
        for var in LANG LC_CTYPE LC_ALL
        do
            value=$(egrep "^[^#]*${var}=" /etc/environment /etc/default/locale 2>/dev/null | tail -n1 | cut -d= -f2)
            eval $var=$value
        done
    fi
    CHARMAP=`LANG=$LANG LC_ALL=$LC_ALL LC_CTYPE=$LC_CTYPE locale charmap 2>/dev/null`
    if [ "$CHARMAP" = "UTF-8" ]; then
        action=unicode_start
    else
        action=unicode_stop
    fi
    for vc in $LIST_CONSOLES
    do
        $action < ${DEVICE_PREFIX}$vc > ${DEVICE_PREFIX}$vc 2> /dev/null || true
    done

    # screensaver stuff
    setterm_args=""
    if [ "$BLANK_TIME" ]; then
        setterm_args="$setterm_args -blank $BLANK_TIME"
    fi
    if [ "$BLANK_DPMS" ]; then
        setterm_args="$setterm_args -powersave $BLANK_DPMS"
    fi
    if [ "$POWERDOWN_TIME" ]; then
        setterm_args="$setterm_args -powerdown $POWERDOWN_TIME"
    fi
    if [ "$setterm_args" ]; then
        setterm $setterm_args 
    fi

    # Keyboard rate and delay
    KBDRATE_ARGS=""
    if [ -n "$KEYBOARD_RATE" ]; then
        KBDRATE_ARGS="-r $KEYBOARD_RATE"
    fi
    if [ -n "$KEYBOARD_DELAY" ]; then
        KBDRATE_ARGS="$KBDRATE_ARGS -d $KEYBOARD_DELAY"
    fi
    if [ -n "$KBDRATE_ARGS" ]; then
        [ "$VERBOSE" != "no" ] && log_action_begin_msg "Setting keyboard rate and delay"
        kbdrate -s $KBDRATE_ARGS
        [ "$VERBOSE" != "no" ] && log_action_end_msg 0
    fi

    # Inform gpm if present, of potential changes.
    if [ -f /var/run/gpm.pid ]; then
        kill -WINCH `cat /var/run/gpm.pid` 2> /dev/null
    fi

    # Allow user to remap keys on the console
    if [ -r /etc/$PKG/remap ]; then
        dumpkeys < ${DEVICE_PREFIX}1 | sed -f /etc/$PKG/remap | loadkeys --quiet
    fi

    # Set LEDS here
    if [ -n "$LEDS" ]; then
        for i in $LIST_CONSOLES
        do
            setleds -D $LEDS < $DEVICE_PREFIX$i
        done
    fi
}

case "$1" in
    start|reload|restart|force-reload)
        log_action_msg "Setting console screen modes and fonts"
        setup
        ;;
    stop)
        ;;
    *)
        setup
        ;;
esac

:

