/*
  ecp is designed to copy files, and is named extended cp.
  Copyright (C) 2006  Andre Reffhaug <areffhaug@areffhaug.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  ecp homepage   : https://savannah.nongnu.org/projects/ecp/
  Contact author : areffhaug@gmail.com
*/

#include <string.h>

/* could scan the whole path looking for more than one / */

void remove_trailing_slashes(char *path)
{
    while (path[strlen(path) - 1] == '/')
        path[strlen(path) - 1] = '\0';
}


const char *base(const char *name)
{
    int i = 0, index = -1;

    for (i = 0; name[i] != '\0'; ++i) 
    {
        if (name[i] == '/')
            index = i;
    }

    if (index == -1)
        return name;

    if (&name[index+1] == '\0')
        return NULL;
    else
        return &name[index+1];
}


/* implementation of realpath:

it is necessary to getcwd to get our current position in the file system
hierarchy. one must check the argument for a starting /, and also .. 
if the argument has none of these, we can append it to our getcwd-path.
should check that the result is a valid path.

while (path[0] && path[1] == '.')
remove them, plus the /
chdir to the correct dir
loop

if (path[0] == '.' && path[1] != '.')
remove it, plus the /
look at it again

if (path[0] == '/') we have the real path, no?


*/

char *rpath(char *path) 
{
    return 0;
}

void apptodir(char *dir, char *toapp)
{
    strcat(dir, "/");
    strcat(dir, toapp);
}
