#ifndef GLOBALS_H
#define GLOBALS_H


struct fsize {
    unsigned long bytes;
    unsigned long kbytes;
    unsigned long mbytes;
    unsigned long gbytes;
};

/* structure for the progress indication */
struct progress {
    float percent;
    int chunk;
    char *fname;
    struct fsize in_total;
    struct fsize total;
};

/* structure holding information on which options the program was 
   invoked with */

struct opt {
    bool information; /* implemented */
    bool recursive; /* implemented */
    bool preserve; /* implemented */
    bool no_zero_bytes; /* implemented */
    bool no_hidden_files; /* implemented */
    bool create; /* implemented, depth 0 */
    bool symlinks; /* implemented */
    bool kill; /* implemented */
    bool quiet; /* implemented */
    bool update; /* half implemented */
    bool hreadable; /* half implemented */
    bool noclobber; /* not implemented */
    bool verbose; /* half implemented */
    bool ftp_transfer; /* implemented */
    bool ftp_resume;    
};

#endif
