/*
  ecp is designed to copy files, and is named extended cp.
  Copyright (C) 2006  Andre Reffhaug <areffhaug@areffhaug.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  ecp homepage   : https://savannah.nongnu.org/projects/ecp/
  Contact author : areffhaug@gmail.com
*/

#ifndef COPYFUN_H
#define COPYFUN_H

#include <stdbool.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <limits.h>
#include "globals.h"
#include "ftp_conn.h"

#define CHUNK 128

/* struct for file sizes */

/* initializes the progress bar for each file */
void
init_progress (struct progress *prog, off_t *bsize, char *dstname);

void
init_progress_total (struct progress *prog, unsigned long long *bsize, unsigned long long *total);
    
/* updates progress bar as copying is taking place */
void
update_progress(struct progress *prog, struct opt *options);

void
update_progress_total (struct progress *prog, struct opt *options);

/* prints progress (quite crudely) */
void
do_progress (struct progress *prog, struct opt *options);

void
do_progress_total (struct progress *prog, struct opt *options,
                   int *file_count, int *total_files);

/* makes sure that the memory taken up by our progress struct
   is freed again */
void
destroy_progress (struct progress *prog);

/* copies infile to outfile */
bool
do_copy(char *infile, char *outfile, struct opt *options, bool todir);

unsigned long long
do_copy_total (char *srcname, 
                   char *outfile,
                   struct opt *options, 
                   bool todir, unsigned long long *total_progress,
                   unsigned long long *total_size, int *filecount,
                   int *total_files);

/* walks directories, calling do_copy on each file */
void
copy_recursive(char *real_src_dir, char *real_target_dir, int depth,
               ino_t orig_inode, struct opt *options);

void copy_recursive_total (char *real_src_dir, 
                           char *real_target_dir,
                           int depth, ino_t orig_inode, 
                           struct opt *options, unsigned long long *total_progress,
                           unsigned long long *total_size, int *filecount,
                           int *total_files);

void count_total (char *source_dir, 
                  unsigned long long *total_size,
                  int *filecount, struct opt *options);
#endif
