#include <stdio.h>
#include "ftp_conn.h"
#include "ecp_info.h"


inline void
author (void) 
{
    printf ("Written by %s (2006).\n", AUTHOR);
}

inline void
version (void) 
{
    printf ("%s %i.%i.%i %s\n", NAME, VERSION_MAJOR,
            VERSION_MINOR, VERSION_RELEASE, VERSION_TEXT);
}

inline void
usage (void) 
{
    printf ("%s [OPTIONS] SOURCE(s) DESTINATION\n", NAME);
    printf ("\n");
  
    printf ("-R, --recursive               copies files/folder recursively\n");
    printf ("-t, --total                   displays total progress, rather than progress per file\n");
    printf ("-p, --preserve                preserves access and modification times\n");
    printf ("-n, --no-hidden-files         omits hidden files when copying\n");
    printf ("-c, --create                  creates target directory if it does not "
            "exist\n");
    printf ("-s, --d-syms                  dereferences symlinks\n");
    printf ("-k, --kill                    removes SOURCE after copying (use with caution)\n");
    printf ("-q, --quiet                   no information to stdout\n");
    printf ("-u, --update                  only copies if SOURCE is newer or "
            "modified (semi functional)\n");
    printf ("-h, --human-readable          output is formatted for humans\n");
    printf ("-v, --verbose                 output more information than usual\n");
    printf ("\n");

    printf ("--port [number]               specifies port number for ftp\n");
    printf ("--resume                      will try to resume a broken download\n");
    printf ("--information                 outputs some small information on ecp\n");
    printf ("--no-zero-bytes               skips files of zero byte length\n");
    printf ("--no-clobber                  don't overwrite or otherwise destroy already "
            "existing files\n");
    printf ("--version                     outputs version information and exits\n");
    printf ("--help                        this message\n");
    printf ("\n");
    ftp_usage ();
}

inline void
information (void) 
{
    version ();
    author ();
    printf ("Compiled: %s %s\n", __DATE__, __TIME__);
    printf ("Compiled with GCC version %d.%d.%d\n", __GNUC__, __GNUC_MINOR__, __GNUC_PATCHLEVEL__);
    printf ("Glibc version %d.%d, ", __GLIBC__, __GLIBC_MINOR__);
    printf ("GNU library %d\n", __GNU_LIBRARY__);
    printf ("Latest ecp can be found at: http://www.nongnu.org/ecp/\n");
}

inline void
conditions (void)
{
    printf ("This is free software; see the source for copying conditions. There is NO\n");
    printf ("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUSE.\n");
}

inline void
help_hint (void)
{
    printf ("%s: Use option '--help' for usage information\n", NAME);
}
  
