#ifndef FTP_CONN_H
#define FTP_CONN_H

#include <stdbool.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>
#include <netdb.h>
#include "globals.h"

#define FTP_BUFSIZ 32768

#define FTP_RETROK   150
#define FTP_GREET    220
#define FTP_LOGOUT   221
#define FTP_PASV     227
#define FTP_LOGIN    230
#define FTP_CWDOK 250
#define FTP_USEROK   331
#define FTP_NEEDACCT 332
#define FTP_INVALID  530
#define FTP_CLOSE    412
#define FTP_NOFILE   451
#define FTP_NOLOGIN  530
#define FTP_FNOEXIST 550
#define FTP_NOFILE2  551


typedef struct __ftp {
  int socket;
  int port;
  socklen_t len;
  struct sockaddr_in address;
    struct timeval timeout;
  fd_set readfds;
  fd_set writefds;
  bool usePasv;
  bool usePort;
  char username[64];
  char password[128];
  char server[128];
  char path[1024];
  int response;
  bool multiline;
  char buffer[FTP_BUFSIZ];
} ftp_t;

int
wait_server (ftp_t *ftp);

ftp_t *
alloc_ftp ();

void
ftp_connect (ftp_t *ftp, int port);

int
ftp_sendcmd (ftp_t *ftp, const char *cmd, const char *arg);

void
ftp_read (ftp_t *ftp, char *buffer);

int
ftp_retr (ftp_t *ftp, ftp_t *dataftp, char *fname, 
          char *toname, char *message, struct opt *options);

ftp_t *
ftp_mode (ftp_t *ftp, char *buffer);

void
ftp_getresp (ftp_t *ftp, char *response);

void
ftp_parsecmd (ftp_t *ftp, char *cmdline);

inline void
ftp_usage (void);

char *
ftp_reader (ftp_t *ftp);

void
ftp_login (ftp_t *ftp, int port, struct opt *options, char *messagebuf);

int
ftp_store (ftp_t *ftp, ftp_t *dataftp, char *fname, char *messagebuf, struct opt *options,
           off_t *fsize);

#endif
