/*
 *  Off-the-Record Messaging plugin for libpurple
 *  Copyright © 2004-2008  Ian Goldberg, Rob Smits,
 *                         Chris Alexander, Nikita Borisov
 *                         <otr@cypherpunks.ca>
 *  Copyright © 2009       Vivek Dasmohapatra <vivek@etla.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* system headers */
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

/* gcrypt headers */
#include <gcrypt.h>

/* purple headers */
#include "version.h"
#include "plugin.h"
#include "notify.h"
#include "util.h"
#include "core.h"

#include <glib/gi18n-lib.h>
/* libotr headers */
#include <libotr/dh.h>
#include <libotr/privkey.h>
#include <libotr/proto.h>
#include <libotr/message.h>
#include <libotr/userstate.h>

/* elim-otr headers */
#include "otr-dialog.h"
#include "otr-ui.h"
#include "otr.h"

#define SMP_DATA_KEY "otr-smpdata"
#define NULLIFY_STRING(x) g_string_free( x, TRUE ); x = NULL

typedef struct 
{
    ConnContext *context;  /* The context used to fire library code */
    GString     *question; /* The user question */
    GString     *entry;    /* The secret */
    int         smp_type;  /* Whether the SMP type is based on 
                              question challenge (0) 
                              or shared secret   (1) */
    gboolean    responder; /* Whether or not this is the first side to give
                              their secret */
} smp_response_pair;

typedef struct dialog_context_data
{
    GString           *secret_dialog  ;
    smp_response_pair *secret_smppair ;
    GString           *progress_dialog;
    GString           *progress_bar   ;
    GString           *progress_label ;
} smp_data;

typedef struct 
{
    smp_response_pair *smppair      ;
    GString           *one_way_entry;
    GString           *two_way_entry;
    GString           *notebook     ;
} auth_signal_data;

static void close_progress_window(smp_sata *smp)
{
    NULLIFY_STRING( smp->progress_dialog );
    NULLIFY_STRING( smp->progress_bar    );
    NULLIFY_STRING( smp->progress_label  );
}

static void otrui_dialog_free_smp_data(PurpleConversation *conv)
{
    smp_data *smp = purple_conversation_get_data( conv, SMP_DATA_KEY );

    if( !smp ) return;

    NULLIFY_STRING( smp->secret_dialog  );
    NULLIFY_STRING( smp->secret_smppair );

    close_progress_window( smp );

    purple_conversation_set_data( conv, SMP_DATA_KEY, NULL );
    g_free( smp );
}

static void otrg_gtk_dialog_add_smp_data(PurpleConversation *conv)
{
    SMPData *smp_data = malloc(sizeof(SMPData));
    smp_data->smp_secret_dialog = NULL;
    smp_data->smp_secret_smppair = NULL;
    smp_data->smp_progress_dialog = NULL;
    smp_data->smp_progress_bar = NULL;
    smp_data->smp_progress_label = NULL;

    purple_conversation_set_data(conv, "otr-smpdata", smp_data);
}
