dnl -----------------------------------------------
dnl custom macros for autoconf script
dnl Author: Antoine Fraboulet
dnl Created: 20.06.99
dnl Version: $Id: acinclude.m4,v 1.2 2000/07/21 16:07:14 antoine Exp $
dnl Stolen from: Vadim Zeitlin (wxGTK package)
dnl -----------------------------------------------

dnl ===========================================================================
dnl AM_PATH_WX([MINIMUM_VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for wxWindows, and defines WXWIN_CFLAGS and WXWIN_LIBS
dnl ===========================================================================
AC_DEFUN(AM_PATH_WX, 
[

  if test x$wx_config_exec_prefix != x ; then
     wx_config_args="$wx_config_args --exec-prefix=$wx_config_exec_prefix"
     if test x${GTK_CONFIG+set} != xset ; then
        WX_CONFIG=$wx_config_exec_prefix/wx-config
     fi
  fi
  if test x$wx_config_prefix != x ; then
     wx_config_args="$wx_config_args --prefix=$wx_config_prefix"
     if test x${WX_CONFIG+set} != xset ; then
        WX_CONFIG=$wx_config_prefix/wx-config
     fi
  fi

  AC_PATH_PROG(WX_CONFIG, wx-config, no)
  min_wx_version=ifelse([$1], ,2.2,$1)
  AC_MSG_CHECKING(for wxWindows - version >= $min_wx_version)
  no_wx=""
  if test "$WX_CONFIG" != "no" ; then
     WXWIN_CFLAGS=`$WX_CONFIG --cflags`
     WXWIN_LIBS=`$WX_CONFIG --libs`
     ac_save_CFLAGS="$CFLAGS"
     ac_save_LIBS="$LIBS"
     CFLAGS="$CFLAGS $WXWIN_CFLAGS"
     LIBS="$LIBS $WXWIN_LIBS"
dnl
dnl Now check if the installed GTK is sufficiently new. (Also sanity
dnl checks the results of gtk-config to some extent)
dnl
    AC_TRY_RUN([
#include "wx/version.h"
#include <stdio.h>

int
main ()
{
  int major, minor, micro;

  if (sscanf("$min_wx_version", "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_wx_version");
     exit(1);
   }

  return !((wxMAJOR_VERSION > major) ||
	  ((wxMAJOR_VERSION == major) && (wxMINOR_VERSION > minor)) ||
	  ((wxMAJOR_VERSION == major) && (wxMINOR_VERSION == minor) && (wxRELEASE_NUMBER >= micro)));
}
],, no_wx=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
     CFLAGS="$ac_save_CFLAGS"
     LIBS="$ac_save_LIBS"
  else
     no_wx=yes
  fi

  if test "x$no_wx" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])
  else
     AC_MSG_RESULT(no)
     WXWIN_CFLAGS=""
     WXWIN_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(WXWIN_CFLAGS)
  AC_SUBST(WXWIN_LIBS)
])
dnl ===========================================================================
dnl AM_PATH_WX end
dnl ===========================================================================
