/* Eliot                                                                     */
/* Copyright (C) 1999  Antoine Fraboulet                                     */
/* Antoine.Fraboulet@free.fr                                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* $Id: auxframes.cc,v 1.19 2000/12/21 16:22:59 antoine Exp $ */

#include "ewx.h"

#include "dic.h"
#include "dic_search.h"
#include "game.h"

#include "configdb.h"
#include "auxframes.h"
#include "mainframe.h"
#include "searchpanel.h"

#include "wx/listctrl.h"
#ifdef ENABLE_COPY
    #include "wx/clipbrd.h"
    #include "wx/dataobj.h"
#endif

BEGIN_EVENT_TABLE(AuxFrame, wxFrame)
  EVT_CLOSE(AuxFrame::OnCloseWindow)
  EVT_SIZE(AuxFrame::OnSize)
END_EVENT_TABLE()
  
AuxFrame::AuxFrame(wxFrame* parent, int _id, wxString _name, wxString _classname, Game _g)
    : wxFrame(parent, -1, wxString("Eliot: ") + _name, wxPoint(-1,-1),
	      wxSize(-1,-1), wxDEFAULT_FRAME_STYLE, _classname)
{
  game      = _g;
  frameid   = _id;
  name      = _name;
  classname = _classname;
}

void
AuxFrame::OnSize(wxSizeEvent& e)
{
  wxFrame::OnSize(e);
  config.setFrameDim(classname,GetClientSize());
}

void
AuxFrame::OnCloseWindow(wxCloseEvent& event)
{
  if (GetParent())
    ((MainFrame*)GetParent())->KilledShowAux(frameid);
  this->Destroy();
}

/****************************************************************/
/* AUXFRAMELIST */
/****************************************************************/

enum {
  ListBoxID,
#ifdef ENABLE_COPY
  ButtonCopyID
#endif
};


BEGIN_EVENT_TABLE(AuxFrameList, AuxFrame)
#ifdef ENABLE_COPY
  EVT_BUTTON        (ButtonCopyID ,AuxFrameList::OnCopy)
#endif
END_EVENT_TABLE()


AuxFrameList::AuxFrameList(wxFrame* parent, int _id, wxString _name,
			     wxString _classname, Game _g)
  : AuxFrame(parent, _id, _name, _classname, _g)

{
  wxBoxSizer *sizer_v = new wxBoxSizer( wxVERTICAL);
  listbox = new wxListBox(this,ListBoxID);
  listbox->SetFont(config.getFontSearch());
  listbox->SetToolTip(name);
  sizer_v->Add(listbox, 1, wxEXPAND | wxALL, 1);

#ifdef SET_BUTTON_FONT
  SetFont(BUTTON_FONT);
#endif
#ifdef ENABLE_COPY
  button = new wxButton(this,ButtonCopyID,"Copier",wxPoint(0,0),wxSize(-1,-1));
  sizer_v->Add(button, 0, wxEXPAND | wxALL, 1);
#endif

  wxBoxSizer *sizer = new wxBoxSizer( wxHORIZONTAL );
  sizer->Add(sizer_v, 1, wxEXPAND, 0);

  SetAutoLayout(TRUE);
  SetSizer(sizer);
  sizer->Fit(this);
  sizer->SetSizeHints(this);
  SetClientSize(config.getFrameDim(classname));
}

#ifdef ENABLE_COPY
void
AuxFrameList::OnCopy(wxCommandEvent& event)
{
  wxString textdata;

  if (wxTheClipboard->Open())
    {
      textdata = "";
      for(int i=0; i < listbox->Number(); i++)
	{
	  textdata << listbox->GetString(i) << "\n";
	}
      wxTextDataObject* ptr = new wxTextDataObject(textdata);
      wxTheClipboard->AddData(ptr); 
      wxTheClipboard->Close();
    }
}
#endif

void
AuxFrameList::Waiting()
{
  //
  listbox->Clear();
  listbox->Show(TRUE);
  //
}

/****************************************************************/
/* VERIF FRAME */
/****************************************************************/

enum
{
  Word_Id,
  Result_Id,
};

BEGIN_EVENT_TABLE(VerifFrame, AuxFrame)
  EVT_TEXT(Word_Id, VerifFrame::OnText)
END_EVENT_TABLE()

VerifFrame::VerifFrame(wxFrame* parent, Game g)
    : AuxFrame(parent, ID_Frame_Verif, "vrification","verifframe",g)
{
  word = new wxTextCtrl(this,Word_Id,wxString(""));
  word->SetFont(config.getFontSearch());
  word->SetToolTip("Mot  vrifier");
  result = new wxStaticText(this,Result_Id,wxString(""));
  result->SetFont(config.getFontSearch());
  wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
  sizer->Add(word, 1, wxEXPAND | wxALL, 1);
  sizer->Add(result, 1, wxALIGN_CENTER_VERTICAL | wxALIGN_LEFT | wxALL, 1);

  SetAutoLayout(TRUE);
  SetSizer(sizer);
  sizer->Fit(this);
  sizer->SetSizeHints(this);
  SetClientSize(config.getFrameDim(classname));
}

void
VerifFrame::verif()
{
  Dictionary dic;
  dic = Game_getdic(game);
  if (dic == NULL)
    {
      result->SetLabel(wxString("pas de dictionnaire"));
      return;
    }
  if (Dic_search_word(dic,(const char*) word->GetValue()))
    result->SetLabel(wxString("existe"));
  else
    result->SetLabel(wxString("n'existe pas"));
}

void
VerifFrame::OnText(wxCommandEvent&)
{
  verif();
}

/****************************************************************/
/* RECHERCHE */
/****************************************************************/

SearchFrame::SearchFrame(wxFrame *parent, Game g)
  : AuxFrame(parent,ID_Frame_Search,"recherche","recherche",g)
{
  panel = new SearchPanel(this, Game_getdic(g));
  wxBoxSizer *sizer = new wxBoxSizer( wxHORIZONTAL );
  sizer->Add(panel, 1, wxEXPAND, 0);
  SetAutoLayout(TRUE);
  SetSizer(sizer);
  sizer->Fit(this);
  //sizer->SetSizeHints(this);
  SetClientSize(config.getFrameDim(classname));
}

/****************************************************************/
/*  BENJAMINS */
/****************************************************************/

void
BenjFrame::RefreshList(int n)
{
  int i;
  char word[WORD_SIZE_MAX + 1];
  char wordlist[RES_BENJ_MAX][DIC_WORD_MAX];
  
  if (n < 0)
    {
      listbox->Clear();
      return;
    }

  Waiting();
  Game_getsearchedword(game,n,word);
  if (Game_getdic(game) == NULL)
    return;
  Dic_search_Benj(Game_getdic(game),word,wordlist);

#if defined(ENABLE_LISTBOX_SET)
  int resnum = 0;
  wxString res[RES_BENJ_MAX];
  for(i=0; (i < RES_BENJ_MAX) && (wordlist[i][0]); i++)
    res[resnum++] = wxString(wordlist[i]);
  listbox->Set(resnum,res);
#else
  listbox->Clear();
  for(i=0; (i < RES_BENJ_MAX) && (wordlist[i][0]); i++)
    listbox->Append(wxString(wordlist[i]));
#endif
}

/****************************************************************/
/* PLUS1 FRAME */
/****************************************************************/

void
Plus1Frame::RefreshList(int)
{
  int  i,j;
  char rack[RACK_SIZE_MAX];
  char buff[LETTERS][RES_7PL1_MAX][DIC_WORD_MAX];

  Waiting();
  Game_getplayedrack(game,Game_getnrounds(game),rack);
  if (Game_getdic(game) == NULL)
    return;
  Dic_search_7pl1(Game_getdic(game),rack,buff,config.getJokerPlus1()); 

#if defined(ENABLE_LISTBOX_SET)
  int resnum = 0;
  wxString res[LETTERS*(RES_7PL1_MAX+1)];
  res[resnum++] = wxString("Tirage: ") + wxString(rack);
  for(i=0; i < LETTERS; i++)
    {
      if (i && buff[i][0][0])
	res[resnum++] = wxString("+") + wxString((char)(i+'A'-1));
      for(j=0; j < RES_7PL1_MAX && buff[i][j][0]; j++)
	res[resnum++] = wxString("  ") + wxString(buff[i][j]);
    }
  listbox->Set(resnum,res);
#else
  listbox->Clear();
  listbox->Append(wxString("Tirage: ") + wxString(rack));
  for(i=0; i < LETTERS; i++)
    {
      if (i && buff[i][0][0])
	listbox->Append(wxString("+") + wxString((char)(i+'A'-1)));
      for(j=0; j < RES_7PL1_MAX && buff[i][j][0]; j++)
	listbox->Append(wxString("  ")+wxString(buff[i][j]));
    }
#endif
}

/****************************************************************/
/* RACC FRAME */
/****************************************************************/

void
RaccFrame::RefreshList(int n)
{
  int i;
  char word[WORD_SIZE_MAX + 1];
  char wordlist[RES_RACC_MAX][DIC_WORD_MAX];

  if (n < 0)
    {
      listbox->Clear();
      return;
    }

  Waiting();
  Game_getsearchedword(game,n,word);
  if (Game_getdic(game) == NULL)
    return;
  Dic_search_Racc(Game_getdic(game),word,wordlist);

#if defined(ENABLE_LISTBOX_SET)
  int resnum = 0;
  wxString res[RES_RACC_MAX];
  for(i=0; (i < RES_RACC_MAX) && (wordlist[i][0]); i++)
    {
      res[resnum++] = wxString(wordlist[i]);
    }
  listbox->Set(resnum,res);
#else
  listbox->Clear();
  for(i=0; (i < RES_RACC_MAX) && (wordlist[i][0]); i++)
    {
      listbox->Append(wxString(wordlist[i]));
    }
#endif
}


/****************************************************************/
/* BAG FRAME */
/****************************************************************/

BagFrame::BagFrame(wxFrame* parent, Game g)
     : AuxFrame(parent, ID_Frame_Bag, "sac", "bagframe",g)
{
  game = g;
  tiles = new wxListCtrl(this,-1);
  tiles->SetSingleStyle(wxLC_LIST);
  tiles->SetColumnWidth(0,wxLIST_AUTOSIZE);
  tiles->SetFont(config.getFontSearch());
  tiles->SetToolTip("Lettre,nombre");
  Refresh();

  wxBoxSizer *sizer = new wxBoxSizer( wxHORIZONTAL );
  sizer->Add(tiles, 1, wxEXPAND | wxALL, 1);
  SetAutoLayout(TRUE);
  SetSizer(sizer);
  sizer->Fit(this);
  //  sizer->SetSizeHints(this);
  SetClientSize(config.getFrameDim(classname));
}


void
BagFrame::Refresh()
{
  char c;
  wxString buf;
  wxChar format[] = "%c=%d";

  tiles->ClearAll();
  buf.Printf(format,'?',Game_getcharinbag(game,'?'));
  tiles->InsertItem(0,buf);
  for(c = 'A'; c <= 'Z'; c++) 
    {
      buf.Printf(format,c,Game_getcharinbag(game,c));
      tiles->InsertItem(1 + c - 'A',buf);
    }
}

/****************************************************************/
/****************************************************************/

