/* Eliot                                                                     */
/* Copyright (C) 1999  Antoine Fraboulet                                     */
/* Antoine.Fraboulet@free.fr                                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* $Id: auxframes.h,v 1.11 2000/12/12 01:50:40 antoine Exp $ */

// -*- C++ -*-
#ifndef _AUXFRAMES_H
#define _AUXFRAMES_H

#include "searchpanel.h"
#include "wx/listctrl.h"

class AuxFrame: public wxFrame
{
protected:
  int frameid;
  Game game;
  wxString name,classname;
  ConfigDB config;
public:
  AuxFrame(wxFrame*,int,wxString,wxString,Game);
  void OnSize (wxSizeEvent& event);
  void OnCloseWindow  (wxCloseEvent& event);
  DECLARE_EVENT_TABLE()
};

class AuxFrameList: public AuxFrame
{
protected:
  wxListBox  *listbox;
#ifdef ENABLE_COPY
  wxButton *button;
#endif
  void Waiting();
public:
  AuxFrameList(wxFrame*,int,wxString,wxString,Game);
  virtual void RefreshList(int) {}
#ifdef ENABLE_COPY
  void OnCopy(wxCommandEvent& event);
#endif
  DECLARE_EVENT_TABLE()
};

enum {
  ID_Frame_Verif,
  ID_Frame_Search,
  ID_Frame_Plus1,
  ID_Frame_Racc,
  ID_Frame_Benj,
  ID_Frame_Bag
};

class BagFrame: public AuxFrame
{
private:
  wxListCtrl *tiles;
public:
  BagFrame(wxFrame*,Game);
  void Refresh();
};

class SearchFrame: public AuxFrame
{
private:
  SearchPanel *panel;
public:
  SearchFrame(wxFrame*,Game);
};

class VerifFrame: public AuxFrame
{
private:
  wxTextCtrl *word;
  wxStaticText *result;
  void verif();
public:
  VerifFrame(wxFrame*,Game);
  void OnText        (wxCommandEvent& event);
  DECLARE_EVENT_TABLE()
};

class BenjFrame: public AuxFrameList
{
public:
  BenjFrame(wxFrame* parent,Game g) :
    AuxFrameList(parent,ID_Frame_Benj,wxString("benjamins"),
		 wxString("benjamins"),g) {};
  void RefreshList(int n);
};

class Plus1Frame: public AuxFrameList
{
public:
  Plus1Frame(wxFrame* parent,Game g) :
    AuxFrameList(parent,ID_Frame_Plus1,wxString("tirage + 1"),
		 wxString("7plus1"), g) {};
  void RefreshList(int n);
};

class RaccFrame: public AuxFrameList
{
public:
  RaccFrame(wxFrame* parent,Game g) : 
    AuxFrameList(parent,ID_Frame_Racc,wxString("raccords"),
		 wxString("raccords"), g) {};
  void RefreshList(int n);
};

#endif
