/* Eliot                                                                     */
/* Copyright (C) 1999  Antoine Fraboulet                                     */
/* Antoine.Fraboulet@free.fr                                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* $Id: configdb.cc,v 1.14 2000/12/12 01:50:40 antoine Exp $ */

#include "ewx.h"
#include "configdb.h"
#include "wx/fontdlg.h"
#include "wx/colordlg.h"

#define DIM 200
#define PREFIX  "/"

#define DICPATH PREFIX"Dictionnaire/Chemin"
#define DICNAME PREFIX"Dictionnaire/Nom"

///////////////////////////
//
// Print
//
///////////////////////////
#define ORIENT  PREFIX"Print/Page/Orientation"
#define MARGINX PREFIX"Print/Page/MargeGauche"
#define MARGINY PREFIX"Print/Page/MargeHaute"

#define HNAME   PREFIX"Print/Header/Nom/"
#define HFONT   PREFIX"Print/Header/Fonte/"
#define HDIM    PREFIX"Print/Header/Dimensions/"
#define HJUST   PREFIX"Print/Header/Justification/"
#define HSPACE  PREFIX"Print/Header/Espacement/"

#define TFONT   PREFIX"Print/Text/Fonte/"
#define TDIM    PREFIX"Print/Text/Dimensions/"
#define TJUST   PREFIX"Print/Text/Justification/"
#define TSPACE  PREFIX"Print/Text/Espacement/"

///////////////////////////
//
// Board Drawing
//
///////////////////////////

#define BFONT              PREFIX"Board/Fonte/"
#define BCOLOURLINES       PREFIX"Board/Couleurs/Lignes/"
#define BCOLOURWX2         PREFIX"Board/Couleurs/MotsX2/"
#define BCOLOURWX3         PREFIX"Board/Couleurs/MotsX3/"
#define BCOLOURLX2         PREFIX"Board/Couleurs/LettresX2/"
#define BCOLOURLX3         PREFIX"Board/Couleurs/LettresX3/"
#define BCOLOURBACKGROUND  PREFIX"Board/Couleurs/fond/"
#define BCOLOURLETTERS     PREFIX"Board/Couleurs/lettres/"
#define BCOLOURTESTLETTERS PREFIX"Board/Couleurs/LettresPlacee/"

///////////////////////////
//
// Frames
//
///////////////////////////
#define FRAMEDIM  PREFIX"Frames/Dimensions/"
#define FRAMEPOS  PREFIX"Frames/Positions/"
#define FRAMEFONT PREFIX"Frames/Fontes/"
#define SFONT     FRAMEFONT"Search/"


#define MISC      PREFIX"Divers/"

ConfigDB::ConfigDB()
{
   pConfig = wxConfigBase::Get();
}


////////////////////////////////////////////////////////
//
// Overload of the Read function
// bool, long, wxFont, wxColour, wxString
//
// bool HasEntry(wxString&)
// bool Exists(wxString&)
//
////////////////////////////////////////////////////////

bool ConfigDB::Read(const wxString& key, bool def)
{
  bool res;
  if (pConfig->Exists(key))
    pConfig->Read(key,&res,def);
  else
    res = def;
  return res;
}

long ConfigDB::Read(const wxString& key, long def)
{
  long res;
  if (pConfig->Exists(key))
    pConfig->Read(key,&res,def);
  else
    res = def;
  return res;
}

wxFont ConfigDB::Read(const wxString& key, wxFont def)
{
  return wxFont(Read(key + "Taille",(long)def.GetPointSize()),
		Read(key + "Famille",(long)def.GetFamily()),
		Read(key + "Style",(long)def.GetStyle()),
		Read(key + "Poids",(long)def.GetWeight()),
		Read(key + "Souligne",(long)def.GetUnderlined()));
}

wxColour ConfigDB::Read(const wxString& key, wxColour def)
{
  return wxColour(Read(key + "R",(long)def.Red()),
		  Read(key + "G",(long)def.Green()),
		  Read(key + "B",(long)def.Blue()));
}

wxString ConfigDB::ReadS(const wxString& key, wxString def)
{
  wxString res;

  /*  
  wxString msg;
  msg << "want to read -" << key << "-";
  wxMessageBox(msg, "Eliot configDB", wxICON_INFORMATION | wxOK);
  cout << msg << "\n";
  */

  if (pConfig->Read(key,&res) == FALSE)
    res = def;
  return res;
}

////////////////////////////////////////////////////////
//
// Overload of the Write function
// bool, long, wxFont, wxColour, wxString
//
////////////////////////////////////////////////////////

void ConfigDB::Write(const wxString& key, bool val)
{
  pConfig->Write(key,val);
}

void ConfigDB::Write(const wxString& key, long val)
{
  pConfig->Write(key,val);
}

void ConfigDB::Write(const wxString& key, wxFont font)
{
  pConfig->Write(key + "Taille",(long)font.GetPointSize());
  pConfig->Write(key + "Famille",(long)font.GetFamily());
  pConfig->Write(key + "Style",(long)font.GetStyle());
  pConfig->Write(key + "Poids",(long)font.GetWeight());
  pConfig->Write(key + "Souligne",(long)font.GetUnderlined()); 
}

void ConfigDB::Write(const wxString& key, wxColour colour)
{
  pConfig->Write(key + "R",(long)colour.Red());
  pConfig->Write(key + "G", (long)colour.Green());
  pConfig->Write(key + "B", (long)colour.Blue());
}

void ConfigDB::WriteS(const wxString& key, wxString str)
{
  pConfig->Write(key,str);
}

////////////////////////////////////////////////////////
//
// Dictionary
//
////////////////////////////////////////////////////////

wxString ConfigDB::getDicPath()
{
  return ReadS(DICPATH,wxString(""));
}

wxString ConfigDB::getDicName()
{
  return ReadS(DICNAME,wxString(""));
}

void ConfigDB::setDicPath(wxString dpath, wxString dname)
{
  WriteS(DICPATH,dpath);
  WriteS(DICNAME,dname);
}

////////////////////////////////////////////////////////
//
// Text length
//
////////////////////////////////////////////////////////

long ConfigDB::getDxBegin()
{
  return Read(TDIM"debut",1L);
}

void ConfigDB::setDxBegin(long d)
{
  Write(TDIM"debut",d);
}

long ConfigDB::getDxText(int i)
{
  long int res;
  switch (i) 
    {
    case 0: res = Read(TDIM"texte/1",10L); break;
    case 1: res = Read(TDIM"texte/2",30L); break;
    case 2: res = Read(TDIM"texte/3",30L); break;
    case 3: res = Read(TDIM"texte/4",10L); break;
    case 4: res = Read(TDIM"texte/5",10L); break;
    default:res = 0; break;
    }
  return res;
}

void ConfigDB::setDxText(int i, long v)
{
  wxString key;
  key << TDIM << "texte/" << (i+1);
  if (i<5)
    Write(key,v);
}

long ConfigDB::getDxEnd()
{
  return Read(TDIM"fin",1L);
}

void ConfigDB::setDxEnd(long d)
{
  Write(TDIM"fin",d);
}

long ConfigDB::getDyT1()
{
  return Read(TDIM"haut",1L);
}

void ConfigDB::setDyT1(long d)
{
  Write(TDIM"haut",d);
}

long ConfigDB::getDyT2()
{
  return Read(TDIM"bas",1L);
}

void ConfigDB::setDyT2(long d)
{
  Write(TDIM"bas",d);
}

long ConfigDB::getDyH1()
{
  return Read(HDIM"haut",1L);
}

void ConfigDB::setDyH1(long d)
{
  Write(HDIM"haut",d);
}

long ConfigDB::getDyH2()
{
  return Read(HDIM"bas",1L);
}

void ConfigDB::setDyH2(long d)
{
  Write(HDIM"bas",d);
}

wxString ConfigDB::getNameH(int i)
{
  wxString res;
  switch (i) 
    {
    case 0: res = ReadS(wxString(HNAME)+wxString("1"),wxString("Num")); break;
    case 1: res = ReadS(wxString(HNAME)+wxString("2"),wxString("Tirage")); break;
    case 2: res = ReadS(wxString(HNAME)+wxString("3"),wxString("Solution")); break;
    case 3: res = ReadS(wxString(HNAME)+wxString("4"),wxString("Pos")); break;
    case 4: res = ReadS(wxString(HNAME)+wxString("5"),wxString("Pts")); break;
    default: res = ""; break;
  }
  return res;
}

void ConfigDB::setNameH(int i, wxString str)
{
  wxString key;
  key << HNAME << (i+1);
  WriteS(key, str);
}

////////////////////////////////////////////////////////
//
// Text justification
//
////////////////////////////////////////////////////////

enum Justif ConfigDB::StrToJust(const wxString& str)
{
  enum Justif res;
  if (str.CmpNoCase("gauche") == 0)
    res = LEFT;
  else if (str.CmpNoCase("centre") == 0)
    res = CENTER;
  else if (str.CmpNoCase("droite") == 0)
    res = RIGHT;
  else
    res = LEFT;
  return res;
}

wxString ConfigDB::JustToStr(enum Justif j)
{
  wxString res;
  switch (j) {
  case LEFT:   res = "gauche"; break;
  case CENTER: res = "centre"; break;
  case RIGHT:  res = "droite"; break;
  }
  return res;
}

enum Justif ConfigDB::getJustif(const wxString& key)
{
  return StrToJust(ReadS(key,wxString("gauche")));
}

void ConfigDB::setJustif(const wxString& key, enum Justif j)
{
  WriteS(key,JustToStr(j));
}

enum Justif ConfigDB::getJustifH(int i)
{
  wxString key;
  key << HJUST << (i+1);
  return getJustif(key);
}

enum Justif ConfigDB::getJustifT(int i)
{
  wxString key;
  key << TJUST << (i+1);
  return getJustif(key);
}

void ConfigDB::setJustifH(int i, enum Justif j)
{
  wxString key;
  key << HJUST << (i+1);
  setJustif(key,j);
}

void ConfigDB::setJustifT(int i, enum Justif j)
{
  wxString key;
  key << TJUST << (i+1);
  setJustif(key,j);
}

////////////////////////////////////////////////////////
//
// Text Spaces
//
////////////////////////////////////////////////////////

int ConfigDB::getSpacesH(int i)
{
  wxString key;
  key << HSPACE << (i+1);
  return Read(key,0L);
}

int ConfigDB::getSpacesT(int i)
{
  wxString key;
  key << TSPACE << (i+1);
  return Read(key,0L);
}

void ConfigDB::setSpacesH(int i, int spaces)
{
  wxString key;
  key << HSPACE << (i+1);
  Write(key,(long)spaces);
}

void ConfigDB::setSpacesT(int i, int spaces)
{
  wxString key;
  key << TSPACE << (i+1);
  Write(key,(long)spaces);
}

////////////////////////////////////////////////////////
//
// Fonts
//
////////////////////////////////////////////////////////

wxFont ConfigDB::ChooseFont(wxFrame* frame,wxFont initfont)
{
  wxFont retfont = initfont;
  wxFontData data;
  data.SetInitialFont(initfont);
  wxFontDialog *dialog = new wxFontDialog(frame, &data);
  if (dialog->ShowModal() == wxID_OK) {
    wxFontData retdata = dialog->GetFontData();
    retfont = retdata.GetChosenFont();
  }
  dialog->Close();
  return retfont;
}

#define HFONTDEF wxFont(12, wxSWISS, wxNORMAL, wxBOLD)
#define TFONTDEF wxFont(10, wxSWISS, wxNORMAL, wxNORMAL)
#define BFONTDEF wxFont(10, wxSWISS, wxNORMAL, wxBOLD)
#define SFONTDEF wxFont(12, wxMODERN, wxNORMAL, wxNORMAL)

#define SETFONT(NAME,KEY)       \
void ConfigDB::NAME(wxFont f)   \
{                               \
  Write(KEY,f);                 \
}                      

SETFONT(setFontGameHead,HFONT)
SETFONT(setFontGameText,TFONT)
SETFONT(setFontBoard,BFONT)
SETFONT(setFontSearch,SFONT)

#define GETFONT(NAME,KEY,DEF)  \
wxFont ConfigDB::NAME()        \
{                              \
  return Read(KEY,DEF);        \
}

GETFONT(getFontGameHead,HFONT,HFONTDEF)
GETFONT(getFontGameText,TFONT,TFONTDEF)
GETFONT(getFontBoard,BFONT,BFONTDEF)
GETFONT(getFontSearch,SFONT,SFONTDEF)

/*
wxFont ConfigDB::getFont(wxString classname)
{
  wxString key;
  key = wxString(FRAMEFONT) + classname + wxString("/");
  return Read(key,wxFont(12,wxMODERN,wxNORMAL,wxNORMAL));
}

void ConfigDB::setFont(wxString classname, wxFont font)
{
  wxString key;
  key = wxString(FRAMEFONT) + classname + wxString("/");
  Write(key,font);
}
*/

////////////////////////////////////////////////////////
//
// Colours
//
////////////////////////////////////////////////////////

wxColour ConfigDB::ChooseColour(wxFrame* frame,wxColour initcolour)
{
     wxColour retcolour = initcolour;
     wxColourData data;
     data.SetColour(initcolour);
     wxColourDialog *dialog = new wxColourDialog(frame, &data);
     if (dialog->ShowModal() == wxID_OK) {
	  wxColourData retdata = dialog->GetColourData();
	  retcolour = retdata.GetColour();
     }
     dialog->Close();
     return retcolour;
}

#define LINESDEF   wxColour(101,101,101)
#define WX2DEF     wxColour(255,147,196)
#define WX3DEF     wxColour(240, 80, 94)
#define LX2DEF     wxColour( 34,189,240)
#define LX3DEF     wxColour( 29,104,240)
#define BACKDEF    wxColour(255,255,255)
#define LETTDEF    wxColour(  0,  0,  0)
#define TSTLETTDEF wxColour(  0,  0,  0)

void ConfigDB::setColourBoardDefault()
{
  Write(BCOLOURLINES,LINESDEF);
  Write(BCOLOURWX2,WX2DEF);
  Write(BCOLOURWX3,WX3DEF);
  Write(BCOLOURLX2,LX2DEF);
  Write(BCOLOURLX3,LX3DEF);
  Write(BCOLOURBACKGROUND,BACKDEF);
  Write(BCOLOURLETTERS,LETTDEF);
}

#define SETCOLOUR(NAME,KEY)        \
void ConfigDB::NAME(wxColour col)  \
{                                  \
  Write(KEY,col);                  \
}

SETCOLOUR(setColourBoardWx2,BCOLOURWX2)
SETCOLOUR(setColourBoardWx3,BCOLOURWX3)
SETCOLOUR(setColourBoardLx2,BCOLOURLX2)
SETCOLOUR(setColourBoardLx3,BCOLOURLX3)
SETCOLOUR(setColourBoardLines,BCOLOURLINES)
SETCOLOUR(setColourBoardBackground,BCOLOURBACKGROUND)
SETCOLOUR(setColourBoardLetters,BCOLOURLETTERS)
SETCOLOUR(setColourBoardTestLetters,BCOLOURTESTLETTERS)

#define GETCOLOUR(NAME,KEY,DEFAULT) \
wxColour ConfigDB::NAME()           \
{                                   \
  return Read(KEY,DEFAULT);         \
}                                       

GETCOLOUR(getColourBoardLines,BCOLOURLINES,LINESDEF)
GETCOLOUR(getColourBoardWx2,BCOLOURWX2,WX2DEF)
GETCOLOUR(getColourBoardWx3,BCOLOURWX3,WX3DEF)
GETCOLOUR(getColourBoardLx2,BCOLOURLX2,LX2DEF)
GETCOLOUR(getColourBoardLx3,BCOLOURLX3,LX3DEF)
GETCOLOUR(getColourBoardBackground,BCOLOURBACKGROUND,BACKDEF)
GETCOLOUR(getColourBoardLetters,BCOLOURLETTERS,LETTDEF)
GETCOLOUR(getColourBoardTestLetters,BCOLOURTESTLETTERS,TSTLETTDEF)

////////////////////////////////////////////////////////
//
// PRINTING 
//
////////////////////////////////////////////////////////

long ConfigDB::getMarginX()
{
  return Read(MARGINX,10L);
}

long ConfigDB::getMarginY()
{
  return Read(MARGINY,10L);
}

void ConfigDB::setMarginX(long x)
{
  Write(MARGINX,x);
}

void ConfigDB::setMarginY(long y)
{
  Write(MARGINY,y);
}

long ConfigDB::getOrientation()
{
  long res;
  wxString str;
  
  str = ReadS(ORIENT,"paysage");
  if (str.CmpNoCase("portrait") == 0)
    res = wxPORTRAIT;
  else if (str.CmpNoCase("paysage") == 0)
    res = wxLANDSCAPE;
  else
    res = wxPORTRAIT;
  return res;
}

void ConfigDB::setOrientation(long o)
{
  switch (o) 
    {
    case wxLANDSCAPE: WriteS(ORIENT,wxString("paysage")); break;
    case wxPORTRAIT: // fall through
    default: WriteS(ORIENT,wxString("portrait")); break;
    }
}

wxPrintData ConfigDB::getPrintData()
{
  wxPrintData pd;
  pd.SetOrientation(getOrientation());
  return pd;
}

void ConfigDB::setPrintData(wxPrintData pd)
{
  setOrientation(pd.GetOrientation());
}

wxPageSetupData ConfigDB::getPageSetupData()
{
  wxPageSetupData pd;
  wxPoint margin(getMarginX(),getMarginY());
  pd.SetMarginTopLeft(margin);
  return pd;
}

void ConfigDB::setPageSetupData(wxPageSetupData pd)
{
  setMarginX(pd.GetMarginTopLeft().x);
  setMarginY(pd.GetMarginTopLeft().y);
}

float ConfigDB::getPrintLineScale()
{
  return 0.2;
}

void ConfigDB::setPrintLineScale(float s)
{
}

////////////////////////////////////////////////////////
//
// Frame dimensions
//
////////////////////////////////////////////////////////

wxSize ConfigDB::getFrameDim(wxString frame)
{
  wxString keyX(FRAMEDIM + frame + "/x");
  wxString keyY(FRAMEDIM + frame + "/y");
  return wxSize(Read(keyX,150L),Read(keyY,200L));
}

void ConfigDB::setFrameDim(wxString frame, wxSize size)
{
  wxString keyX(FRAMEDIM + frame + "/x");
  wxString keyY(FRAMEDIM + frame + "/y");
  Write(keyX,(long)size.x);
  Write(keyY,(long)size.y);
}


wxSize ConfigDB::getMainFrameDim()
{
  wxString frame = "eliot";
  wxString keyX(FRAMEDIM + frame + "/x");
  wxString keyY(FRAMEDIM + frame + "/y");
  return wxSize(Read(keyX,640L),Read(keyY,450L));
}

void ConfigDB::setMainFrameDim(wxSize s)
{
  setFrameDim(wxString("eliot"),s);
}

////////////////////////////////////////////////////////
//
// Game Options
//
////////////////////////////////////////////////////////

void ConfigDB::setJokerPlus1(bool val)
{
  wxString key;
  key = wxString(MISC) + wxString("JokersDans7plus1");
  Write(key,val);
}

bool ConfigDB::getJokerPlus1()
{
  wxString key;
  key = wxString(MISC) + wxString("JokersDans7plus1");
  return Read(key,(bool)FALSE);
}

void ConfigDB::setRackChecking(bool val)
{
  wxString key;
  key = wxString(MISC) + wxString("VerificationTirages");
  Write(key,val);
}

bool ConfigDB::getRackChecking()
{
  wxString key;
  key = wxString(MISC) + wxString("VerificationTirages");
  return Read(key,(bool)FALSE);
}

////////////////////////////////////////////////////////
//
// 
//
////////////////////////////////////////////////////////
