/* Eliot                                                                     */
/* Copyright (C) 1999  Antoine Fraboulet                                     */
/* Antoine.Fraboulet@free.fr                                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* $Id: configdb.h,v 1.13 2000/12/12 01:50:40 antoine Exp $ */

// -*-C++-*-

#ifndef _CONFIGDB_H
#define _CONFIGDB_H

#include "wx/confbase.h"
#include "wx/font.h"
#include "wx/frame.h"

#define BUTTON_FONT wxFont(8,wxDEFAULT,wxNORMAL,wxNORMAL)

enum Justif { LEFT, CENTER, RIGHT };

class ConfigDB 
{
private:
  wxConfigBase* pConfig;
  enum Justif StrToJust(const wxString&);
  wxString JustToStr(enum Justif);
  
  enum Justif getJustif(const wxString&); 
  void setJustif(const wxString&, enum Justif);
  
  bool Read(const wxString&, bool);
  long Read(const wxString&, long);
  wxFont Read(const wxString&, wxFont);
  wxColour Read(const wxString&, wxColour);
  wxString ReadS(const wxString&, wxString);
  
  void Write(const wxString&, bool);
  void Write(const wxString&, long);
  void Write(const wxString&, wxFont);
  void Write(const wxString&, wxColour);
  void WriteS(const wxString&, wxString);
  
public:
  ConfigDB();
  
  wxFont ChooseFont(wxFrame*,wxFont);
  wxColour ChooseColour(wxFrame*,wxColour);
  
  // Dictionary
  wxString getDicPath();
  wxString getDicName();
  void setDicPath(wxString,wxString);
  
  // page setup
  long getOrientation();
  void setOrientation(long);
  
  // game drawing
  long getDxBegin();
  long getDxText(int);
  long getDxEnd();
  void setDxBegin(long);
  void setDxText(int,long);
  void setDxEnd(long);
  
  long getDyH1();
  long getDyH2();
  long getDyT1();
  long getDyT2();
  void setDyH1(long);
  void setDyH2(long);
  void setDyT1(long);
  void setDyT2(long);
  
  int  getSpacesH(int);
  int  getSpacesT(int);
  void setSpacesH(int,int);
  void setSpacesT(int,int);
  
  enum Justif getJustifH(int);
  enum Justif getJustifT(int);
  void setJustifH(int, enum Justif);
  void setJustifT(int, enum Justif);
  
  wxString getNameH(int);
  void setNameH(int, wxString);
  
  long getMarginX();
  long getMarginY();
  void setMarginX(long);
  void setMarginY(long);
  
  wxFont getFontGameHead();
  wxFont getFontGameText();
  wxFont getFontBoard();
  wxFont getFontSearch();
  wxFont getFont(wxString);
  
  void setFontGameHead(wxFont);
  void setFontGameText(wxFont);
  void setFontBoard(wxFont);
  void setFontSearch(wxFont);
  void setFont(wxString,wxFont);
  
  void setColourBoardLines(wxColour);
  void setColourBoardWx2(wxColour);
  void setColourBoardWx3(wxColour);
  void setColourBoardLx2(wxColour);
  void setColourBoardLx3(wxColour);
  void setColourBoardBackground(wxColour);
  void setColourBoardLetters(wxColour);
  void setColourBoardTestLetters(wxColour);
  
  wxColour getColourBoardLines();
  wxColour getColourBoardWx2();
  wxColour getColourBoardWx3();
  wxColour getColourBoardLx2();
  wxColour getColourBoardLx3();
  wxColour getColourBoardBackground();
  wxColour getColourBoardLetters();
  wxColour getColourBoardTestLetters();
  void setColourBoardDefault();
  
  wxPrintData getPrintData();
  void setPrintData(wxPrintData);
  wxPageSetupData getPageSetupData();
  void setPageSetupData(wxPageSetupData);
  
  wxSize getFrameDim(wxString);
  wxSize getMainFrameDim();
  void setFrameDim(wxString,wxSize);
  void setMainFrameDim(wxSize);
  
  void setJokerPlus1(bool);
  void setRackChecking(bool);
  bool getJokerPlus1();
  bool getRackChecking();

  float getPrintLineScale();
  void setPrintLineScale(float);
};

#endif

