/* Eliot                                                                     */
/* Copyright (C) 1999  Antoine Fraboulet                                     */
/* Antoine.Fraboulet@free.fr                                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* $Id: mainframe.cc,v 1.36 2000/12/21 16:22:59 antoine Exp $ */

//#include <iostream>
#include <stdlib.h>

#include "ewx.h"
#include "wx/event.h"
#include "wx/frame.h"
#include "wx/print.h"
#include "wx/menu.h"
#include "wx/statusbr.h"
#include "wx/sizer.h"
#include "wx/filedlg.h"
#include "wx/msgdlg.h"
#include "wx/generic/dcpsg.h"


#include "dic.h"
#include "game.h"


#include "configdb.h"
#include "auxframes.h"
#include "confdimdlg.h"
#include "confsearch.h"
#include "gfxboard.h"
#include "printout.h"
#include "mainframe.h"

enum
{
  Menu_Game_New,
  Menu_Game_Open,
  Menu_Game_Save,
  Menu_Game_Print,
  Menu_Game_PrintPreview,
  Menu_Game_PrintPS,

  Menu_Conf_Game,
  Menu_Conf_Game_Dic,
  Menu_Conf_Game_Search,

  Menu_Conf_Print,

  Menu_Conf_Aspect,
  Menu_Conf_Aspect_Font,
  Menu_Conf_Aspect_Font_Search,
  Menu_Conf_Aspect_Font_Board,
  Menu_Conf_Aspect_BoardColour,
  Menu_Conf_Aspect_BoardColour_Lines,
  Menu_Conf_Aspect_BoardColour_Wx2,
  Menu_Conf_Aspect_BoardColour_Wx3,
  Menu_Conf_Aspect_BoardColour_Lx2,
  Menu_Conf_Aspect_BoardColour_Lx3,
  Menu_Conf_Aspect_BoardColour_Background,
  Menu_Conf_Aspect_BoardColour_Letters,
  Menu_Conf_Aspect_BoardColour_TestLetters,
  Menu_Conf_Aspect_BoardColour_Default,

  Menu_Quit_Apropos,
  Menu_Quit_Confirm,

  Button_SetRack,
  Button_SetNew,
  Button_Search,
  Button_Play,
  Button_PlayBack,

  Menu_ShowVerif,
  Menu_ShowSearch,
  Menu_ShowPlus1,
  Menu_ShowRacc,
  Menu_ShowBenj,
  Menu_ShowBag,

  ListCtrl_ID,
  Rack_ID,
  Status_ID,
};




BEGIN_EVENT_TABLE(MainFrame, wxFrame)
  //
  EVT_MENU(Menu_Game_New,          MainFrame::OnMenuGameNew)
  EVT_MENU(Menu_Game_Open,         MainFrame::OnMenuGameOpen)
  EVT_MENU(Menu_Game_Save,         MainFrame::OnMenuGameSave)
  EVT_MENU(Menu_Game_Print,        MainFrame::OnMenuGamePrint)
  EVT_MENU(Menu_Game_PrintPreview, MainFrame::OnMenuGamePrintPreview)
  EVT_MENU(Menu_Game_PrintPS,      MainFrame::OnMenuGamePrintPS)
  //
  EVT_MENU(Menu_Conf_Game_Dic,     MainFrame::OnMenuConfGameDic)
  EVT_MENU(Menu_Conf_Game_Search,  MainFrame::OnMenuConfGameSearch)
  //
  EVT_MENU(Menu_Conf_Print,        MainFrame::OnMenuConfPrint)
  //
  EVT_MENU(Menu_Conf_Aspect_Font_Search,            MainFrame::OnMenuConfAspectFontSearch)
  EVT_MENU(Menu_Conf_Aspect_Font_Board,             MainFrame::OnMenuConfAspectFontBoard)
  EVT_MENU(Menu_Conf_Aspect_BoardColour_Lines,      MainFrame::OnMenuConfAspectBoardColourLines)
  EVT_MENU(Menu_Conf_Aspect_BoardColour_Wx2,        MainFrame::OnMenuConfAspectBoardColourWx2)
  EVT_MENU(Menu_Conf_Aspect_BoardColour_Wx3,        MainFrame::OnMenuConfAspectBoardColourWx3)
  EVT_MENU(Menu_Conf_Aspect_BoardColour_Lx2,        MainFrame::OnMenuConfAspectBoardColourLx2)
  EVT_MENU(Menu_Conf_Aspect_BoardColour_Lx3,        MainFrame::OnMenuConfAspectBoardColourLx3)
  EVT_MENU(Menu_Conf_Aspect_BoardColour_Background, MainFrame::OnMenuConfAspectBoardColourBackground)
  EVT_MENU(Menu_Conf_Aspect_BoardColour_Letters,    MainFrame::OnMenuConfAspectBoardColourLetters)
  EVT_MENU(Menu_Conf_Aspect_BoardColour_TestLetters,MainFrame::OnMenuConfAspectBoardColourTestLetters)
  EVT_MENU(Menu_Conf_Aspect_BoardColour_Default,    MainFrame::OnMenuConfAspectBoardColourDefault)
  //
  EVT_MENU(Menu_ShowBag,    MainFrame::OnShowBag)
  EVT_MENU(Menu_ShowSearch, MainFrame::OnShowSearch)
  EVT_MENU(Menu_ShowPlus1,  MainFrame::OnShowPlus1)
  EVT_MENU(Menu_ShowRacc,   MainFrame::OnShowRacc)
  EVT_MENU(Menu_ShowBenj,   MainFrame::OnShowBenj)
  EVT_MENU(Menu_ShowVerif,  MainFrame::OnShowVerif)
  //
  EVT_MENU(Menu_Quit_Apropos, MainFrame::OnMenuQuitApropos)
  EVT_MENU(Menu_Quit_Confirm, MainFrame::OnMenuQuitConfirm)
  //
  EVT_BUTTON(Button_Play,     MainFrame::OnPlay)
  EVT_BUTTON(Button_SetRack,  MainFrame::OnSetRack)
  EVT_BUTTON(Button_SetNew,   MainFrame::OnSetNew)
  EVT_BUTTON(Button_Search,   MainFrame::OnSearch)
  EVT_BUTTON(Button_PlayBack, MainFrame::OnPlayBack)
  //
  EVT_TEXT_ENTER(Rack_ID, MainFrame::OnRackEnter)
  //
  EVT_LIST_ITEM_SELECTED  (ListCtrl_ID, MainFrame::OnListCtrlSelected)
  EVT_LIST_ITEM_ACTIVATED (ListCtrl_ID, MainFrame::OnListCtrlActivated)
  //
  EVT_SIZE(MainFrame::OnSize)
  EVT_CLOSE(MainFrame::OnCloseWindow)
  EVT_SYS_COLOUR_CHANGED(MainFrame::CorrectColours) 
  //
END_EVENT_TABLE()





MainFrame::MainFrame(wxSize size_)
    : wxFrame((wxFrame *) NULL, -1, "Eliot", wxPoint(-1,-1),
	      size_, wxDEFAULT_FRAME_STYLE, wxString("Eliot"))
{
  wxSysColourChangedEvent event;
  CorrectColours(event);

  wxString dicpath;
  Dictionary dic = NULL;  
  dicpath = config.getDicPath();
  Dic_load(&dic, (const char*)dicpath);
  game = Game_create(dic);

  showbag    = 0;
  showsearch = 0;
  showplus1  = 0;
  showracc   = 0;
  showbenj   = 0;
  showverif  = 0;

  bagframe    = NULL;
  searchframe = NULL;
  plus1frame  = NULL;
  raccframe   = NULL;
  benjframe   = NULL;
  verifframe  = NULL;

  // menus
  wxMenu *menu_game = new wxMenu;
  menu_game->Append(Menu_Game_New,"Nouvelle","Dmarrer une nouvelle partie");
  menu_game->Append(Menu_Game_Open,"Charge","Charger une partie");
  menu_game->Append(Menu_Game_Save,"Sauver","Sauver cette partie");
  menu_game->AppendSeparator();
  menu_game->Append(Menu_Game_Print,"Imprimer","Imprimer cette partie");
  menu_game->Append(Menu_Game_PrintPreview,"Primpression","Primpression de la partie");
#ifdef ENABLE_SAVE_POSTSCRIPT
  menu_game->AppendSeparator();
  menu_game->Append(Menu_Game_PrintPS,"Imprimer du PostScript","Imprimer dans un fichier PostScript");
#endif

  wxMenu *menu_conf_game = new wxMenu;
  menu_conf_game->Append(Menu_Conf_Game_Dic,"Dictionnaire","Choix du dictionnaire");
  menu_conf_game->Append(Menu_Conf_Game_Search,"Recherche","Options de recherches");

  wxMenu *menu_conf_board_colour = new wxMenu;
  menu_conf_board_colour->Append(Menu_Conf_Aspect_BoardColour_Background,"Fond","Couleur du fond");
  menu_conf_board_colour->Append(Menu_Conf_Aspect_BoardColour_Lines,"Lignes","Couleurs des lignes");
  menu_conf_board_colour->AppendSeparator();
  menu_conf_board_colour->Append(Menu_Conf_Aspect_BoardColour_Letters,"Lettres joues","lettres joues sur la grille");
  menu_conf_board_colour->Append(Menu_Conf_Aspect_BoardColour_TestLetters,"Lettres provisoires","lettre du mot  jouer");
  menu_conf_board_colour->AppendSeparator();
  menu_conf_board_colour->Append(Menu_Conf_Aspect_BoardColour_Wx2,"Mot compte double","Mot compte double");
  menu_conf_board_colour->Append(Menu_Conf_Aspect_BoardColour_Wx3,"Mot compte triple","Mot compte triple");
  menu_conf_board_colour->Append(Menu_Conf_Aspect_BoardColour_Lx2,"Lettre compte double","Lettre compte double");
  menu_conf_board_colour->Append(Menu_Conf_Aspect_BoardColour_Lx3,"Lettre compte triple","Lettre compte triple");
  menu_conf_board_colour->AppendSeparator();
  menu_conf_board_colour->Append(Menu_Conf_Aspect_BoardColour_Default,"Couleurs d'origine","Retrouver les couleurs d'origine");


  wxMenu *menu_conf_board_font = new wxMenu;
  menu_conf_board_font->Append(Menu_Conf_Aspect_Font_Search,"Lettres de recherche","Police de caractre pour les recherches");
  menu_conf_board_font->Append(Menu_Conf_Aspect_Font_Board,"Lettres de la grille","Police de caractre de la grille");


  wxMenu *menu_conf = new wxMenu;
  menu_conf->Append(Menu_Conf_Game,"Jeux",menu_conf_game,"Configuration du jeux");
  menu_conf->Append(Menu_Conf_Aspect_Font,"Fonte des lettres",menu_conf_board_font,"Modification des fontes");
  menu_conf->Append(Menu_Conf_Aspect_BoardColour,"Couleurs de la grille",menu_conf_board_colour,"Modification des couleurs");
  menu_conf->Append(Menu_Conf_Print,"Impression","Dimensions de la partie");

  wxMenu *menu_frame = new wxMenu;
  menu_frame->Append(Menu_ShowVerif,"Vrification","Vrification d'un mot dans le dictionnaire");
#ifdef ENABLE_SEARCHEX
  menu_frame->Append(Menu_ShowSearch,"Recherche","Recherche dans le dictionnaire");
#endif
  menu_frame->AppendSeparator();
  menu_frame->Append(Menu_ShowPlus1,"Tirage + 1","Lettres du tirage plus une");
  menu_frame->Append(Menu_ShowRacc,"Raccords","Raccords sur un mot de la recherche");
  menu_frame->Append(Menu_ShowBenj,"Benjamins","Benjamins sur un mot de la recherche");
  menu_frame->AppendSeparator();
  menu_frame->Append(Menu_ShowBag,"Sac","Lettres restantes dans le sac");

  wxMenu *menu_quit = new wxMenu;
  menu_quit->Append(Menu_Quit_Apropos,"A propos","A propos d'Eliot");
  menu_quit->Append(Menu_Quit_Confirm,"Quitter","Quitter");

  wxMenuBar *menu_bar = new wxMenuBar;
  menu_bar->Append(menu_game,"Partie");
  menu_bar->Append(menu_conf,"Configurer");
  menu_bar->Append(menu_frame,"Fentres");
  menu_bar->Append(menu_quit,"Quitter");

  SetMenuBar(menu_bar);
  statusbar = CreateStatusBar(2,0,Status_ID);
  int ww[2] = {-1, 160};
  statusbar->SetStatusWidths(2,ww);
  UpdateStatusBar();

  // board
  board = new GfxBoard(game,this);

  rack = new wxTextCtrl(this,Rack_ID,wxString(""),wxPoint(-1,-1),wxSize(-1,-1),wxTE_PROCESS_ENTER);
  rack->SetToolTip("Tirage courant");

  results = new wxListCtrl(this,ListCtrl_ID);
#if defined(__WIN32__)
  results->SetSingleStyle(wxLC_REPORT | wxLC_NO_HEADER | wxLC_SINGLE_SEL);
#else
  results->SetSingleStyle(wxLC_REPORT | wxLC_SINGLE_SEL);
#endif
  results->InsertColumn(0,"");
  results->InsertColumn(1,"");
  results->InsertColumn(2,"");
  results->InsertColumn(3,"");
  results->InsertColumn(4,"");
  
  results->SetToolTip("Rsultats de la recherche courante");

  b_rackrandomset = new wxButton(this,Button_SetRack," Tirage ");
  b_rackrandomset->SetToolTip("Tirage alatoire");

  b_rackrandomnew = new wxButton(this,Button_SetNew," Complment ");
  b_rackrandomnew->SetToolTip("Complment alatoire du tirage");

  b_search = new wxButton(this,Button_Search," Rechercher ");
  b_search->SetToolTip("Recherche sur le tirage courant");

  b_back = new wxButton(this,Button_PlayBack," Arrire ");
  b_back->SetToolTip("Revenir un coup en arrire");

  b_play = new wxButton(this,Button_Play," Jouer ");
  b_play->SetToolTip("Jouer le mot slectionn");


  wxBoxSizer *buttonsizer = new wxBoxSizer(wxHORIZONTAL);
  buttonsizer->Add(b_rackrandomset, 0, wxLEFT, 2);
  buttonsizer->Add(b_rackrandomnew, 0, 0, 0);
  buttonsizer->Add(b_search, 0, 0, 0);
  buttonsizer->Add(b_back, 0, 0, 0);
  buttonsizer->Add(b_play, 0, 0, 0);

  wxBoxSizer *listsizer = new wxBoxSizer(wxVERTICAL);
  listsizer->Add(rack, 0, wxEXPAND | wxRIGHT, 1);
  listsizer->Add(results, 1, wxEXPAND | wxTOP | wxRIGHT, 1);

  wxBoxSizer *boardsizer = new wxBoxSizer(wxHORIZONTAL);
  boardsizer->Add(board, 2, wxSHAPED | wxLEFT | wxTOP, 2);
  boardsizer->Add(listsizer, 1, wxEXPAND | wxRIGHT | wxTOP, 2);

  wxBoxSizer *topsizer = new wxBoxSizer(wxVERTICAL);
  topsizer->Add(boardsizer, 1, wxEXPAND | wxALL, 1);
  topsizer->Add(buttonsizer, 0, wxALIGN_LEFT | wxALL, 1);

  SetAutoLayout(TRUE);
  SetSizer(topsizer);
  topsizer->Fit(this);
  topsizer->SetSizeHints(this);

  SetClientSize(size_);
}



void
MainFrame::OnSize(wxSizeEvent& e)
{
  wxFrame::OnSize(e);
  config.setMainFrameDim(GetClientSize());
}



MainFrame::~MainFrame()
{
  Dictionary dic;
  if ((dic = Game_getdic(game)) != NULL) 
    {
      Dic_destroy(dic);
    }
  Game_destroy(game);
}



void
MainFrame::CorrectColours(wxSysColourChangedEvent& WXUNUSED(event))
{
#ifdef ENABLE_MSW_BACKGROUND
  wxColour back = GetBackgroundColour();
  wxColour sysback = wxSystemSettings::GetSystemColour(wxSYS_COLOUR_WINDOW);
  wxColour newback = wxSystemSettings::GetSystemColour(wxSYS_COLOUR_MENU);
  SetBackgroundColour(newback);
#endif
}


void
MainFrame::OnCloseWindow(wxCloseEvent&)
{
  this->Destroy();
}


void
MainFrame::UpdateStatusBar()
{
  wxString text;
  if (Game_getdic(game) == NULL) 
    {
      statusbar->SetStatusText("Pas de dictionnaire",0);
    } 
  else 
    {
      statusbar->SetStatusText(config.getDicName(),0);
    }
  text = "";
  text << "coup:" << (Game_getnrounds(game) + 1)
       << "\t" << "points:" << Game_getpoints(game);
  statusbar->SetStatusText(text,1);
}




//**************************************************************************************
//   MENU GAME
//**************************************************************************************

void
MainFrame::OnMenuGameNew(wxCommandEvent&)
{
  Game_init(game);
  board->Refresh();
  rack->SetValue(wxString(""));
  results->DeleteAllItems();
  UpdateStatusBar();
  UpdateShowBag();
  UpdateShowPlus1();
  UpdateShowRacc();
  UpdateShowBenj();
}

void
MainFrame::OnMenuGameOpen(wxCommandEvent&)
{
  wxString txt;
  wxFileDialog dialog(this,"Ouvrir une partie", "","","*",wxOPEN);
  if (Game_getdic(game) == NULL) {
    wxMessageBox("Il n'y a pas de dictionnaire slectionn", "Eliot: erreur",
		 wxICON_INFORMATION | wxOK);
    return;
  } 
  if (dialog.ShowModal() == wxID_OK)
    {
      FILE* fin;
      if ((fin = fopen((const char*)dialog.GetPath(),"r")) == NULL) 
	{
	  txt << "Impossible de d'ouvrir" << dialog.GetPath();
	  wxMessageDialog msg(this, txt, "Ouverture d'une partie");
	  msg.ShowModal();
	  return ;
	}
      Game_init(game);
      switch (Game_load(game,fin)) {
      case 0: // everything went ok
	break;
      case 1: 
	{ 
	  wxMessageDialog msg(this,"Format de fichier inconnu","chargement de partie");
	  msg.ShowModal(); 
	}
	break; 
      default: 
	{ 
	  wxMessageDialog msg(this,"Erreur pendant la lecture de la partie","chargement de partie");
	  msg.ShowModal(); 
	}
	break; 
      }
      fclose(fin);
    }
  board->Refresh();
  char r[RACK_SIZE_MAX];
  Game_getplayedrack(game,Game_getnrounds(game),r);
  rack->SetValue(wxString(r));

  results->DeleteAllItems();
  UpdateStatusBar();
  UpdateShowBag();
  UpdateShowPlus1();
  UpdateShowRacc();
  UpdateShowBenj();
}

void
MainFrame::OnMenuGameSave(wxCommandEvent&)
{
  wxString txt;
  wxFileDialog dialog(this, "Sauver une partie", "", "", "*",wxSAVE|wxOVERWRITE_PROMPT);
  if (dialog.ShowModal() == wxID_OK)
    {
      FILE* fout;
      if ((fout = fopen((const char*)dialog.GetPath(),"w")) == NULL) 
	{
	  txt << "Impossible de crer " << dialog.GetPath();
	  wxMessageDialog msg(this, txt, "Sauvegarde de la partie");
	  msg.ShowModal();
	  return ; 
	}
      Game_save(game,fout);
      fclose(fout);
    }
}

void
MainFrame::OnMenuGamePrint(wxCommandEvent&)
{
  wxPrintDialogData printDialogData(config.getPrintData());
  wxPrinter printer(&printDialogData);
  GamePrintout printout(game);
  if (!printer.Print(this,&printout,TRUE))
    wxMessageBox("Impression non effectue.");
}





void
MainFrame::OnMenuGamePrintPreview(wxCommandEvent&)
{
  wxPrintData printdata = config.getPrintData();

  wxString msg;
  wxPrintPreview *preview = new wxPrintPreview(new GamePrintout(game),
                                               new GamePrintout(game), & printdata);
  if (!preview->Ok())
    {
      delete preview;
      msg << "Problme de prvisualisation.\n"
	  << "Il se peut que l'imprimante par dfaut soit mal initialise";
      wxMessageBox(msg,"Impression (prvisualisation)", wxOK);
      return;
    }
  wxPreviewFrame *frame = new wxPreviewFrame(preview, this, "Impression",
					     wxPoint(-1, -1), wxSize(600, 550));
  frame->Centre(wxBOTH);
  frame->Initialize();
  frame->Show(TRUE);
}

void
MainFrame::OnMenuGamePrintPS(wxCommandEvent&)
{
#ifdef ENABLE_SAVE_POSTSCRIPT
  wxString txt;
  wxFileDialog dialog(this, "Imprimer dans un fichier PostScript", "", "", "*.ps",wxSAVE|wxOVERWRITE_PROMPT);
  if (dialog.ShowModal() == wxID_OK)
    {
      wxPostScriptDC printps(dialog.GetPath(),FALSE,this);
      if (printps.Ok())
	{
	  wxPrintData printdataPS;
	  printdataPS.SetPrintMode(wxPRINT_MODE_FILE);
	  printdataPS.SetFilename(dialog.GetPath());
	  printdataPS.SetPaperId(wxPAPER_A4);
	  printdataPS.SetQuality(wxPRINT_QUALITY_HIGH);
	  printdataPS.SetOrientation(wxPORTRAIT);

	  wxPrintDialogData printDialogData(printdataPS);
	  wxPostScriptPrinter printer(&printDialogData);
	  GamePrintout printout(game);
	  if (!printer.Print(this,&printout,FALSE))
	    {
	      wxMessageBox("Impression non effectue.");
	    }
	  else
	    {
	      wxString msg;
	      msg << "Dessin effectu dans " << dialog.GetPath() << "\n";
	      wxMessageBox(msg,"Sauvegarde PostScript", wxOK);
	    }
	}
      else
	{
	  wxString msg;
	  msg << "impossible d'initialiser le traitement PostScript.\n";
	  wxMessageBox(msg,"Sauvegarde PostScript", wxOK);
	}
    }
#endif
}

//**************************************************************************************
//   MENU CONFIG
//**************************************************************************************

void
MainFrame::OnMenuConfGameDic(wxCommandEvent&)
{
  wxString txt,msg,dicpath;
  Dictionary dic,dicold;
  wxFileDialog dialog(this,"Choisir un dictionnaire", "","*.dawg","*.dawg",wxOPEN);
  if (dialog.ShowModal() == wxID_OK)
    {
      wxString dicpath = dialog.GetPath();
      switch (Dic_load(&dic,(const char*)dicpath)) {
      case 0:
	/* cas normal */
	if ((dicold = Game_getdic(game)) != NULL)
	  Dic_destroy(dicold);
	Game_setdic(game,dic);
	config.setDicPath(dialog.GetPath(),::wxFileNameFromPath(dialog.GetPath()));
	break;
      case 1: 
	msg << "chargement: problme d'ouverture de " << dicpath << "\n";
	{ wxMessageDialog dlg(NULL,msg,APPNAME); dlg.ShowModal(); }
	break;
      case 2:
	msg << "chargement: mauvais en-tete de dictionnaire\n";
	{ wxMessageDialog dlg(NULL,msg,APPNAME); dlg.ShowModal(); }
	break;
      case 3:
	msg << "chargement: problme 3 d'allocation mmoire\n";
	{ wxMessageDialog dlg(NULL,msg,APPNAME); dlg.ShowModal(); }
	break;
      case 4:
	msg << "chargement: problme 4 d'alocation mmoire\n";
	{ wxMessageDialog dlg(NULL,msg,APPNAME); dlg.ShowModal(); }
	break;
      case 5:
	msg << "chargement: problme de lecture des arcs du dictionnaire\n";
	{ wxMessageDialog dlg(NULL,msg,APPNAME); dlg.ShowModal(); }
	break;
      default:
	msg << "chargement: problme non-repertori\n";
	{ wxMessageDialog dlg(NULL,msg,APPNAME); dlg.ShowModal(); }
	break;
      }
    }
     
  UpdateStatusBar();
}



void
MainFrame::OnMenuConfGameSearch(wxCommandEvent&)
{
  ConfSearchDlg dlg(this);
  dlg.ShowModal();
}




// ****************
// MENU CONF PRINT
// ****************

void
MainFrame::OnMenuConfPrint(wxCommandEvent&)
{
  ConfDimDlg dlg(this, config.getPrintData(), config.getPageSetupData());
  if (dlg.ShowModal() == wxID_OK)
    {
      config.setPrintData(dlg.getPrintData());
      config.setPageSetupData(dlg.getPageSetupData());
    }
}




// ****************
// MENU CONF FONTS
// ****************

void
MainFrame::OnMenuConfAspectFontSearch(wxCommandEvent&)
{
  config.setFontSearch(config.ChooseFont(this,config.getFontSearch()));
}




void
MainFrame::OnMenuConfAspectFontBoard(wxCommandEvent&)
{
  config.setFontBoard(config.ChooseFont(this,config.getFontBoard()));
  board->Refresh(1);
}

// ************************
// MENU CONF BOARD COLOURS
// ************************


void
MainFrame::OnMenuConfAspectBoardColourLines(wxCommandEvent&)
{
  config.setColourBoardLines(config.ChooseColour(this,config.getColourBoardLines()));
  board->Refresh(1);
}

void
MainFrame::OnMenuConfAspectBoardColourWx2(wxCommandEvent&)
{
  config.setColourBoardWx2(config.ChooseColour(this,config.getColourBoardWx2()));
  board->Refresh(1);
}

void
MainFrame::OnMenuConfAspectBoardColourWx3(wxCommandEvent&)
{
  config.setColourBoardWx3(config.ChooseColour(this,config.getColourBoardWx3()));
  board->Refresh(1);
}

void
MainFrame::OnMenuConfAspectBoardColourLx2(wxCommandEvent&)
{
  config.setColourBoardLx2(config.ChooseColour(this,config.getColourBoardLx2()));
  board->Refresh(1);
}

void
MainFrame::OnMenuConfAspectBoardColourLx3(wxCommandEvent&)
{
  config.setColourBoardLx3(config.ChooseColour(this,config.getColourBoardLx3()));
  board->Refresh(1);
}

void
MainFrame::OnMenuConfAspectBoardColourBackground(wxCommandEvent&)
{
  config.setColourBoardBackground(config.ChooseColour(this,config.getColourBoardBackground()));
  board->Refresh(1);
}

void
MainFrame::OnMenuConfAspectBoardColourLetters(wxCommandEvent&)
{
  config.setColourBoardLetters(config.ChooseColour(this,config.getColourBoardLetters()));
  board->Refresh(1);
}

void
MainFrame::OnMenuConfAspectBoardColourTestLetters(wxCommandEvent&)
{
  config.setColourBoardTestLetters(config.ChooseColour(this,config.getColourBoardTestLetters()));
  board->Refresh(1);
}

void
MainFrame::OnMenuConfAspectBoardColourDefault(wxCommandEvent&)
{
  config.setColourBoardDefault();
  board->Refresh(1);
}


//**************************************************************************************
//   MENU QUIT
//**************************************************************************************

void
MainFrame::OnMenuQuitApropos(wxCommandEvent&)
{
  wxString msg;

  msg << "Eliot\n Antoine Fraboulet 1999-2000\n\n";
  msg << "This program is free software; you can redistribute it and/or modify\n";
  msg << "it under the terms of the GNU General Public License as published by\n";
  msg << "the Free Software Foundation; either version 2 of the License, or\n";
  msg << "(at your option) any later version.\n\n";
  msg << "Version " << VERSION << "\n";

  wxMessageBox(msg, "A propos d'Eliot", wxICON_INFORMATION | wxOK);
}

void
MainFrame::OnMenuQuitConfirm(wxCommandEvent&)
{
  Close(TRUE);
}


//**************************************************************************************
// BUTTONS
//**************************************************************************************

#define SETRACK_END                                 \
  Game_getplayedrack(game,Game_getnrounds(game),r); \
  rack->SetFont(config.getFontSearch());            \
  rack->SetValue(wxString(r));                      \
  Game_removetestplay(game);                        \
  board->Refresh();                                 \
  results->DeleteAllItems();                        \
  UpdateShowPlus1();                                \
  UpdateShowRacc();                                 \
  UpdateShowBenj();                                 \


void
MainFrame::OnSetRack(wxCommandEvent&)
{
  int res,check;
  char r[RACK_SIZE_MAX];
  check = config.getRackChecking();
  while ((res = (Game_setrack_random(game,check,RACK_ALL))) == 2)
    ;
  if (res == 1)
    {
      statusbar->SetStatusText("Le sac est vide",0);
    }
  SETRACK_END
}

void
MainFrame::OnSetNew(wxCommandEvent& event)
{
  int res,check;
  char oldr[RACK_SIZE_MAX];
  char r[RACK_SIZE_MAX];
  check = config.getRackChecking();
  Game_getplayedrack(game,Game_getnrounds(game),oldr);
  while ((res = Game_setrack_random(game,check,RACK_NEW)) == 2)
    ;
  if (res == 1)
    {
      statusbar->SetStatusText("Le sac est vide",0);
    }
  if (res == 3)
    {
      statusbar->SetStatusText("Le tirage ne peut tre complt",0);
    }

  Game_getplayedrack(game,Game_getnrounds(game),r);
  if (strcmp(oldr,r) == 0)
    {
      // if the rack is unchanged, then we do 
      // not update the search list.
    }
  else
    {
      // the rack has changed
      SETRACK_END
    }
}

void
MainFrame::Search()
{
  int i;
  char r[RACK_SIZE_MAX];

  if (Game_getdic(game) == NULL)
    {
      wxMessageBox("Il n'y a pas de dictionnaire slectionn", "Eliot: erreur",wxICON_INFORMATION | wxOK);
      return;
    }

  switch (Game_setrack_manual(game,config.getRackChecking(),
			      (const char*)rack->GetValue()))
    {
    case 1:
      statusbar->SetStatusText("Le sac ne contient pas assez de lettres",0);
      return;
    case 2:
      if (Game_getnrounds(game) < 15)
        statusbar->SetStatusText("Le tirage doit contenir au moins 2 consonnes et 2 voyelles",0);
      else
        statusbar->SetStatusText("Le tirage doit contenir au moins 1 consonne et 1 voyelle",0);
      return;
    default:
      break;
    }

  Game_removetestplay(game);
  Game_getplayedrack(game,Game_getnrounds(game),r);
  rack->SetValue(wxString(r));

  Game_search(game);

  // to speed up inserting we hide the control temporarily
  // but this is not good on slow machines as it shows an empty
  // square instead of the list
  //results->Hide();
  results->DeleteAllItems();
  results->SetFont(config.getFontSearch());

  for(i=0; i < Game_getnresults(game); i++)
    {
      wxChar word[WORD_SIZE_MAX];
      wxChar bonus;
      wxChar coord1[3];
      wxChar coord2[3];
      wxChar pts[5];

      Game_getsearchedword(game,i,word);
      Game_getsearchedfirstcoord(game,i,coord1);
      Game_getsearchedsecondcoord(game,i,coord2);
      bonus = Game_getsearchedbonus(game,i) ? '*' : ' ';
      sprintf(pts,"%d",Game_getsearchedpoints(game,i));

      long tmp = results->InsertItem(i,word);
      results->SetItemData(tmp,i);
      tmp = results->SetItem(i,1,bonus);
      tmp = results->SetItem(i,2,coord1);
      tmp = results->SetItem(i,3,coord2);
      tmp = results->SetItem(i,4,pts);
    }

  for(int i=0; i < 5; i++)
    results->SetColumnWidth( i, wxLIST_AUTOSIZE );

  results->Show();
 
  if (Game_getnresults(game))
    {
      results->SetItemState(0,wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED | wxLIST_MASK_STATE);
      Game_testplay(game,0);
    }
  
  board->Refresh();
  UpdateStatusBar();
  UpdateShowRacc();
  UpdateShowBenj();
}

void
MainFrame::OnSearch(wxCommandEvent&)
{
  Search();
}

void
MainFrame::OnRackEnter(wxCommandEvent&)
{
  Search();
  UpdateShowPlus1();
}

#define PLAY_END                                    \
  Game_getplayedrack(game,Game_getnrounds(game),r); \
  rack->SetFont(config.getFontSearch());            \
  rack->SetValue(wxString(r));                      \
  results->DeleteAllItems();                        \
  board->Refresh();                                 \
  UpdateStatusBar();                                \
  UpdateShowBag();                                  \
  UpdateShowPlus1();                                \
  UpdateShowRacc();                                 \
  UpdateShowBenj();                                 \
 

void
MainFrame::OnPlayBack(wxCommandEvent&)
{
  char r[RACK_SIZE_MAX];
  Game_removetestplay(game);                        
  Game_back(game,1);
  PLAY_END
}

void
MainFrame::Play(int n)
{
  char r[RACK_SIZE_MAX];
  Game_removetestplay(game);
  Game_play(game,n);
  PLAY_END
}

void
MainFrame::OnPlay(wxCommandEvent&)
{
  long item = -1;
  item = results->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
  if ( item == -1 )
    return;
  Play(item);
}


void
MainFrame::OnListCtrlSelected(wxListEvent& event)
{
  UpdateShowRacc();
  UpdateShowBenj();
  Game_removetestplay(game);
  Game_testplay(game,event.m_itemIndex);
  board->Refresh();
}

void
MainFrame::OnListCtrlActivated(wxListEvent& event)
{
  if (event.m_itemIndex > -1)
    Play(event.m_itemIndex);
}


//*********************************
// SPECIAL FRAMES
//*********************************

void
MainFrame::OnShowBag(wxCommandEvent&)
{
  if (showbag == 0) 
    {
      if (bagframe == NULL) 
	{
	  bagframe = new BagFrame(this,game);
	}
      bagframe->Show(TRUE);
      showbag = 1;
    }
  else
    {
      bagframe->Show(FALSE);
      showbag = 0;
    }
}

void
MainFrame::OnShowPlus1(wxCommandEvent&)
{
  if (showplus1 == 0)
    {
      if (plus1frame == NULL)
	{
	  plus1frame = new Plus1Frame(this,game);
	}
      plus1frame->Show(TRUE);
      showplus1 = 1;
      UpdateShowPlus1();
    } 
  else
    {
      plus1frame->Show(FALSE);
      showplus1 = 0;
    }
}

void
MainFrame::OnShowSearch(wxCommandEvent&)
{
  if (showsearch == 0) 
    {
      if (searchframe == NULL)
	{
	  searchframe = new SearchFrame(this,game);
	}
      searchframe->Show(TRUE);
      showsearch = 1;
    } 
  else
    {
      searchframe->Show(FALSE);
      showsearch = 0;
    }
}

void
MainFrame::OnShowRacc(wxCommandEvent&)
{
  if (showracc == 0) 
    {
      if (raccframe == NULL)
	{
	  raccframe = new RaccFrame(this,game);
	}
      raccframe->Show(TRUE);
      showracc = 1;
      UpdateShowRacc();
    }
  else
    {
      raccframe->Show(FALSE);
      showracc = 0;
    }
}

void
MainFrame::OnShowBenj(wxCommandEvent&)
{
  if (showbenj == 0) 
    {
      if (benjframe == NULL)
	{
	  benjframe = new BenjFrame(this,game);
	}
      benjframe->Show(TRUE);
      showbenj = 1;
      UpdateShowBenj();
    } 
  else
    {
      benjframe->Show(FALSE);
      showbenj = 0;
    }
}

void
MainFrame::OnShowVerif(wxCommandEvent&)
{
  if (showverif == 0) 
    {
      if (verifframe == NULL)
	{
	  verifframe = new VerifFrame(this,game);
	}
      verifframe->Show(TRUE);
      showverif = 1;
    } 
  else
    {
      verifframe->Show(FALSE);
      showverif = 0;
    }
}

//*******************************************************
// VISUAL UPDATES
//*******************************************************

void
MainFrame::UpdateShowBag()
{
  if (bagframe && showbag) 
    {
      bagframe->Refresh();
    }
}

void
MainFrame::UpdateShowPlus1()
{
  if (plus1frame && showplus1) 
    {
      plus1frame->RefreshList(0);
    }
}

void
MainFrame::UpdateShowRacc()
{
  if (raccframe && showracc) 
    {
      long item = -1;
      item = results->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
      // item can be -1
      raccframe->RefreshList(item);
    }
}

void
MainFrame::UpdateShowBenj()
{
  if (benjframe && showbenj) 
    {
      long item = -1;
      item = results->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
      // item can be -1
      benjframe->RefreshList(item);
    }
}

//***************************************
// KILLED FRAMES MESSAGE
//***************************************

void
MainFrame::KilledShowAux(int id)
{
  switch (id) {
  case ID_Frame_Verif:
    showverif = 0;
    verifframe = NULL;
    break;
  case ID_Frame_Search:
    showsearch = 0;
    searchframe = NULL;
    break;
  case ID_Frame_Plus1:
    showplus1 = 0;
    plus1frame = NULL;
    break;
  case ID_Frame_Benj:
    showbenj = 0;
    benjframe = NULL;
    break;
  case ID_Frame_Racc:
    showracc = 0;
    raccframe = NULL;
    break;
  case ID_Frame_Bag:
    showbag = 0;
    bagframe = NULL;
    break;
  }
}

//********************************************
//********************************************
