/* Eliot                                                                     */
/* Copyright (C) 1999  Antoine Fraboulet                                     */
/* Antoine.Fraboulet@free.fr                                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* $Id: mainframe.h,v 1.24 2000/12/12 01:50:40 antoine Exp $ */

// -*- C++ -*-
#ifndef _MAINFRAME_H
#define _MAINFRAME_H

#include "dic.h"
#include "game.h"

#include "gfxboard.h"
#include "auxframes.h"


class MainFrame: public wxFrame
{
private:

  Game            game;
  GfxBoard        *board;
  ConfigDB        config;

  //  wxPrintData     printdata;
  //  wxPageSetupData pagesetupdata;

  int showverif;
  int showsearch;
  int showplus1;
  int showracc;
  int showbenj;
  int showbag;

  VerifFrame  *verifframe;
  SearchFrame *searchframe;
  Plus1Frame  *plus1frame;
  RaccFrame   *raccframe;
  BenjFrame   *benjframe;
  BagFrame    *bagframe;

  wxTextCtrl *rack;
  wxListCtrl *results;

  wxButton  *b_play;
  wxButton  *b_rackrandomset;
  wxButton  *b_rackrandomnew;
  wxButton  *b_search;
  wxButton  *b_back;

  wxStatusBar *statusbar;

  void DrawFrame();
  void OnSize(wxSizeEvent&);
  void CorrectColours(wxSysColourChangedEvent&);

  void Play(int);
  void Search();
  void UpdateStatusBar();
  void UpdateShowBag();
  void UpdateShowPlus1();
  void UpdateShowRacc();
  void UpdateShowBenj();
     
public:
  MainFrame(wxSize);
  virtual ~MainFrame();

  // *****
  // Menus
  // *****
  void OnMenuGameNew          (wxCommandEvent& event);
  void OnMenuGameOpen         (wxCommandEvent& event);
  void OnMenuGameSave         (wxCommandEvent& event);
  void OnMenuGamePrint        (wxCommandEvent& event);
  void OnMenuGamePrintPreview (wxCommandEvent& event);
  void OnMenuGamePrintPS      (wxCommandEvent& event);

  void OnMenuConfGameDic      (wxCommandEvent& event);
  void OnMenuConfGameSearch   (wxCommandEvent& event);

  void OnMenuConfPrint        (wxCommandEvent& event);

  void OnMenuConfAspectFontSearch      (wxCommandEvent& event);
  void OnMenuConfAspectFontBoard       (wxCommandEvent& event);
  void OnMenuConfAspectBoardColourLines(wxCommandEvent& event);
  void OnMenuConfAspectBoardColourWx2  (wxCommandEvent& event);
  void OnMenuConfAspectBoardColourWx3  (wxCommandEvent& event);
  void OnMenuConfAspectBoardColourLx2  (wxCommandEvent& event);
  void OnMenuConfAspectBoardColourLx3  (wxCommandEvent& event);
  void OnMenuConfAspectBoardColourBackground (wxCommandEvent& event);
  void OnMenuConfAspectBoardColourLetters    (wxCommandEvent& event);
  void OnMenuConfAspectBoardColourDefault    (wxCommandEvent& event);
  void OnMenuConfAspectBoardColourTestLetters(wxCommandEvent& event);
  void OnMenuQuitApropos  (wxCommandEvent& event);
  void OnMenuQuitConfirm  (wxCommandEvent& event);

  // *******
  // Buttons
  // *******
  void OnPlay     (wxCommandEvent& event);
  void OnSetRack  (wxCommandEvent& event);
  void OnSetNew   (wxCommandEvent& event);
  void OnSearch   (wxCommandEvent& event);
  void OnPlayBack (wxCommandEvent& event);

  void OnShowBag   (wxCommandEvent& event);
  void OnShowSearch(wxCommandEvent& event);
  void OnShowPlus1 (wxCommandEvent& event);
  void OnShowRacc  (wxCommandEvent& event);
  void OnShowBenj  (wxCommandEvent& event);
  void OnShowVerif (wxCommandEvent& event);

  void OnRackEnter(wxCommandEvent& event);

  void OnListCtrlSelected (wxListEvent& event);
  void OnListCtrlActivated(wxListEvent& event);

  void KilledShowAux(int);
  void OnCloseWindow  (wxCloseEvent& event);

  DECLARE_EVENT_TABLE()
};

#endif
