/* Eliot                                                                     */
/* Copyright (C) 1999  Antoine Fraboulet                                     */
/* Antoine.Fraboulet@free.fr                                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* $Id: searchpanel.cc,v 1.3 2000/12/12 01:50:40 antoine Exp $ */

#include <string.h>
#include "ewx.h"
#include "dic.h"
#include "dic_search.h"
#include "searchpanel.h"
#include "configdb.h"

enum {
  ID_PANEL_CROSS,
  ID_PANEL_PLUS1,

  ID_LIST,
  ID_TEXT
};

class SimpleSearchPanel : public wxPanel
{
protected:
  ConfigDB config;
  Dictionary dic_;
  wxTextCtrl* t;
  wxListBox* l;
  int check();
public:
  SimpleSearchPanel(wxWindow* parent, int id, Dictionary dic);
  virtual void compute_char(wxCommandEvent&) {};
  virtual void compute_enter(wxCommandEvent&) {};
  DECLARE_EVENT_TABLE()
};

BEGIN_EVENT_TABLE(SimpleSearchPanel, wxPanel)
  EVT_TEXT      (ID_TEXT, SimpleSearchPanel::compute_char)
  EVT_TEXT_ENTER(ID_TEXT, SimpleSearchPanel::compute_enter)
END_EVENT_TABLE()

SimpleSearchPanel::SimpleSearchPanel(wxWindow* parent, int id, Dictionary dic) 
  : wxPanel(parent,id)
{
  dic_ = dic;

  t = new wxTextCtrl(this,ID_TEXT,"",wxPoint(0,0),wxSize(-1,-1),wxTE_PROCESS_ENTER);
  t->SetFont(config.getFontSearch());
  l = new wxListBox(this,ID_LIST);
  l->SetFont(config.getFontSearch());
  l->Show(TRUE);

  wxBoxSizer *sizer = new wxBoxSizer( wxVERTICAL );
  sizer->Add(t, 0, wxEXPAND | wxALL, 0);
  sizer->Add(l, 1, wxEXPAND | wxALL, 0);

  SetAutoLayout(TRUE);
  SetSizer(sizer);
  sizer->Fit(this);
  sizer->SetSizeHints(this);
}

int 
SimpleSearchPanel::check()
{
  wxString msg("");
  if (dic_ == NULL)
    {
      l->Clear();
      msg << "Pas de dictionnaire";
      l->Append(msg);
      return 0;
    }
  return 1;
}



class PCross : public SimpleSearchPanel
{
private:
public:
  void compute_char(wxCommandEvent&) { };
  void compute_enter(wxCommandEvent&);
  PCross(wxWindow* parent, int id, Dictionary dic) : SimpleSearchPanel(parent,id,dic) {};
};

void
PCross::compute_enter(wxCommandEvent&)
{
  int  i;
  char rack[DIC_WORD_MAX];
  char buff[RES_CROS_MAX][DIC_WORD_MAX];

  if (!check())
    return;

  if (t->GetValue().Len() >= DIC_WORD_MAX)
    {
      wxString msg("");
      msg << "La recherche est limite  " << DIC_WORD_MAX - 1 << " lettres";
      l->Append(msg);
      return;
    }

  strncpy(rack,t->GetValue().c_str(),DIC_WORD_MAX);
  Dic_search_Cros(dic_,rack,buff);

#if defined(ENABLE_LISTBOX_SET)
  int resnum = 0;
  wxString res[RES_CROS_MAX];
  for(i=0; i < RES_CROS_MAX && buff[i][0]; i++)
    res[resnum++] =  wxString(buff[i]);
  l->Set(resnum,res);
#else
  l->Clear();
  for(i=0; i < RES_CROS_MAX && buff[i][0]; i++)
    l->Append(wxString(buff[i]));
#endif
  if (l->Number() == 0)
    l->Append("Aucun rsultat");
}

class PPlus1 : public SimpleSearchPanel
{
private:
public:
  void compute_char(wxCommandEvent&) { };
  void compute_enter(wxCommandEvent&);
  PPlus1(wxWindow* parent, int id, Dictionary dic) : SimpleSearchPanel(parent,id,dic) {};
};

void
PPlus1::compute_enter(wxCommandEvent&)
{
  int  i,j;
  char rack[DIC_WORD_MAX];
  char buff[LETTERS][RES_7PL1_MAX][DIC_WORD_MAX];

  if (!check())
    return;

  if (t->GetValue().Len() >= DIC_WORD_MAX)
    {
      wxString msg("");
      msg << "La recherche est limite  " << DIC_WORD_MAX - 1 << " lettres";
      l->Append(msg);
      return;
    }

  strncpy(rack,t->GetValue().c_str(),DIC_WORD_MAX);
  Dic_search_7pl1(dic_,rack,buff,TRUE);

#if defined(ENABLE_LISTBOX_SET)
  int resnum = 0;
  wxString res[LETTERS*(RES_7PL1_MAX+1)];
  for(i=0; i < LETTERS; i++)
    {
      if (i && buff[i][0][0])
	res[resnum++] = wxString("+") + wxString((char)(i+'A'-1));
      for(j=0; j < RES_7PL1_MAX && buff[i][j][0]; j++)
	res[resnum++] = wxString("  ") + wxString(buff[i][j]);
    }
  l->Set(resnum,res);
#else
  l->Clear();
  for(i=0; i < LETTERS; i++)
    {
      if (i && buff[i][0][0])
	l->Append(wxString("+")+wxString((char)(i+'A'-1)));
      for(j=0; j < RES_7PL1_MAX && buff[i][j][0]; j++)
	l->Append(wxString("  ")+wxString(buff[i][j]));
    }
#endif
  if (l->Number() == 0)
    l->Append("Aucun rsultat");
}

SearchPanel::SearchPanel(wxFrame *parent, Dictionary dic) :
  wxNotebook(parent, -1)
{
  AddPage(new PCross(this,ID_PANEL_CROSS,dic),"Mots croiss");
  AddPage(new PPlus1(this,ID_PANEL_PLUS1,dic),"Plus 1");
  SetSelection(0);  
}

SearchPanel::~SearchPanel()
{
}


