/*****************************************************************************
 * Copyright (C) 1999-2005 Eliot
 * Authors: Antoine Fraboulet <antoine.fraboulet@free.fr>
 *          Olivier Teuliere  <ipkiss@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *****************************************************************************/

#ifndef _BAG_H_
#define _BAG_H_

#include "tile.h"
#include <map>

using std::map;


/**
 * A bag stores the set of free tiles for the game.
 */
class Bag
{
public:
    Bag();
    virtual ~Bag() {}
    void init();

    /// Take a tile in the bag
    void takeTile(const Tile &iTile);
    /// Replace a tile into the bag
    void replaceTile(const Tile &iTile);

    /// Return how many tiles identical to iTile are available in the bag
    unsigned int in(const Tile &iTile) const;

    /**
     * Return how many tiles/vowels/consonants are available
     * Warning: b.nVowels() + b.nConsonants() != b.nTiles(),
     * because of the jokers and the 'Y'.
     */
    unsigned int nTiles() const  { return m_ntiles; }
    unsigned int nVowels() const;
    unsigned int nConsonants() const;

    /**
     * Return a random available tile
     * The tile is not taken out of the bag.
     */
    Tile selectRandom();

    void operator=(const Bag &iOther);

    /// Print on stderr all the letters of the bag (for debugging purposes)
    void dumpAll() const;

private:
    /// Associate to each tile its number of occurrences in the bag
    map<Tile, int> m_tilesMap;
    /// Total number of tiles in the bag
    int m_ntiles;
};

#endif

/// Local Variables:
/// mode: c++
/// mode: hs-minor
/// c-basic-offset: 4
/// indent-tabs-mode: nil
/// End:
