
/* 
 *  The Enhanced Linux Progress Patch
 *     by Prasad <prasad_s@students.iiit.net>, IIIT - Hyderabad, INDIA
 *
 *  elpp_structs.h   The ELPP patch related structures.
 *
 *  This file is part of the Enhanced Linux Progress Patch.
 *
 *  ELPP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Foobar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with ELPP; if not, write to the Free Software 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 * 
 */ 

#ifndef LINUX_PROGRESS_PATCH_H
#define LINUX_PROGRESS_PATCH_H

#include <sys/types.h>

struct elpp_userprefs {
    unsigned short bar_x;
    unsigned short bar_y;
    unsigned short bar_length;
    unsigned short bar_width;
    unsigned short msg_length;
    unsigned short num_messages;
    unsigned short msg_x;
    unsigned short msg_y;
    
    unsigned char bar_bg[3];
    unsigned char bar_fg[3];
    unsigned char warning_bg[3];
    unsigned char warning_fg[3];
    unsigned char warning_symbol_bg[3];
    unsigned char warning_symbol_fg[3];
    unsigned char error_bg[3];
    unsigned char error_fg[3];
    unsigned char error_symbol_bg[3];
    unsigned char error_symbol_fg[3];
    unsigned char success_bg[3];
    unsigned char success_fg[3];
    unsigned char success_symbol_bg[3];
    unsigned char success_symbol_fg[3];
};

#endif
