
/* 
 *  The Enhanced Linux Progress Patch
 *     by Prasad <prasad_s@students.iiit.net>, IIIT - Hyderabad, INDIA
 *
 *  elpp_theme.h   ELPP Theme Maker Declarations
 *
 *  This file is part of the Enhanced Linux Progress Patch.
 *
 *  ELPP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Foobar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with ELPP; if not, write to the Free Software 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 * 
 */ 

#ifndef ELPPTHEME_H
#define ELPPTHEME_H

#include <qvariant.h>
#include <qimage.h>
#include <qmainwindow.h>
#include <qlabel.h>

#include "elpp_structs.h"
#include "linux_logo.h"

class QVBoxLayout;
class QGridLayout;
class QAction;
class QActionGroup;
class QToolBar;
class QPopupMenu;
class QButtonGroup;
class QComboBox;
class QButton;
class QSpinBox;
class QGroupBox;
class QPushButton;

class ELPPTheme : public QMainWindow
{
    Q_OBJECT

    friend class Label;

public:
    ELPPTheme( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel );
    ~ELPPTheme();

    QImage img;
    Label* Display;
    QButtonGroup* barGroup;
    QSpinBox* barHvalue;
    QSpinBox* barXvalue;
    QLabel* barY;
    QSpinBox* barWvalue;
    QLabel* barW;
    QSpinBox* barYvalue;
    QLabel* barX;
    QLabel* barH;
    QButtonGroup* msgGroup;
    QGroupBox* colorGroup;
    QSpinBox* msgNvalue;
    QSpinBox* msgLvalue;
    QSpinBox* msgYvalue;
    QLabel* msgY;
    QLabel* msgX;
    QSpinBox* msgXvalue;
    QLabel* msgN;
    QLabel* msgL;
    QComboBox* colorCombo;
    QButton* bg;
    QLabel* fgColor;
    QButton* fg;
    QLabel* bgColor;
    QMenuBar *menubar;
    QPopupMenu *fileMenu;
    QPopupMenu *helpMenu;
    QAction* fileOpenAction;
    QAction* fileSaveAction;
    QAction* fileExitAction;
    QAction* helpAboutAction;
    QAction* helpThemeAction;
    QColor *colors;
    QPushButton *barLocation;
    QPushButton *msgLocation;
    QLabel *pointer;

public slots:
    virtual void fileOpen();
    virtual void fileSave();
    virtual void fileExit();
    virtual void helpAbout();
    virtual void helpTheme();
    void paintLbl();
    void setColors(int index);
    void bgClicked();
    void fgClicked();
    void barToggle(bool on);
    void textToggle(bool on);

protected:
    QGridLayout* ELPPThemeLayout;
    QVBoxLayout* layout6;
    QGridLayout* barGroupLayout;
    QGridLayout* msgGroupLayout;
    QGridLayout* colorGroupLayout;
    
private:
    void writePreferences(FILE *fp);
    void writeImage(FILE *fp);

protected slots:
    virtual void languageChange();

};

class Label : public QLabel
{
public:
    Label(QWidget *parent=NULL, char *name=0);
    ~Label();

protected:
    void mousePressEvent(QMouseEvent *ev);
    void mouseReleaseEvent(QMouseEvent *ev);
    void mouseMoveEvent(QMouseEvent *ev);
    void paintEvent(QPaintEvent *ev);

private:
    ELPPTheme *win;
    bool mousePressed;
    QPoint mousePressPoint;

};

#endif // ELPPTHEME_H
