#! /usr/bin/env python
# -*- coding: utf-8 -*-

# eLyXer configuration
# autogenerated from config file on 2009-05-04

class BlackBoxConfig(object):
  "Configuration class from config file"

  starts = [
      u'\\lyxformat', u'\\begin_document', u'\\begin_body', 
      u'\\family default', u'\\color inherit', u'\\shape default', 
      u'\\series default', u'\\emph off', u'\\bar no', u'\\noun off', 
      u'\\emph default', u'\\bar default', u'\\noun default', 
      u'\\family roman', u'\\series medium', u'\\shape up', u'\\size normal', 
      u'\\color none', u'#LyX', u'\\noindent', u'\\labelwidthstring', 
      u'\\paragraph_spacing', u'\\length', 
      ]

class ContainerConfig(object):
  "Configuration class from config file"

  commands = {
      u'\\InsetSpace \\space{}':u'&nbsp;', u'\\InsetSpace \\thinspace{}':u' ', 
      u'\\InsetSpace ~':u'&nbsp;', u'\\SpecialChar \\@.':u'.', 
      u'\\SpecialChar \\ldots{}':u'…', 
      u'\\SpecialChar \\menuseparator':u'&nbsp;▷&nbsp;', 
      u'\\SpecialChar \\nobreakdash-':u'-', u'\\SpecialChar \\slash{}':u'/', 
      u'\\SpecialChar \\textcompwordmark{}':u'', u'\\backslash':u'\\', 
      }

  escapes = {
      u'&':u'&amp;', u'<':u'&lt;', u'>':u'&gt;', 
      }

  replaces = {
      u'\n':u'', u' -- ':u' — ', u'\'':u'’', u'`':u'‘', 
      }

class FormulaConfig(object):
  "Configuration class from config file"

  alphacommands = {
      u'\\Delta':u'Δ', u'\\acute{A}':u'Á', u'\\acute{E}':u'É', 
      u'\\acute{I}':u'Í', u'\\acute{O}':u'Ó', u'\\acute{U}':u'Ú', 
      u'\\acute{a}':u'á', u'\\acute{e}':u'é', u'\\acute{i}':u'í', 
      u'\\acute{o}':u'ó', u'\\acute{u}':u'ú', u'\\alpha':u'α', u'\\beta':u'β', 
      u'\\delta':u'δ', u'\\epsilon':u'ε', u'\\gamma':u'γ', u'\\lambda':u'λ', 
      u'\\pi':u'π', u'\\sigma':u'σ', u'\\tilde{N}':u'Ñ', u'\\tilde{n}':u'ñ', 
      }

  commands = {
      u'\\!':u'', u'\\%':u'%', u'\\,':u' ', u'\\:':u' ', 
      u'\\Rightarrow':u' ⇒ ', u'\\\\':u'<br/>', u'\\_':u'_', 
      u'\\approx':u' ≈ ', u'\\bigstar':u'★', u'\\blacktriangleright':u'▶', 
      u'\\bullet':u'•', u'\\cdot':u'⋅', u'\\circ':u'○', u'\\cos':u'cos', 
      u'\\cosh':u'cosh', u'\\dagger':u'†', u'\\dashrightarrow':u' ⇢ ', 
      u'\\ddagger':u'‡', u'\\ddots':u'⋱', u'\\diamond':u'◇', 
      u'\\displaystyle':u'', u'\\end{array}':u'', u'\\exp':u'exp', 
      u'\\geq':u'≥', u'\\gets':u'←', u'\\implies':u'  ⇒  ', u'\\in':u'∈', 
      u'\\infty':u'∞', u'\\int':u'<span class="bigsymbol">∫</span>', 
      u'\\intop':u'<span class="bigsymbol">∫</span>', 
      u'\\left(':u'<span class="bigsymbol">(</span>', 
      u'\\left[':u'<span class="bigsymbol">[</span>', u'\\leftarrow':u' ← ', 
      u'\\leq':u'≤', u'\\lim':u'lim', u'\\ln':u'ln', u'\\log':u'log', 
      u'\\lyxlock':u'', u'\\neq':u'≠', u'\\nonumber':u'', u'\\not':u'¬', 
      u'\\pm':u'±', u'\\prime':u'′', u'\\propto':u' ∝ ', u'\\quad':u' ', 
      u'\\right)':u'<span class="bigsymbol">)</span>', 
      u'\\right]':u'<span class="bigsymbol">]</span>', u'\\rightarrow':u' → ', 
      u'\\rightsquigarrow':u' ⇝ ', u'\\scriptscriptstyle':u'', 
      u'\\scriptstyle':u'', u'\\sim':u' ~ ', u'\\sin':u'sin', 
      u'\\sinh':u'sinh', u'\\sum':u'<span class="bigsymbol">∑</span>', 
      u'\\tanh':u'tanh', u'\\textstyle':u'', u'\\times':u' × ', u'\\to':u'→', 
      u'\\triangleright':u'▷', 
      }

  decoratingfunctions = {
      u'\\acute':u'´', u'\\breve':u'˘', u'\\check':u'ˇ', u'\\ddot':u'¨', 
      u'\\dot':u'˙', u'\\grave':u'`', u'\\hat':u'^', u'\\tilde':u'˜', 
      u'\\vec':u'→', 
      }

  fontfunctions = {
      u'\\boldsymbol':u'b', u'\\mathbb':u'span class="blackboard"', 
      u'\\mathbf':u'b', u'\\mathcal':u'span class="script"', 
      u'\\mathfrak':u'span class="fraktur"', u'\\mathit':u'i', 
      u'\\mathrm':u'span class="mathrm"', u'\\mathsf':u'span class="mathsf"', 
      u'\\mathtt':u'tt', u'\\text':u'span class="text"', 
      u'\\textipa':u'span class="textipa"', u'\\textrm':u'span class="mathrm"', 
      }

  fractionfunctions = [
      u'\\frac', u'\\nicefrac', 
      ]

  fractionspans = {
      u'first':u'span class="numerator"', 
      u'second':u'span class="denominator"', u'whole':u'span class="fraction"', 
      }

  modified = {
      u'\n':u'', u' ':u'', u'&':u'	', u'\'':u'’', u'+':u' + ', u',':u', ', 
      u'-':u' − ', u'/':u' ⁄ ', u'<':u' &lt; ', u'=':u' = ', u'>':u' &gt; ', 
      }

  onefunctions = {
      u'\\bar':u'span class="bar"', u'\\begin{array}':u'span class="arraydef"', 
      u'\\label':u'', u'\\mbox':u'span class="mbox"', 
      u'\\overline':u'span class="overline"', u'\\sqrt':u'span class="sqrt"', 
      u'\\underline':u'u', u'^':u'sup', u'_':u'sub', 
      }

  unmodified = [
      u'.', u'*', u'€', u'(', u')', u'[', u']', u':', u'·', u'!', u';', 
      ]

class SpaceConfig(object):
  "Configuration class from config file"

  spaces = {
      u'\\enskip{}':u' ', u'\\hfill{}':u' ', u'\\hspace*{\\fill}':u' ', 
      u'\\hspace{}':u' ', u'\\negthinspace{}':u'', u'\\qquad{}':u'  ', 
      u'\\quad{}':u' ', u'\\space{}':u'&nbsp;', u'\\thinspace{}':u' ', 
      u'~':u'&nbsp;', 
      }

class TranslationConfig(object):
  "Configuration class from config file"

  floats = {
      u'algorithm':u'Listing ', u'figure':u'Figure ', u'table':u'Table ', 
      }

