(use-modules (emacsy emacsy))

(define-interactive (incr-counter #:optional 
                    (n (universal-argument-pop!)))
 "Increment the counter."
 (set-counter! (+ (get-counter) n)))

(define-interactive (decr-counter #:optional 
                    (n (universal-argument-pop!)))
 "Decrement the counter."
 (set-counter! (- (get-counter) n)))

(define-key global-map
  "=" 'incr-counter)
(define-key global-map 
  "-" 'decr-counter)
(set! debug-on-error? #t)

(define-interactive (change-counter) 
 "Change the counter to a new value."
 (set-counter! 
   (string->number 
     (read-from-minibuffer 
       "New counter value: "))))
(use-modules (system repl server))

;; Start a server on port 37146.
;(spawn-server)
