(use-modules (emacsy advice)
             (emacsy event)
             (emacsy klecl)
             (oop goops)
             (srfi srfi-11))

(eval-when (compile load eval)
           ;; Some trickery so we can test private procedures.
           (module-use! (current-module) (resolve-module '(emacsy advice))))

(use-modules (check))
(use-modules (ice-9 pretty-print))
(define test-errors '())
(define (my-orig-func x)
  (+ x 1))

(define (make-counter)
  (let ((x 0))
    (lambda args
      (if (and (= (length args) 1) (eq? (car args) 'count))
          x
          (begin (set! x (+ x 1))
                 (car args))))))

(define a-before (make-counter))
(define advice (make-record-of-advice my-orig-func '() '() '()))

(define advised-func (make-advising-function advice))
(check (a-before 'count) => 0)
(check (my-orig-func 1) => 2)
(check (advised-func 1) => 2)
(check (a-before 'count) => 0)
(define advice (make-record-of-advice my-orig-func (list (make-piece-of-advice a-before 'a-before 'before 0 'activate)) '() '()))

(define advised-func (make-advising-function advice))
(check (a-before 'count) => 0)
(check (my-orig-func 1) => 2)
(check (advised-func 1) => 2)
(check (a-before 'count) => 1)
(define a-after (make-counter))
(define advice (make-record-of-advice my-orig-func '() '() 
                                      (list (make-piece-of-advice a-after 'a-after 'after 0 'activate))))

(define advised-func (make-advising-function advice))
(check (a-after 'count) => 0)
(check (my-orig-func 1) => 2)
(check (advised-func 1) => 2)
(check (a-after 'count) => 1)
(define a-around (lambda args
                  (next-advice)
                  1))
(define advice (make-record-of-advice my-orig-func '() (list (make-piece-of-advice a-around 'a-around 'around 0 'activate)) '()))

(define advised-func (make-advising-function advice))
(check (my-orig-func 1) => 2)
(check (advised-func 1) => 1)
;(run-tests)
(check-report)
'(if (> (length test-errors) 0)
    (format #t "~a ERROR in tests: ~a." (length test-errors) (reverse test-errors))
    (format #t "NO ERRORs in tests."))
(exit (if (and (= (length test-errors) 0) (= 0 (length check:failed))) 0 1))
