(define-module (emacsy advice)
  #:use-module (srfi srfi-9)  
  )

(define-record-type <record-of-advice>
  (make-record-of-advice original before around after)
  record-of-advice?
  (original   advice-original)
  (before     advice-before    set-advice-before!)
  (around     advice-around    set-advice-around!)
  (after      advice-after     set-advice-after!))
(define-record-type <piece-of-advice>
  (make-piece-of-advice procedure name class priority flag)
  piece-of-advice?
  (procedure poa-procedure)
  (name      poa-name) ;; symbol not string
  (class     poa-class    set-poa-class!)
  (priority  poa-priority set-poa-priority!)
  (flag      poa-flag     set-poa-flag!))

(define next-advice-func (make-fluid))

(define (make-advising-function advice)
  (lambda args
    (let ((around-advices (append (advice-around advice) 
                                  (list (make-piece-of-advice 
                                         (advice-original 
                                          advice)
                                         'original
                                         'bottom
                                         0
                                         'activate))))
          (result #f))
     (define (my-next-advice)
       (if (null? around-advices)
           (throw 'next-advices-drained)
           (let ((next-one-around (car around-advices)))
             (set! around-advices (cdr around-advices))
             (apply (poa-procedure next-one-around) args))))
     ;; This could be done more cleanly.  For instance,
     ;; If one calls (next-advice) more than once,
     ;; they drain all the advice rather than calling
     ;; the same advice again, which is probably
     ;; the more correct behavior.
     
     (for-each (lambda (before)
                 (apply (poa-procedure before) args)) 
               (advice-before advice))
     
     (set! result (with-fluid* next-advice-func my-next-advice
                               (lambda ()
                                 (next-advice))))
     (for-each (lambda (after)
                 (apply (poa-procedure after) result args)) 
               (advice-after advice))
     result)))
(define (next-advice)
  (if (fluid-bound? next-advice-func)
      ((fluid-ref next-advice-func))
      (throw 'no-next-advice-bound)))
