(use-modules (emacsy block)
             (oop goops))

(eval-when (compile load eval)
           ;; Some trickery so we can test private procedures.
           (module-use! (current-module) (resolve-module '(emacsy block))))

(use-modules (check))
(use-modules (ice-9 pretty-print))
(define test-errors '())
(define done-blocking? #f)
(define (i-block)
  (block-yield)
  (set! done-blocking? #t))
(check-throw (i-block) => 'misc-error)
(check-true (call-blockable (lambda () (i-block))))
(check (length blocking-continuations) => 1)
(check done-blocking? => #f)
(check (block-tick) => #t)
(check done-blocking? => #t)
(check (length blocking-continuations) => 0)
(define continue-blocking? #t)
(define (i-block-until)
  (block-until (lambda () (not continue-blocking?))))
(check (length blocking-continuations) => 0)
(call-blockable (lambda () (i-block-until)))
(check (length blocking-continuations) => 1)
(block-tick)
(check (length blocking-continuations) => 1)
(set! continue-blocking? #f)
(check (length blocking-continuations) => 1)
(block-tick)
(check (length blocking-continuations) => 0)
(set! continue-blocking? #t)
(let ((bc (call-blockable (lambda () (i-block-until)))))
  (check (length blocking-continuations) => 1)
  (block-tick)
  (check (length blocking-continuations) => 1)
  (check-throw (block-kill bc) => 'block-killed)
  ;; The killed block is not cleaned out immediately.
  (check (length blocking-continuations) => 1)
  (block-tick)
  (check (length blocking-continuations) => 0))

;(run-tests)
(check-report)
'(if (> (length test-errors) 0)
    (format #t "~a ERROR in tests: ~a." (length test-errors) (reverse test-errors))
    (format #t "NO ERRORs in tests."))
(exit (if (and (= (length test-errors) 0) (= 0 (length check:failed))) 0 1))
