(use-modules (emacsy command)
             (emacsy event)
             (oop goops))

(eval-when (compile load eval)
           ;; Some trickery so we can test private procedures.
           (module-use! (current-module) (resolve-module '(emacsy command))))

(use-modules (check))
(use-modules (ice-9 pretty-print))
(define test-errors '())
(define test-cmd (lambda-cmd args 1))
(define (test-cmd-2) 2)
(define-cmd (test-cmd-3) 3)
(check (procedure-documentation test-cmd-3) => #f)
(check (test-cmd) => 1)
(check-true (command? test-cmd))
(check-true (command? test-cmd-2))
(check-true (command? test-cmd-3))
(check (assq-ref (procedure-properties test-cmd) 'command-name) => #f)
(check (assq 'command-name (procedure-properties test-cmd-2)) => #f)
(check (command-name test-cmd) => 'proc)
(check (command-name test-cmd-2) => 'test-cmd-2)
(check (command-name test-cmd-3) => 'test-cmd-3)
(define-cmd (test-who-am-i?) 
  "test-who-am-i? documentation"
  (let ((w (what-command-am-i?)))
    1
    w))
(check (command-name test-who-am-i?) => 'test-who-am-i?)
(check (test-who-am-i?) => 'test-who-am-i?)
(check (procedure-documentation test-who-am-i?) => "test-who-am-i? documentation")
(define-cmd (foo)
  (if (called-interactively?)
      'interactive
      'non-interactive))
(check (command? 'foo) => #f)
(check (command? foo) => #t)
(check (command-name foo) => 'foo)
(check-true (command->proc foo))

(check-throw (command-execute 'foo) => 'misc-error)
(check (command-execute foo) => 'non-interactive)
(check (call-interactively foo) => 'interactive)
;(run-tests)
(check-report)
'(if (> (length test-errors) 0)
    (format #t "~a ERROR in tests: ~a." (length test-errors) (reverse test-errors))
    (format #t "NO ERRORs in tests."))
(exit (if (and (= (length test-errors) 0) (= 0 (length check:failed))) 0 1))
