(use-modules (check)
             (emacsy core)
             (emacsy event)
             (emacsy klecl)
             (oop goops)
             (srfi srfi-11))

(use-private-modules (emacsy core))
(set! emacsy-interactive? #t)

(use-modules (check))
(use-modules (ice-9 pretty-print))
(define test-errors '())
(set! emacsy-interactive? #f)
(check (eval-expression '(+ 1 2)) => 3)
(set! emacsy-interactive? #t)
(check (let* ((symbols '(aa ab c d)))
   (let-values
       (((to-string from-string) (object-tracker symbol->string)))
     (map from-string (all-completions "a" (map to-string symbols))))) => '(aa ab))
(define (good-hook)
  #t)
(define (bad-hook)
  (throw 'some-error))
(define my-hook (make-hook 0))

(check-throw (run-hook my-hook) => 'no-throw)
(check-throw (emacsy-run-hook my-hook) => 'no-throw)
(check (emacsy-run-hook my-hook) => #t)
(add-hook! my-hook good-hook)
(check-throw (emacsy-run-hook my-hook) => 'no-throw)
(add-hook! my-hook bad-hook)
(check-throw (run-hook my-hook) => 'some-error)
(check-throw (emacsy-run-hook my-hook) => 'no-throw)
(check (emacsy-run-hook my-hook) => #f)
(emacsy-discard-input!)
;(emacsy-key-event #\a)
(define mouse-event #f)
(agenda-schedule (colambda () 
                           (format #t "START~%")
                           (set! mouse-event (read-from-mouse))
                           (format #t "END~%")))
;(with-blockable )
;(block-tick)
;(check mouse-event => #f)
;(update-agenda)
(emacsy-mouse-event #(0 0) 1 'down)
(update-agenda)
(check-true mouse-event)
;(block-tick)
;(run-tests)
(check-report)
'(if (> (length test-errors) 0)
    (format #t "~a ERROR in tests: ~a." (length test-errors) (reverse test-errors))
    (format #t "NO ERRORs in tests."))
(exit (if (and (= (length test-errors) 0) (= 0 (length check:failed))) 0 1))
