(define-module (emacsy emacsy)
  #:use-module (convenience-lambda)  
  #:use-module (emacsy util)
  #:use-module (emacsy self-doc)
  #:use-module (emacsy event)
  #:use-module (emacsy keymap)
  #:use-module (emacsy coroutine)
  #:use-module (emacsy agenda)
  #:use-module (emacsy command)
  #:use-module (emacsy mode)
  #:use-module (emacsy buffer)
  #:use-module (emacsy block)
  #:use-module (emacsy klecl)
  #:use-module (emacsy kbd-macro)
  #:use-module (emacsy minibuffer)
  #:use-module (emacsy core)
  #:use-module (emacsy help))
(define (re-export-modules . modules)
  (define (re-export-module module)
    (module-for-each 
     (lambda (sym var) 
       ;;(format #t "re-exporting ~a~%" sym)
       (module-re-export! (current-module) (list sym)))
     (resolve-interface module)))
  (for-each re-export-module modules))
(re-export-modules 
 '(emacsy util)
 '(emacsy self-doc)
 '(emacsy keymap)
 '(emacsy event)
 '(emacsy mode)       
 '(emacsy buffer)
 '(emacsy coroutine)
 '(emacsy agenda)
 '(emacsy command)
 '(emacsy block)
 '(emacsy klecl)
 '(emacsy kbd-macro)
 '(emacsy minibuffer)
 '(emacsy core)
 '(emacsy help))
