(use-modules (emacsy event)
             (oop goops)
             )

(eval-when (compile load eval)
           ;; Some trickery so we can test private procedures.
           (module-use! (current-module) (resolve-module '(emacsy event))))

(use-modules (check))
(use-modules (ice-9 pretty-print))
(define test-errors '())
(check-true (make <key-event> #:command-char #\a))
(check (strip-off-modifier-keys "C-a") => '((control) "a"))
(check (strip-off-modifier-keys "a") => '(() "a"))
(check (strip-off-modifier-keys "asdf") => '(() "asdf"))
(check (modifier-char->symbol #\S) => 'shift)
(check (modifier-char->symbol #\X) => #f)
(check-true (memq 'kbd-entry->key-event (alist-keys kbd-converter-functions)))
(check (modifier-keys (kbd-entry->key-event "C-C-C-x")) => '(control control control))
(let ((key-event (kbd-entry->event "S-C-C-S-a")))
  (check (modifier-keys key-event) => '(shift control control shift))
  (check (command-char key-event) => #\a)
  (canonize-event! key-event)
  (check (modifier-keys key-event) => '(control))
  (check (command-char key-event) => #\A))
(check (kbd "S-C-C-S-a") => '("C-A"))
(check (kbd "S-C-C-S-A") => '("C-A"))
(check (event->kbd (make <key-event> #:command-char #\a)) => "a")
(check (event->kbd (make <key-event> #:command-char #\a 
                         #:modifier-keys '(control))) => "C-a")
(check (kbd "mouse-1") => '("mouse-1"))
(check (kbd "S-S-mouse-1") => '("S-mouse-1"))
;(run-tests)
(check-report)
'(if (> (length test-errors) 0)
    (format #t "~a ERROR in tests: ~a." (length test-errors) (reverse test-errors))
    (format #t "NO ERRORs in tests."))
(exit (if (and (= (length test-errors) 0) (= 0 (length check:failed))) 0 1))
