(use-modules (emacsy keymap)
             (emacsy event)
             (oop goops))

(eval-when (compile load eval)
           ;; Some trickery so we can test private procedures.
           (module-use! (current-module) (resolve-module '(emacsy keymap))))

(use-modules (check))
(use-modules (ice-9 pretty-print))
(define test-errors '())
(check-true (make <keymap>))
(define (self-insert-command) #f) ;; make a fake command
(define (mouse-drag-region) #f) ;; make a fake command
(define (find-file-at-point) #f) ;; make a fake command
(define k (make-keymap))
(define-key k "a"       'self-insert-command)
(define-key k "mouse-1" 'mouse-drag-region)
(define-key k "C-x C-f" 'find-file-at-point)
(define (lookup-key* . args)
  (let ((result (apply lookup-key args)))
    (if (procedure? result) 
        (procedure-name result)
        result)))
(check (lookup-key* k '("a")) => 'self-insert-command-trampoline)
(check (lookup-key* k "a") => 'self-insert-command-trampoline)
(check (lookup-key k '("b")) => #f)
(check (lookup-key k "M-x b") => #f)
(check-true (keymap? (lookup-key k '("C-x"))))
(check (lookup-key k "C-x C-f a b" #f) => 2)
(check (lookup-key? k "C-x") => #f)
(check (lookup-key? k "C-x C-f") => #t)
(check (lookup-key? k "a") => #t)
;(check (define-key k (kbd "C-x C-f C-a C-b") 'nope) => 2)
(check-true  (keymap? (make <keymap>)))
(check-false (keymap? 1))
;(run-tests)
(check-report)
'(if (> (length test-errors) 0)
    (format #t "~a ERROR in tests: ~a." (length test-errors) (reverse test-errors))
    (format #t "NO ERRORs in tests."))
(exit (if (and (= (length test-errors) 0) (= 0 (length check:failed))) 0 1))
