namespace
{

/* -------------------- SoundEffect -------------------- */

    struct SoundEffect {
        // Variables
        SoundName name;
        px::V2    position;
        int       priority;
        double    volume;           // Volume between 0.0 and 1.0
        int       left;
        int       right;
        bool      active;

        // Constructor
        SoundEffect ();
    };

/* -------------------- SoundEngine -------------------- */

    class SoundEngine {
    public:
        virtual ~SoundEngine() {}
        
        //! Returns true if successful.
        virtual bool init() = 0;
        virtual void shutdown() = 0;
        virtual bool is_initialized() const = 0;

        virtual void set_sound_volume (double soundvol) = 0;
        virtual void set_music_volume (double musicvol) = 0;

        // ---------- Music ----------

        virtual bool play_music (const std::string &filename) = 0;
        virtual void stop_music() = 0;
        virtual void fadeout_music() = 0;

        // ---------- Sound effects ----------

        virtual void clear_cache() = 0;
        virtual void define_sound (const SoundName &, const std::string &filename)=0;
        virtual void define_sound (const SoundName &, const SoundData &)=0;
        virtual void play_sound(const SoundName &name,
                                double volume, int left, int right) = 0;
    };


    class SoundEngine_Null : public SoundEngine {
    public:

        // SoundEngine interface
        bool init() { return true; }
        void shutdown() {}
        void clear_cache() {}

        bool is_initialized() const 
        { return true; }

        void set_sound_volume(double /*soundvol*/)
        {}

        void set_music_volume(double /*musicvol*/) 
        {}

        bool play_music (const std::string &/*filename*/) 
        { return false; }

        void stop_music() 
        {}

        void fadeout_music() 
        {}

        void play_sound(const std::string & /*filename*/, 
                        double /*volume*/, int /*left*/, int /*right*/)
        {}

        void define_sound (const SoundName &, const std::string &/*filename*/)
        {}

        void define_sound (const SoundName &, const SoundData &)
        {}
    };

    class SoundEngine_SDL : public SoundEngine {
    public:
        SoundEngine_SDL();
        ~SoundEngine_SDL();

        // ---------- SoundEngine interface ----------
        bool init();        
        void shutdown();

        bool is_initialized() const { return m_initialized; }
        void set_sound_volume(double soundvol);
        void set_music_volume(double musicvol);

        bool play_music (const std::string &filename);
        void stop_music();
        void fadeout_music();

        void play_sound(const std::string &name,
                        double volume, int left, int right);
        void clear_cache();
        void define_sound (const SoundName &, const std::string &filename);
        void define_sound (const SoundName &, const SoundData &);

    private:
        // ---------- Private methods ----------
        Mix_Chunk *cache_sound(const std::string &name);

        static void channel_finished (int channel);


        // ---------- Variables ----------
        bool       m_initialized;
        int        m_soundvolume;
        int        m_musicvolume;
        Mix_Music *m_current_music;
        int        m_freq;
        Uint16     m_format;
        int        m_channels;
        px::Dict<Mix_Chunk*> wav_cache;
        vector<SoundEffect> m_channelinfo;
        static SoundEngine_SDL *m_instance;
    };
}
