;; erc-page.el - CTCP PAGE support for ERC
;;
;; Copyright (C)  2002  Alexander L. Belikoff (alexander@belikoff.net)
;;
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Commentary:

;; This used to be in erc.el, I (Jorgen) just extracted it from there
;; and put it in this file. Bugs and features are those of the
;; original author.

;;; Code:

(require 'erc)

;;;###autoload (autoload 'erc-page-mode "erc-page")
(define-erc-module page ctcp-page
  "Process CTCP PAGE requests from IRC."
  ;; Enable:
  ()
  ;; Disable:
  ())

(erc-define-catalog-entry 'english 'CTCP-PAGE "Page from %n (%u@%h): %m")

(defgroup erc-page nil
  "Process CTCP PAGE requests from IRC."
  :group 'erc)

(defcustom erc-page-function nil
  "A function name to process a \"page\" request.
The function must take two arguments: SENDER and MSG, both strings.  Value
nil for this variable will cause the page message to appear in the minibuffer
window."
  :group 'erc
  :type '(choice (const nil)
		 (function-item)))

(defvar erc-ctcp-query-PAGE-hook '(erc-ctcp-query-PAGE))
(defun erc-ctcp-query-PAGE (proc nick login host to msg)
  (when (string-match "PAGE\\(\\s-+.*\\)?$" msg)
    (let* ((m (match-string 1 msg))
	   (page-msg (if m (erc-interpret-controls (substring m 1))
		       "[no message]")))
      (if m (setq m (substring m 1)))
      (if erc-page-function
	  (funcall erc-page-function nick page-msg)
	(message (concat "PAGE from " nick " (" login "@" host "): " page-msg))
	(beep))
      (erc-display-message
       nil 'notice nil
       'CTCP-PAGE ?n nick ?u login ?h host ?m page-msg)))
  nil)

