/********************************************************************************
                                   Batch.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "Batch.h"
#include <qregexp.h>

Batch::Batch()
{
	hasNoError = true;
}

Batch::~Batch()
{
	queries.clear();
}

QString Batch::toString() const
{
	QString result;
	
	result = "";
	
	return result;
}

void Batch::build(QString &pBatchQuery)
{
	// split the batch with separator ; except in comments
	// and string.
	
	// it is a first version without lex.
	// it is not optimized. I think it could be improved
	// with the syntaxical color.
	
	queries.clear();
	
	QString *queryTmp, queryTmp2;
	QRegExp reTmp("[a-zA-Z0-9]");
	char *buffer;
	unsigned int bufferSize,i,j, queryNumber;
	signed int comment, comment2, text, iTmp;
	
	bufferSize = pBatchQuery.length() + 1;
	buffer = new char[bufferSize];
	memset(buffer,0,bufferSize);
	
	if (buffer == 0)
	{
		// error
		return;
	}
	
	sprintf(buffer,"%s",pBatchQuery.ascii());
	
	comment = 0;
	comment2 = 0;
	text = 0;
	queryNumber = 1;
	i = 0;
	j = 0;
	
	//printf("BufferSize : %d\n",bufferSize);
	
	while (i<bufferSize)
	{
	//printf("%c\n",buffer[i]);
		if (i == (bufferSize-1))
		{
			i++;
			queryTmp = new QString(pBatchQuery.mid(j,(i-j)));
			iTmp = queryTmp->find(reTmp,0);
			if (iTmp != -1)
			{
				queries.append(queryTmp);
				queryNumber++;
			}
			else
			{
				delete queryTmp;
			}
			queryTmp = 0;
			j = i;
			continue;
		}
	
		if (buffer[i] == ';')
		{
			if ((comment==0)&&(comment2==0)&&(text==0))
			{
				// separator
				i++;
				queryTmp = new QString(pBatchQuery.mid(j,(i-j)));
				// test if the query is empty
				iTmp = queryTmp->find(reTmp,0);
	// printf ("RegExp : %d\n",iTmp);
				if (iTmp != -1)
				{
	//printf ("Query %d : %s\n", queryNumber, queryTmp->ascii());
					queries.append(queryTmp);
					queryNumber++;
				}
				else
				{
					delete queryTmp;
				}
				queryTmp = 0;
				j = i;
				continue;
			}
		}
	
		if (buffer[i] == '\'')
		{
			if ((comment == 0) && (comment2 == 0))
			{
				// the string begin only outside of a commentary
				if (text == 0)
				{
					text = 1;
					i++;
					continue;
				}
				else
				{
					// a text may end
					i++;
					if (buffer[i] != '\'')
					{
						text = 0;
					}
					else
					{
						i++;
					}
					continue;
				}
			}
	
		}
	
		/* begin commentary with / and *   */
		if ((buffer[i] == '/') && (buffer[i+1] == '*'))
		{
			if ((text == 0) && (comment2 == 0))
			{
				comment++;
				i+=2;
				continue;
			}
		}
	
		/* end commentary with / and *   */
		if ((buffer[i] == '*') && (buffer[i+1] == '/'))
		{
			if ((text == 0) && (comment2 == 0))
			{
				comment--;
				i+=2;
				continue;
			}
		}
	
		/* begin commentary with --  */
		if ((buffer[i] == '-') && (buffer[i+1] == '-'))
		{
			if ((text == 0) && (comment == 0))
			{
				// commentary begins only outside of a string
				comment2++;
				i+=2;
				continue;
			}
		}
	
		if ((buffer[i] == '\n') && (comment2 > 0))
		{
			if (text == 0)
			{
				// commentary ends only outside of a string
				comment2 = 0;
				i++;
				continue;
			}
		}
	
		i++;
	}
	
	if (buffer != 0)
	{
		delete []buffer;
	}

	return;
}



