/********************************************************************************
			      BatchExecutorThread.cpp
			       -------------------
	   begin		: lun jui 14 19:50:56 CEST 2003
       copyright		: (C) 2003 by Thomas Silvi
	   email		: thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "BatchExecutorThread.h"
#include "QueryToolView.h"

#include <klocale.h>
#include <unistd.h>

BatchExecutorThread::BatchExecutorThread()
{
}

BatchExecutorThread::~BatchExecutorThread()
{
	// engine & view should never be deleted here. never.
	// as there are shared.
	view = 0;
	engine = 0;
	config = 0;
	
	if (batch !=0)
	{
		delete batch;
		batch = 0;
	}
}

void BatchExecutorThread::setBatch(Batch *pBatch)
{
	batch = pBatch;
	return;
}

void BatchExecutorThread::setView(QueryToolView *pView)
{
	view = pView;
	connect(this,  SIGNAL(signalPrintOutput(QString)), view, SLOT(printOutput(QString)));
	connect(this,  SIGNAL(signalBatchExecuted()), view, SLOT(batchExecuted()));
	connect(this,  SIGNAL(signalShowResults(PGresult *)), view,
		SLOT(showResuts(PGresult *)));
	connect(this, SIGNAL(signalSwitchToOutput()), view, SLOT(switchToOutput()));
	return;
}

void BatchExecutorThread::setEngine(QueryEngine *pEngine)
{
	engine = pEngine;
	return;
}

void BatchExecutorThread::setConfig(ToolSuiteConfig *pConfig)
{
	config = pConfig;
	return;
}

void BatchExecutorThread::run()
{
	// foreach query of the batch, execute it and report results
	QString *queryTmp, errorMessageTmp;
	bool letsGoOn, autoSwitch, continueOnError;
	ExecStatusType status;
	PGresult *r;
	
	isBatchCanceled = false;
	letsGoOn = true;

	batch->errorsCount = 0;
	
	autoSwitch = config->getBool("AutoSwitchToResult");
	continueOnError = config->getBool("BatchExecutionContinueOnError");
	
	if (autoSwitch == true)
	{
		emit signalSwitchToOutput();
	}
	
	for (queryTmp = (batch->queries).first();
		((letsGoOn == true)&&(queryTmp != 0)&&(isBatchCanceled == false));
		queryTmp = (batch->queries).next())
	{
		status = engine->executeQuery(queryTmp,errorMessageTmp);
	
		if (isBatchCanceled == true)
		{
			return;
		}
	
		r = engine->getResults();
	
		switch (status)
		{
			case PGRES_TUPLES_OK :
			{
				if (isBatchCanceled == false)
				{
					emit signalShowResults(r);
				}
				else
				{
					return;
				}
				break;
		}
		case PGRES_COMMAND_OK :
		{
			emit signalPrintOutput(QString(PQcmdStatus(r)));
			break;
		}
		case PGRES_EMPTY_QUERY :
		{
			emit signalPrintOutput("PGRES_EMPTY_QUERY\n");
			break;
		}
		case PGRES_FATAL_ERROR :
		{
			emit signalPrintOutput("PGRES_FATAL_ERROR\n");
			emit signalPrintOutput(errorMessageTmp);
			letsGoOn = continueOnError;
			batch->hasNoError = false;		
			batch->errorsCount = batch->errorsCount + 1;
			break;
		}
		case PGRES_NONFATAL_ERROR :
		{
			emit signalPrintOutput("PGRES_NONFATAL_ERROR\n");
			emit signalPrintOutput(errorMessageTmp);
			letsGoOn = continueOnError;
			batch->hasNoError = false;		
			batch->errorsCount = batch->errorsCount + 1;
			break;
		}
		case PGRES_COPY_OUT :
		{
			emit signalPrintOutput("PGRES_COPY_OUT\n");
			break;
		}
		case PGRES_COPY_IN :
		{
			emit signalPrintOutput("PGRES_COPY_IN\n");
			break;
		}
		case PGRES_BAD_RESPONSE :
		{
			emit signalPrintOutput("PGRES_BAD_RESPONSE\n");
			letsGoOn = continueOnError;
			batch->hasNoError = false;		
			batch->errorsCount = batch->errorsCount + 1;
			break;
		}
		default :
		{
	//			      emit signalPrintOutput("\n");
			break;
		}
		}
	
		emit signalPrintOutput("\n");
	}
	
	if (isBatchCanceled == false)
	{
		emit signalBatchExecuted();
	}
	
	return;
}

void BatchExecutorThread::cancelBatchExecution()
{
	isBatchCanceled = true;
	return;
}

Batch * BatchExecutorThread::getBatch()
{
	return batch;
}


