/********************************************************************************
		                  ConnectFrame
		               -------------------
	   begin	        : lun jui 14 19:50:56 CEST 2003
       copyright		: (C) 2003 by Thomas Silvi
	   email	        : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "ConnectFrame.h"

#include <klocale.h>

#include <qlayout.h>
#include <qlabel.h>

#define CD_LINEEDIT_LENGTH	    50
#define MAX_HOSTADDR_LENGTH	   15

ConnectFrame::ConnectFrame(QWidget * parent, const char * name, WFlags f) :
	QFrame (parent, name, f)
{
	int rowTmp;

	QGridLayout *grid = new QGridLayout(this,6,2,5);

	rowTmp = 0;

	QLabel * ql_Host = new QLabel (i18n("Host"),this);
	grid->addWidget(ql_Host,rowTmp,1);

	kle_Host = new KLineEdit(this);
	kle_Host->setMaxLength(CD_LINEEDIT_LENGTH);
	grid->addWidget(kle_Host,rowTmp,2);

	rowTmp++;

	QLabel *ql_HostAddr = new QLabel (i18n("Host IP"),this); 
	grid->addWidget(ql_HostAddr,rowTmp,1); 
	kle_HostAddr = new KLineEdit(this); 
	kle_HostAddr->setMaxLength(MAX_HOSTADDR_LENGTH); 
	grid->addWidget(kle_HostAddr,rowTmp,2);

	rowTmp++;

	QLabel * ql_Port = new QLabel (i18n("Port"),this);
	grid->addWidget(ql_Port,rowTmp,1);
	kle_Port = new KLineEdit(this);
	kle_Port->setMaxLength(CD_LINEEDIT_LENGTH);
	grid->addWidget(kle_Port,rowTmp,2);

	rowTmp++;

	QLabel * ql_Database = new QLabel (i18n("Database"),this);
	grid->addWidget(ql_Database,rowTmp,1);
	kle_Database = new KLineEdit(this);
	kle_Database->setMaxLength(CD_LINEEDIT_LENGTH);
	grid->addWidget(kle_Database,rowTmp,2);

	rowTmp++;

	QLabel * ql_Login = new QLabel (i18n("Login"),this);
	grid->addWidget(ql_Login,rowTmp,1);
	kle_Login = new KLineEdit(this);
	kle_Login->setMaxLength(CD_LINEEDIT_LENGTH);
	grid->addWidget(kle_Login,rowTmp,2);

	rowTmp++;

	QLabel * ql_Password = new QLabel (i18n("Password"),this); 
	grid->addWidget(ql_Password,rowTmp,1); 
	kpe_Password = new KPasswordEdit(this); 
	kpe_Password->setMaxLength(CD_LINEEDIT_LENGTH); 
	grid->addWidget(kpe_Password,rowTmp,2);

	rowTmp++;

}

ConnectFrame::~ConnectFrame()
{
	delete kle_Host;
	delete kle_HostAddr;
	delete kle_Port;
	delete kle_Database;
	delete kle_Login;
	delete kpe_Password;
}

void ConnectFrame::setHost(QString const &pHost)
{
	kle_Host->setText(pHost);
	return;
}

QString ConnectFrame::getHost () const
{
	return kle_Host->text();
}

void ConnectFrame::setHostAddr(QString const &pHostAddr)
{
	kle_HostAddr->setText(pHostAddr);
	return;
}

QString ConnectFrame::getHostAddr() const
{
	return kle_HostAddr->text();
}

void ConnectFrame::setPort(QString const &pPort)
{
	kle_Port->setText(pPort);
	return;
}

QString ConnectFrame::getPort() const
{
	return kle_Port->text();
}

void ConnectFrame::setDatabase(QString const &pDatabase)
{
	kle_Database->setText(pDatabase);
	return;
}

QString ConnectFrame::getDatabase() const
{
	return kle_Database->text();
}

void ConnectFrame::setLogin(QString const &pLogin)
{
	kle_Login->setText(pLogin);
	return;
}

QString ConnectFrame::getLogin() const
{
	return kle_Login->text();
}


void ConnectFrame::setPassword(QString const &pPassword)
{
	kpe_Password->setText(pPassword);
	return;
}

QString ConnectFrame::getPassword() const
{
	return kpe_Password->text();
}








