/********************************************************************************
                               ConnectionDialog.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "Misc.h"
#include "ConnectionDialog.h"

#include <klocale.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qregexp.h>

#include <kpassdlg.h>
#include <kmessagebox.h>

#define CD_LINEEDIT_LENGTH            50
#define MAX_HOSTADDR_LENGTH           15

#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>


ConnectionDialog::ConnectionDialog(QWidget *pParent, ToolSuiteConfig *pConfig,
	ConnectionParameters * pConnectionParameters)
	:	QDialog (pParent,"ConnectionDialog",true)

{
	// assert that pConfig is not null
	int rowTmp;
	
	setCaption("New Connection");

	
	QGridLayout *grid = new QGridLayout(this,6,2,5);
	
	rowTmp = 0;

	cf = new ConnectFrame(this);
//	grid->addWidget(cf,rowTmp,1);
	grid->addMultiCellWidget (cf,rowTmp,rowTmp,1,2);

	rowTmp++;
	
	QPushButton *qpb_Cancel = new QPushButton(i18n("Cancel"),this);
	grid->addWidget(qpb_Cancel,rowTmp,1);
	QPushButton *qpb_Connect = new QPushButton(i18n("Connect"),this);
	grid->addWidget(qpb_Connect,rowTmp,2);
	
	rowTmp++;
	
	qpb_Connect->setFocus();
	
	connect(qpb_Connect, SIGNAL(clicked()), SLOT(accept()));
	connect(qpb_Cancel, SIGNAL(clicked()), SLOT(reject()));
	
	// set value according to config
	
	QString hostTmp(""), hostAddrTmp(""), portTmp(""), databaseTmp(""), loginTmp("");

	if (pConnectionParameters != 0)
	{
		hostTmp=pConnectionParameters->getHostName();
		hostAddrTmp=pConnectionParameters->getHostAddr();
		portTmp=pConnectionParameters->getPort();
		databaseTmp=pConnectionParameters->getDatabase();
		loginTmp=pConnectionParameters->getLogin();
	}
	else
	{
		if (pConfig->getBool("FillConnParamWithPGEnvVariable"))
		{
			// PGHOST
			char *envHost;
			envHost = getenv("PGHOST");
			
			if (envHost != 0)
			{
				hostTmp = QString(envHost);
			}
			
			// PGHOSTADDR
			
			char *envHostAddr;
			envHostAddr = getenv("PGHOSTADDR");
			
			if (envHostAddr != 0)
			{
				hostAddrTmp = QString(envHostAddr);
			}
			
			// PGPORT
			char *envPort;
			envPort = getenv("PGPORT");
			
			if (envPort != 0)
			{
				portTmp = QString(envPort);
			}
			
			// PGDATABASE
			char *envDb;
			envDb = getenv("PGDATABASE");
			
			if (envDb != 0)
			{
				databaseTmp = QString(envDb);
			}
			//  PGUSER
			char * envUser;
			envUser = getenv("PGUSER");
			
			if (envUser != 0)
			{
				loginTmp = QString(envUser);
			}
		}
	
		if ((loginTmp.isEmpty())&&(pConfig->getBool("FillLoginWithUnixLogin")))
		{
			// try with user
			uid_t userId;
			struct passwd * pw;
			
			userId = geteuid();
			pw = getpwuid(userId);
			if (pw)
			{
				loginTmp = QString(pw->pw_name);
			}
		}
	
		// to change with correct or user defaults
		if (portTmp.isEmpty())
		{
			portTmp = "5432";
		}
	
		if (hostTmp.isEmpty())
		{
			hostTmp = "/tmp";
		}
	}

	// end of to change
	
	cf->setHost(hostTmp);
	cf->setHostAddr(hostAddrTmp);
	cf->setPort(portTmp);
	cf->setDatabase(databaseTmp);
	cf->setLogin(loginTmp);

}

ConnectionDialog::~ConnectionDialog()
{
	if (cf!=0) 
	{
		delete cf;
	}
}

ConnectionParameters * ConnectionDialog::getConnectionParameters()
{
	ConnectionParameters * result = new ConnectionParameters();
	
	result->setHostName(cf->getHost());
	//if HostName is not unix socket then do
	result->setHostAddr(cf->getHostAddr());
	//endif
	
	result->setPort(cf->getPort());
	result->setDatabase(cf->getDatabase());
	result->setLogin(cf->getLogin());
	result->setPassword(cf->getPassword());

	return result;
}

void ConnectionDialog::accept()
{
	// checks

	// IP Format

	QString ipTmp = cf->getHostAddr();

	if (ipTmp.isEmpty() == false)
	{
		ipTmp.replace(QRegExp(" "),"");
		ipTmp.replace(QRegExp("\t"),"");

		if (isIP(ipTmp) == false)
		{
			KMessageBox::error (this,i18n("Field Host IP invalid"));
			return;
		}

		// printf ("Check IP : %s\n",ipTmp.ascii());
		cf->setHostAddr(ipTmp);
	}

	// all checks are ok
	
	return QDialog::accept();
}

