/********************************************************************************
                                ConnectionParameters.h
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "ConnectionParameters.h"

ConnectionParameters::ConnectionParameters()
{
	hostname = "";
	hostaddr = "";
	port = "";
	database = "";
	login = "";
	password = "";
	id = -1;
}

ConnectionParameters::ConnectionParameters(ConnectionParameters const &cp)
{
	hostname = cp.getHostName();
	hostaddr = cp.getHostAddr();
	port = cp.getPort();
	database = cp.getDatabase();
	login = cp.getLogin();
	password = cp.getPassword();
	id = cp.getId();
}

ConnectionParameters::~ConnectionParameters()
{
}

void ConnectionParameters::setHostName(QString const pHostname)
{
	hostname = pHostname;
	return;
}

void ConnectionParameters::setPort(QString const pPort)
{
	port = pPort;
	return;
}

void ConnectionParameters::setDatabase(QString const pDatabase)
{
	database = pDatabase;
	return;
}

void ConnectionParameters::setLogin(QString const pLogin)
{
	login = pLogin;
	return;
}

void ConnectionParameters::setPassword(QString const pPassword)
{
	password = pPassword;
	return;
}

void ConnectionParameters::setId(int const pId)
{
	id = pId;
	return;
}

QString ConnectionParameters::getHostName() const
{
	return hostname;
}

QString ConnectionParameters::getPort() const
{
	return port;
}

QString ConnectionParameters::getDatabase() const
{
	return database;
}

QString ConnectionParameters::getLogin() const
{
	return login;
}

QString ConnectionParameters::getPassword() const
{
	return password;
}

int ConnectionParameters::getId() const
{
	return id;
}

void ConnectionParameters::setHostAddr(QString pHostAddr)
{
	hostaddr = pHostAddr;
	return;
}

QString ConnectionParameters::getHostAddr() const
{
	return hostaddr;
}

QString ConnectionParameters::toString() const
{
	// show object values
	QString result;

	result = "\n";

	result.append("\nhostname = ");
	result.append(hostname);

	result.append("\nhostaddr = ");
	result.append(hostaddr);

	result.append("\nport = ");
	result.append(port);

	result.append("\ndatabase = ");
	result.append(database);

	result.append("\nlogin = ");
	result.append(login);

	result.append("\npassword = ");
	result.append(password);

	result.append("\nid = " + QString::number(id));

	result.append("\n");

	return result;
}

QString ConnectionParameters::buildUrl() const
{
	// return pg connection string
	char connInfo[1000];

	connInfo[0] = '\0';

	// host

	if (hostname.isEmpty() == false)
	{
		sprintf(connInfo, "%s host='%s' ", connInfo, hostname.ascii());
	}

	// hostaddr

	if (hostaddr.isEmpty() == false)
	{
		sprintf(connInfo, "%s hostaddr='%s' ", connInfo, hostaddr.ascii());
	}

	// port

	if (port.isEmpty() == false)
	{
		sprintf(connInfo, "%s port='%s' ", connInfo, port.ascii());
	}

	// dbname

	if (database.isEmpty() == false)
	{
		sprintf(connInfo, "%s dbname='%s' ", connInfo, database.ascii());
	}

	// user

	if (login.isEmpty() == false)
	{
		sprintf(connInfo, "%s user='%s' ", connInfo, login.ascii());
	}

	// password

	if (password.isEmpty() == false)
	{
		sprintf(connInfo, "%s password='%s' ", connInfo, password.ascii());
	}

	//connect_timeout
	//options
	//tty
	//requiressl
	//service

	QString result(connInfo);
	
	return result;
}




