/********************************************************************************
                                   Launcher.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "Launcher.h"

#include "QueryTool.h"
#include "WorkflowTool.h"


extern unsigned int toolWindowsNumber;
extern QArray<QString> toolsArray;



Launcher::Launcher()
{
	// an instance of KApplication must be created before the use of this class
	config = new ToolSuiteConfig(kapp->config());

}

Launcher::~Launcher()
{
	if (config != 0)
	{
		delete config;
		config = 0;
	}
}

bool Launcher::checkAndFindToolToLaunch(KCmdLineArgs *pArgs, QString &pToolToLaunch)
{
	// determine tool to launch

	if (pArgs->isSet("t") == false)
	{
		pToolToLaunch = defaultTool;
		return true;
	}

	pToolToLaunch = (QString) (pArgs->getOption("t"));
	// is tool_tmp a valid tool ?

	unsigned int indexTmp;
	bool tool_tmp_exist;

	tool_tmp_exist = false;
	indexTmp=0;

	while ((tool_tmp_exist == false) && (indexTmp < toolsArray.count())
		&& (toolsArray[indexTmp].isNull() == false))
	{
		if (pToolToLaunch == (toolsArray[indexTmp]))
		{
			tool_tmp_exist = true;
		}
		indexTmp++;
	}

	if (tool_tmp_exist == false)
	{
		return false;
	}

	return true;
}

ToolSkeleton * Launcher::launch(int pToolIndex)
{
	return launch(toolsArray[pToolIndex]);
}

ToolSkeleton * Launcher::launch(QString pToolToLaunch)
{
	ToolSkeleton *toolToLaunch;

#ifdef DEBUG_APP
	printf ("DEBUG_APP Launcher::launch> launch : " + pToolToLaunch + "\n");
#endif

	if (pToolToLaunch == "Query Tool")
	{
		toolToLaunch = new QueryTool (0, pToolToLaunch, config);
		((QueryTool*)toolToLaunch)->updateMenuTools(this, pToolToLaunch);
	} 
	else if (pToolToLaunch == "Workflow Tool")
	{
		toolToLaunch = new WorkflowTool (0, pToolToLaunch, config);
		toolToLaunch->updateMenuTools(this, pToolToLaunch);
	} 
	else 
	{ 
		printf ("Error : tool no matched %s (Launcher::launch)\n", pToolToLaunch.ascii());
		return 0;
	}

	toolToLaunch->show();
	toolWindowsNumber++;

	return toolToLaunch;
}

void Launcher::setDefaultTool(QString pDefaultTool)
{
	defaultTool = pDefaultTool;
}

